/*************************************************************************
 *
 *  $RCSfile: oldsv.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: pl $ $Date: 2001/09/13 11:41:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sv.h>
#undef NOOLDSV

#ifdef REMOTE_APPSERVER
#include <rmevents.hxx>
#include <svapp.hxx>
#include <svdata.hxx>
#else // REMOTE_APPSERVER
#include <svsys.h>
#include <salinst.hxx>
#endif // REMOTE_APPSERVER

#include <tools/debug.hxx>

#include <svdata.hxx>
#include <outdev.h>
#include <outfont.hxx>
#include <svapp.hxx>
#include <wrkwin.hxx>
#include <waitobj.hxx>
#include <fixed.hxx>
#include <system.hxx>
#include <jobset.hxx>
#include <help.hxx>
#include <floatwin.hxx>
#include <vos/process.hxx>

#pragma hdrstop

// ------------------------------------------------------------------------

TYPEINIT0(ApplicationProperty)

// ------------------------------------------------------------------------

static PropertyHandler* pHandler=0;

void Application::Property( ApplicationProperty& rProp )
{
    if ( pHandler )
        pHandler->Property( rProp );
}

void Application::SetPropertyHandler( PropertyHandler* p )
{
    if ( pHandler )
        delete pHandler;
    pHandler = p;
}

void Application::EnterWait()
{
    if ( Application::GetAppWindow() )
        Application::GetAppWindow()->EnterWait();
}

void Application::LeaveWait()
{
    if ( Application::GetAppWindow() )
        Application::GetAppWindow()->LeaveWait();
}

BOOL Application::IsWait()
{
    if ( Application::GetAppWindow() )
        return Application::GetAppWindow()->IsWait();
    else
        return FALSE;
}

// ------------------------------------------------------------------------

WaitObject::WaitObject()
{
    mpWindow = Application::GetAppWindow();
    if ( mpWindow )
        mpWindow->EnterWait();
}

// ------------------------------------------------------------------------

Font System::_GetStandardFont( _StandardFont eStdFont )
{
    OutputDevice* pOutDev = NULL;

    // Get standard, when possible
    if ( ImplGetSVData() && Application::IsInMain() )
        pOutDev = ImplGetDefaultWindow();

    USHORT nType = 0;
    switch ( eStdFont )
    {
        case _STDFONT_SWISS:
            nType = DEFAULTFONT_SANS;
            break;
        case _STDFONT_ROMAN:
            nType = DEFAULTFONT_SERIF;
            break;
        case _STDFONT_FIXED:
            nType = DEFAULTFONT_FIXED;
            break;
        case _STDFONT_SYMBOL:
            nType = DEFAULTFONT_SYMBOL;
            break;
        default:
            nType = DEFAULTFONT_SANS_UNICODE;
            break;
    }

    return OutputDevice::GetDefaultFont( nType, GetSystemLanguage(),
                                         DEFAULTFONT_FLAGS_ONLYONE, pOutDev );
}

// ------------------------------------------------------------------------

void OutputDevice::InvertRect( const Rectangle& rRect )
{
    DBG_ASSERT( OUTDEV_WINDOW == meOutDevType, "OutputDevice::InvertRect(...) is not allowed anymore on Non-Window OutputDevice's!" );

    if ( OUTDEV_WINDOW == meOutDevType )
        ((Window*)this)->Invert( rRect );
}

Color Brush::GetVCLFillColor() const
{
    Color aColor = GetColor();

    switch ( GetStyle() )
    {
        case BRUSH_25:
            {
            ULONG   nRed    = aColor.GetRed();
            ULONG   nGreen  = aColor.GetGreen();
            ULONG   nBlue   = aColor.GetBlue();
            nRed   += (ULONG)(GetFillColor().GetRed())*2;
            nGreen += (ULONG)(GetFillColor().GetGreen())*2;
            nBlue  += (ULONG)(GetFillColor().GetBlue())*2;
            aColor = Color( (BYTE)(nRed/3), (BYTE)(nGreen/3), (BYTE)(nBlue/3) );
            }
            break;

        case BRUSH_50:
            {
            ULONG   nRed    = aColor.GetRed();
            ULONG   nGreen  = aColor.GetGreen();
            ULONG   nBlue   = aColor.GetBlue();
            nRed   += (ULONG)(GetFillColor().GetRed());
            nGreen += (ULONG)(GetFillColor().GetGreen());
            nBlue  += (ULONG)(GetFillColor().GetBlue());
            aColor = Color( (BYTE)(nRed/2), (BYTE)(nGreen/2), (BYTE)(nBlue/2) );
            }
            break;

        case BRUSH_75:
            {
            ULONG   nRed    = aColor.GetRed()*2;
            ULONG   nGreen  = aColor.GetGreen()*2;
            ULONG   nBlue   = aColor.GetBlue()*2;
            nRed   += (ULONG)(GetFillColor().GetRed());
            nGreen += (ULONG)(GetFillColor().GetGreen());
            nBlue  += (ULONG)(GetFillColor().GetBlue());
            aColor = Color( (BYTE)(nRed/3), (BYTE)(nGreen/3), (BYTE)(nBlue/3) );
            }
            break;

        case BRUSH_NULL:
            aColor = Color( COL_TRANSPARENT );
    }

    return aColor;
}

#define OLDSV_STATIC_OBJ_COUNT  5

void OutputDevice::SetPen( const Pen& rNewPen )
{
    DBG_ASSERTWARNING( (rNewPen.GetStyle() == PEN_SOLID) || (rNewPen.GetStyle() == PEN_NULL),
                       "OutputDevice::SetPen() - Only PEN_SOLID and PEN_NULL are allowed" );

    if ( rNewPen.GetStyle() == PEN_NULL )
        SetLineColor();
    else
        SetLineColor( rNewPen.GetColor() );
}

const Pen& OutputDevice::GetPen() const
{
    static USHORT n = 0;
    static Pen aPenAry[OLDSV_STATIC_OBJ_COUNT];
    Pen* pPen = &aPenAry[n];
    n = (n + 1) % OLDSV_STATIC_OBJ_COUNT;
    pPen->SetColor( GetLineColor() );
    if ( IsLineColor() )
        pPen->SetStyle( PEN_SOLID );
    else
        pPen->SetStyle( PEN_NULL );
    return *pPen;
}

void OutputDevice::SetFillInBrush( const Brush& rNewBrush )
{
    if ( rNewBrush.GetStyle() == BRUSH_NULL )
        SetFillColor();
    else
        SetFillColor( rNewBrush.GetVCLFillColor() );
}

const Brush& OutputDevice::GetFillInBrush() const
{
    static USHORT n = 0;
    static Brush aBrushAry[OLDSV_STATIC_OBJ_COUNT];
    Brush* pBrush = &aBrushAry[n];
    n = (n + 1) % OLDSV_STATIC_OBJ_COUNT;
    pBrush->SetColor( GetFillColor() );
    if ( IsFillColor() )
        pBrush->SetStyle( BRUSH_SOLID );
    else
        pBrush->SetStyle( BRUSH_NULL );
    return *pBrush;
}

void OutputDevice::SetBackgroundBrush( const Brush& rNewBrush )
{
    if ( rNewBrush.GetStyle() == BRUSH_NULL )
        SetBackground();
    else
        SetBackground( Wallpaper( rNewBrush.GetVCLFillColor() ) );
}

const Brush& OutputDevice::GetBackgroundBrush() const
{
    static USHORT n = 0;
    static Brush aBrushAry[OLDSV_STATIC_OBJ_COUNT];
    Brush* pBrush = &aBrushAry[n];
    n = (n + 1) % OLDSV_STATIC_OBJ_COUNT;
    pBrush->SetColor( GetBackground().GetColor() );
    if ( IsBackground() )
        pBrush->SetStyle( BRUSH_SOLID );
    else
        pBrush->SetStyle( BRUSH_NULL );
    return *pBrush;
}

Color OutputDevice::GetSolidColor( const Color& rColor ) const
{
    DBG_ERROR( "OutputDevice::GetSolidColor(...) should not be used anymore!" )
    return rColor;
}

// ------------------------------------------------------------------------

void WorkWindow::Minimize()
{
}

void WorkWindow::Maximize()
{
}

void WorkWindow::Restore()
{
}

BOOL WorkWindow::IsMaximized() const
{
    return FALSE;
}

// ------------------------------------------------------------------------
/*
BOOL Application::StartApplication( const String& rFileName,
                                    const String& rParameters,
                                    const String& rCreator,
                                    ApplicationAddress* pAddr )
{
    return FALSE;
}
*/
// ------------------------------------------------------------------------

class ImplAppEventClass
{
public:
    DECL_STATIC_LINK( ImplAppEventClass, CallEvent, void* pEvent );
};

IMPL_STATIC_LINK( ImplAppEventClass, CallEvent, void*, pEvent )
{
    GetpApp()->AppEvent( *((ApplicationEvent*)pEvent) );
    delete (ApplicationEvent*)pEvent;
    return 0;
}

void ImplPostAppEvent( ApplicationEvent* pEvent )
{
    Application::PostUserEvent( STATIC_LINK( NULL, ImplAppEventClass, CallEvent ), pEvent );
}

USHORT Application::DispatchAppEvents( int nArgc, char* pArgv[] )
{
    return DispatchAppEvents();
}

USHORT Application::DispatchAppEvents()
{
    // Open-Events fuer alle Dateien bis zum ersten Schalter
    USHORT              i;
    USHORT              nCount = Application::GetCommandLineParamCount();
    XubString           aArg;
    BOOL                bPrintEvent = FALSE;
    BOOL                bOpenEvent  = TRUE;
    XubString           aPrintList;
    XubString           aOpenList;
    USHORT              nEvents = 0;
    ApplicationEvent*   pAppEvt;

    for( i=0; i < nCount; i++ )
    {
        aArg = GetCommandLineParam( i );
        const xub_Unicode* pArg = aArg.GetBuffer();
        // Erstmal nur mit -, da unter Unix Dateinmane auch mit Slasch anfangen koennen
        if ( (*pArg == '-') /* || (*pArg == '/') */ )
        {
            pArg++;

            // Ein Schalter
            if ( (*pArg == 'p') || (*pArg == 'P') )
            {
                bPrintEvent = TRUE;
                bOpenEvent = FALSE;    // Ab hier keine OpenEvents mehr
            }
        }
        else
        {
            // Dies wird als Dateiname interpretiert
            if ( bOpenEvent )
            {
                // Open Event anhaengen
                if ( aOpenList.Len() )
                    aOpenList += APPEVENT_PARAM_DELIMITER;
                aOpenList += aArg;
            }
            else if ( bPrintEvent )
            {
                // Print Event anhaengen
                if( aPrintList.Len() )
                    aPrintList += APPEVENT_PARAM_DELIMITER;
                aPrintList += aArg;
            }
        }
    }

    if ( !aPrintList.Len() && !aOpenList.Len() )
        return nEvents;

    XubString aEmptyStr;
    if ( aOpenList.Len() )
    {
        // Open Event verschicken
        nEvents |= DISPATCH_OPEN;
        pAppEvt = new ApplicationEvent( aEmptyStr, aEmptyStr,
                                        APPEVENT_OPEN_STRING,
                                        aOpenList );
        ImplPostAppEvent( pAppEvt );
    }
    if ( aPrintList.Len() )
    {
        // Print Event verschicken
        nEvents |= DISPATCH_PRINT;
        pAppEvt = new ApplicationEvent( aEmptyStr, aEmptyStr,
                                        APPEVENT_PRINT_STRING,
                                        aPrintList );
        ImplPostAppEvent( pAppEvt );
    }

    return nEvents;
}

void Application::AppEvent( const ApplicationEvent& rAppEvent )
{
}
