/*************************************************************************
 *
 *  $RCSfile: salimpsound.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _VCL_SALIMPSOUND_HXX
#define _VCL_SALIMPSOUND_HXX

#include <vsound.hxx>

#include <vos/thread.hxx>
#include <vos/mutex.hxx>
#include <vos/socket.hxx>
#include <tools/list.hxx>
#include <tools/link.hxx>

#ifdef USE_OSS
#include <sys/stat.h>
#include <unistd.h>
#endif

#ifdef _USE_NAMESPACE
namespace vcl_sal {
#endif

// OSS can only be used on local displays

#ifdef USE_OSS
	class OSSSound : public VSound,
					 public NAMESPACE_VOS(OThread)
	{
		// thread implementation
		struct OSSData
		{
			OSSSound*	m_pSound;
			long		m_nDataLen;
			long		m_nStartPos;
			long		m_nEndPos;
			long		m_nCurPos;
			int			m_nType;
		};
		DECLARE_LIST( OSSDataList, OSSData* )
		DECLARE_LIST( OSSSoundList, OSSSound* )

		static int						s_nDevice;
		static OSSDataList				s_aDataList;
		static NAMESPACE_VOS(OMutex)	s_aProtector;
		static BOOL						s_bPlaying;
		static OSSSoundList				s_aSounds;

		// from OThread
		virtual void run();
		// static methods
		static BOOL 		open();
		static void 		close();
		static void 		append( OSSSound* );
		static void 		remove( OSSSound* );
		static BOOL			startSound( OSSData* pData );
		static BOOL			startAU( OSSData* pData );
		static BOOL			startRIFF( OSSData* pData );
		static int			findChunk( OSSData* pData, char* pChunk );
		static short int	readLEShort( char* );
		static int			readLEInt( char* );
		static ULONG		readBELong( char* );

		DECL_LINK( notifyStopHdl, void* );
		DECL_LINK( notifyErrorHdl, void* );
	protected:
		virtual BOOL isValid();
	public:
		OSSSound( ::SalSound* pSalSound );
		virtual ~OSSSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();
	};
#endif

// DEVAUDIO can only be used on local displays

#ifdef USE_DEVAUDIO
	class DevAudioSound;
	struct DevAudioData
	{
		DevAudioSound*	m_pSound;
		AudioConverter*	m_pConverter;
		long			m_nDataLen;
		long			m_nStartPos;
		long			m_nEndPos;
		long			m_nCurPos;
		int				m_nType;

		DevAudioData( DevAudioSound* pSound ) :
				m_pSound( pSound ), m_pConverter( NULL ), m_nDataLen( 0 ),
				m_nStartPos( 0 ), m_nEndPos( 0 ), m_nCurPos( 0 ), m_nType( 0 )
			{}
		~DevAudioData()
			{ if( m_pConverter ) delete m_pConverter; }
	};
	DECLARE_LIST( DevAudioDataList, DevAudioData* )
	DECLARE_LIST( DevAudioSoundList, DevAudioSound* )

	class DevAudioSound : public VSound,
						  public NAMESPACE_VOS(OThread)
	{
		// thread implementation

		static int						s_nDevice;
		static DevAudioDataList			s_aDataList;
		static NAMESPACE_VOS(OMutex)	s_aProtector;
		static BOOL						s_bPlaying;
		static DevAudioSoundList		s_aSounds;

		// from OThread
		virtual void run();
		// static methods
		static BOOL 		open();
		static void 		close();
		static void 		append( DevAudioSound* );
		static void 		remove( DevAudioSound* );
		static BOOL			startSound( DevAudioData* pData );
		static BOOL			startAU( DevAudioData* pData );
		static BOOL			startRIFF( DevAudioData* pData );
		static int			findChunk( DevAudioData* pData, char* pChunk );
		static short int	readLEShort( char* );
		static int			readLEInt( char* );
		static ULONG		readBELong( char* );

		DECL_LINK( notifyStopHdl, void* );
		DECL_LINK( notifyErrorHdl, void* );
	protected:
		virtual BOOL isValid();
	public:
		DevAudioSound( ::SalSound* pSalSound );
		virtual ~DevAudioSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();
	};
#endif

	class RPTPSound : public VSound
	{
		DECLARE_LIST( RPTPSoundList, RPTPSound* )

		static BOOL									s_bConnected;
		static NAMESPACE_VOS(OConnectorSocket)		s_aConnector;
		static RPTPSoundList						s_aSounds;
		static NAMESPACE_VOS(OMutex)				s_aProtector;
		static BOOL									s_bFailedOnce;

		static BOOL			connect();
		static void			disconnect();
		static ByteString	readLine();
		static ByteString	sendCommand( const ByteString& rCommand );

		static int getFileDescriptor();
		static RPTPSound* getSoundById( ULONG );
		static ULONG      getMaxId();

		// SalYieldEntry
		static int pending( int, void* );
		static int queued( int, void* );
		static int handleEvents( int, void* );

		ULONG			m_nID;
	protected:
		virtual BOOL isValid();
	public:
		RPTPSound( ::SalSound* pSalSound );

		virtual	~RPTPSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();
	};

#ifdef USE_NAS
	class NASSound : public VSound
	{
		DECLARE_LIST( NASSoundList, NASSound* )
		
		static NASSoundList				s_aSounds;
		static NAMESPACE_VOS(OMutex) 	s_aProtector;
		static void*					s_pServer;
		static BOOL						s_bFailedOnce;

		static BOOL	connect();
		static void disconnect();

		static void callback( void*, void*, void*, void* );
		// SalYieldEntry
		static int pending( int, void* );
		static int queued( int, void* );
		static int handleEvents( int, void* );

		ULONG	m_nFlowID;
	protected:
		virtual BOOL isValid();
	public:
		NASSound( ::SalSound* pSalSound );

		virtual	~NASSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();
	};
#endif

#ifdef _USE_NAMESPACE
}
#endif

#endif
