/*************************************************************************
 *
 *  $RCSfile: salconfig.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: oisin $ $Date: 2001/01/31 15:01:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef DEBUG
#include <stdio.h>
#endif
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <string.h>
#include <math.h>

#include <strhelper.hxx>
#include <salconfig.hxx>

#include <prex.h>
#if !defined(_USE_PRINT_EXTENSION_)
#include <xprinter/xp.h>
#endif
#include <postx.h>

#if !defined(_USE_PRINT_EXTENSION_)
#include <xsalprn.h>
#endif

using namespace vcl_sal;

#define PROFILE_NAME "Xpdefaults"

/**********************************************************************
 *	a helper to write small doubles with dots as decimal points
 **********************************************************************/

static ByteString dtos( double d, int nMaxDecimals )
{
	ByteString aRet;
	double integral, fraction;

	fraction = modf( d, &integral );
	fraction = fraction < 0 ? -fraction : fraction;

	aRet = (int)integral;
	aRet += '.';

	while( fraction != 0.0 && nMaxDecimals-- > 0 )
	{
		fraction *= 10.0;
		int nDecimal = (int)fraction;
		aRet += nDecimal;
		fraction -= (double)nDecimal;
	}
	return aRet;
}

XpDefaults* XpDefaults::pOneInstance	= NULL;
BOOL		XpDefaults::s_bPrivate		= FALSE;
BOOL		XpDefaults::s_bWriteable	= FALSE;

const String& XpDefaults::getProfileName( BOOL bForceSearch )
{
	static String aProfileName;
	static time_t aLastUpdate = time( NULL );

	if( ! aProfileName.Len() || time( NULL ) - aLastUpdate > 5 || bForceSearch )
	{
		static char* pStarEnv = getenv( "SAL_STARPROFILE" );
		static char* pXppathEnv = getenv( "XPPATH" );
		static ByteString aHome;

		rtl_TextEncoding aEncoding = gsl_getSystemTextEncoding();
		
		if( ! aHome.Len() )
		{
			struct passwd* pw = getpwuid( getuid() );
			if( pw )
				aHome = pw->pw_dir;
			if( ! aHome.Len() )
			{
				// strange ... lets try HOME
				char* pEnv = getenv( "HOME" );
				if( pEnv )
					aHome = pEnv;
				else
					// oops ... default too /
					aHome = '/';
			}
		}

		// first look for starprofile environment variable
		if( pStarEnv && ! access( pStarEnv, F_OK ) )
			aProfileName = String( pStarEnv, aEncoding );
		else
		{
			// next look for private profile
			ByteString aFile( aHome );
			aFile += "/.";
			aFile += PROFILE_NAME;
			if( ! access( aFile.GetBuffer(), F_OK ) )
			{
				aProfileName	= String( aFile, aEncoding );
				s_bPrivate		= TRUE;
			}
			else if( pXppathEnv )
			{
				aFile = pXppathEnv;
				aFile += "/";
				aFile += PROFILE_NAME;
				if( ! access( aFile.GetBuffer(), F_OK ) )
					aProfileName = String( aFile, aEncoding );
			}
		}
		s_bWriteable = access( ByteString( aProfileName, aEncoding ).GetBuffer(), W_OK ) ? FALSE : TRUE;
	}
	return aProfileName;
}

/**********************************************************************
 *	XpDefaults::getXpDefaults
 *	ensures that only one instance exists of this
 **********************************************************************/

XpDefaults& XpDefaults::getXpDefaults()
{
	if( ! pOneInstance )
		pOneInstance = new XpDefaults();
	return *pOneInstance;
}

/**********************************************************************
 *	XpDefaults::release
 *	releases the XpDefaults instance (called from salinstance)
 **********************************************************************/

void XpDefaults::release()
{
	delete pOneInstance;
	pOneInstance = NULL;
}

/**********************************************************************
 *	XpDefaults::XpDefaults
 **********************************************************************/

XpDefaults::XpDefaults() :
		Config( getProfileName() )
{
	SetLineEnd( LINEEND_LF );
#ifdef DEBUG
	fprintf( stderr, "constructed XpDefaults from \"%s\"\n",
			 ByteString( getProfileName(), gsl_getSystemTextEncoding() ).GetBuffer() );
#endif
}

/**********************************************************************
 *	XpDefaults::~XpDefaults
 **********************************************************************/

XpDefaults::~XpDefaults()
{
}

/**********************************************************************
 *	XpDefaults::writeSetupSection
 **********************************************************************/

void XpDefaults::writeSetupSection( void* pSetup, const ByteString& rGroup )
{
	rtl_TextEncoding aEncoding = gsl_getSystemTextEncoding();

	XSalPrinterSetup* pSet = (XSalPrinterSetup*)pSetup;
	ByteString aPPD = rGroup.GetToken( 0, ',' );
	PPDParser* pParser = PPDParser::getParser( String( aPPD, aEncoding ) );
	if( pSet && pParser )
	{
		// delete all PPD_ keys in rGroup
		SetGroup( rGroup );
		for( int k = 0; k < GetKeyCount(); k++ )
		{
			ByteString aKey = GetKeyName( k );
			if( aKey.CompareTo( "PPD_", 4 ) == COMPARE_EQUAL )
			{
				DeleteKey( aKey );
				k--;
			}
		}
		
		PPDContext aContext;
		aContext.setParser( pParser );
		if( pSet->nVersion >= 3 )
			aContext.rebuildFromStreamBuffer( ((char*)pSet) + sizeof( XSalPrinterSetup ), pSet->nTrailingBytes );

		// safety
		SetGroup( rGroup );

		WriteKey( "Scale", dtos( ((double)pSet->nScale)/100.0, 3 ) );
		WriteKey( "Copies", pSet->nCopies );
		WriteKey( "BitmapCompression", pSet->nFlags & XSALPRINTERSETUP_FLAG_COMPRESS ? "1" : "0" );
		WriteKey( "BitmapColor", pSet->nFlags & XSALPRINTERSETUP_FLAG_COLOR ? "1" : "0" );
		WriteKey( "Orientation", pSet->eOrientation == ORIENTATION_LANDSCAPE ? "LANDSCAPE" : "PORTRAIT" );
		WriteKey( "Level", pSet->nFlags & XSALPRINTERSETUP_FLAG_LEVEL );
		WriteKey( "PageSize",
				  ByteString(
					  pParser->matchPaper( (int)((double)pSet->nPaperWidth / 35.277778),
										   (int)((double)pSet->nPaperHeight / 35.277778) ),
					  aEncoding ) );
		// write context keys
		for( int i = 0; i < aContext.countValuesModified(); i++ )
		{
			PPDKey* pKey = aContext.getModifiedKey( i );
			ByteString aKeyName( "PPD_" );
			aKeyName += ByteString( pKey->getKey(), RTL_TEXTENCODING_ISO_8859_1 );
			PPDValue* pValue = aContext.getValue( pKey );
			if( pValue )
				WriteKey( aKeyName, ByteString( pValue->maOption, RTL_TEXTENCODING_ISO_8859_1 ) );
			else
				WriteKey( aKeyName, "*nil" );
		}
	}
}

/**********************************************************************
 *	XpDefaults::readDefaults
 **********************************************************************/

void XpDefaults::readDefaults( void* pSetup, const ByteString& rGroup, PPDParser* pParser )
{
	XSalPrinterSetup* pSet = (XSalPrinterSetup*)pSetup;
	SetGroup( rGroup );
	double fScale = StringToDouble( ReadKey( "Scale", "0" ) );
	if( fScale != 0.0 )
		pSet->nScale = (int)(100.0*fScale);
	int nCopies = ReadKey( "Copies", "0" ).ToInt32();
	if( nCopies )
		pSet->nCopies = nCopies;
	int nCompr = ReadKey( "BitmapCompression", "255" ).ToInt32();
	if( nCompr != 255 )
	{
		if( nCompr )
			pSet->nFlags |= XSALPRINTERSETUP_FLAG_COMPRESS;
		else
			pSet->nFlags &= ~XSALPRINTERSETUP_FLAG_COMPRESS;
	}
	int nColor = ReadKey( "BitmapColor", "255" ).ToInt32();
	if( nColor != 255 )
	{
		if( nColor )
			pSet->nFlags |= XSALPRINTERSETUP_FLAG_COLOR;
		else
			pSet->nFlags &= ~XSALPRINTERSETUP_FLAG_COLOR;
	}
	int nLevel = ReadKey( "Level", "255" ).ToInt32();
	if( nLevel != 255 )
	{
		pSet->nFlags &= ~XSALPRINTERSETUP_FLAG_LEVEL;
		pSet->nFlags |= XSALPRINTERSETUP_FLAG_LEVEL & nLevel;
	}
	
	ByteString aOri = ReadKey( "Orientation" );
	if( aOri.CompareIgnoreCaseToAscii( "PORTRAIT" ) == COMPARE_EQUAL )
		pSet->eOrientation = ORIENTATION_PORTRAIT;
	else if( aOri.CompareIgnoreCaseToAscii( "LANDSCAPE" ) == COMPARE_EQUAL )
		pSet->eOrientation = ORIENTATION_LANDSCAPE;
	
	if( pParser )
	{
		ByteString aPaper = ReadKey( "PageSize" );
		if( aPaper.Len() )
		{
			// #75466# know our enums
			// (blaech ... two ways to specify paper sizes ... how ugly)
			int ePaper = XSalGetPaper( aPaper.GetBuffer() );
			if( ePaper != -1 && ePaper != PAPER_USER )
			{
				pSet->ePaper = ePaper;
				pSet->nPaperHeight = pSet->nPaperWidth = 0;
			}
			else
			{
				int w, h;
				if( pParser->getPaperDimension( String( aPaper, RTL_TEXTENCODING_ISO_8859_1 ), w, h ) )
				{
					pSet->ePaper = PAPER_USER;
					pSet->nPaperWidth = w * 35.277778;
					pSet->nPaperHeight = h * 35.277778;
				}
			}
		}
	}
}

/**********************************************************************
 *	XpDefaults::readSetupSection
 **********************************************************************/

void* XpDefaults::readSetupSection( const ByteString& rGroup )
{
	ByteString aPPD = rGroup.GetToken( 0, ',' );
	ByteString aPort = rGroup.GetToken( 2, ',' );
	PPDParser* pParser = PPDParser::getParser( String( aPPD, gsl_getSystemTextEncoding() ) );

	XSalPrinterSetup aSetup;
	memset( &aSetup, 0, sizeof( aSetup ) );
	XSalInitPrinterSetup( &aSetup );
	aSetup.eDriver = 0;
	strncpy( aSetup.sPort, aPort.GetBuffer(), sizeof( aSetup.sPort ) );
	strncpy( aSetup.cDriverName, aPPD.GetBuffer(), sizeof( aSetup.cDriverName ) );

	// fill in for compatibility
	SetGroup( "ports" );
	ByteString aCommand = ReadKey( aPort );
	strncpy( aSetup.sCompatCommand, aCommand.GetBuffer(), sizeof( aSetup.sCompatCommand ) );

	// native defaults
	if( pParser )
	{
		aSetup.nFlags &= ~XSALPRINTERSETUP_FLAG_LEVEL;
		aSetup.nFlags |= pParser->getLanguageLevel() &XSALPRINTERSETUP_FLAG_LEVEL;
		aSetup.nFlags &= ~XSALPRINTERSETUP_FLAG_COLOR_DEFAULT;
		if( pParser->isColorDevice() )
			aSetup.nFlags |= XSALPRINTERSETUP_FLAG_COLOR;
		else
			aSetup.nFlags &= ~XSALPRINTERSETUP_FLAG_COLOR;
	} 

	void* pRet = NULL;

	readDefaults( &aSetup, "Xprinter,PostScript", pParser );
	ByteString aDriverGroup( aPPD );
	aDriverGroup += ",PostScript";
	readDefaults( &aSetup, aDriverGroup, pParser );
	readDefaults( &aSetup, rGroup, pParser );
	if( pParser )
	{
		PPDContext aContext;
		aContext.setParser( pParser );

		SetGroup( rGroup );
		for( int i = 0; i < GetKeyCount(); i++ )
		{
			ByteString aKey = GetKeyName( i );
			if( aKey.CompareTo( "PPD_", 4 ) == COMPARE_EQUAL )
			{
				aKey.Erase( 0, 4 );
				ByteString aValue = ReadKey( i );
				PPDKey* pKey = pParser->getKey( String( aKey, RTL_TEXTENCODING_ISO_8859_1 ) );
				if( pKey )
				{
					if( aValue == "*nil" )
						aContext.setValue( pKey, NULL, TRUE );
					else
					{
						PPDValue* pValue = pKey->getValue( String( aValue, RTL_TEXTENCODING_ISO_8859_1 ) );
						aContext.setValue( pKey, pValue, TRUE );
					}
				}
			}
		}
		ULONG nStreamBytes;
		void* pStreamBuffer = aContext.getStreamableBuffer( nStreamBytes );
		aSetup.nTrailingBytes = nStreamBytes;
		char* pBuffer = new char[ sizeof( XSalPrinterSetup ) + nStreamBytes ];
		memcpy( pBuffer, &aSetup, sizeof( aSetup ) );
		memcpy( pBuffer + sizeof( aSetup ), pStreamBuffer, nStreamBytes );
		pRet = pBuffer;
		delete pStreamBuffer;
	}
	else
	{
		aSetup.nTrailingBytes = 0;
		pRet = new char[ sizeof( aSetup ) ];
		memcpy( pRet, &aSetup, sizeof( aSetup ) );
	}
	return pRet;
}

/**********************************************************************
 *	XpDefaults::checkEquivPrinter
 **********************************************************************/

String XpDefaults::checkEquivPrinter( const String& sName, const String& sDevKey )
{
	int i, nCount;
	ByteString sName1, sName2, sPort1, sPort2, sDriver1, sDriver2, aString;

	sName1   = ByteString( sName, RTL_TEXTENCODING_UTF8 );
	
	SetGroup( "devices" );
	if( sDevKey.Len() )
		aString = ByteString( sDevKey, gsl_getSystemTextEncoding() );
	else
		aString = ReadKey( sName1 );
	
	sPort1   = aString.GetToken( 1, ',' );
	sPort1.EraseLeadingChars();
	sPort1.EraseTrailingChars();
	sDriver1 = aString.EraseLeadingChars().GetToken( 0, ' ' );
	
	for( i = 0, nCount = GetKeyCount(); i < nCount; i++ )
	{
		aString = ReadKey( i );
		aString.EraseLeadingChars();
		sDriver2 = aString.GetToken( 0, ' ' );
		sDriver2.EraseTrailingChars();
		sPort2   = aString.GetToken( 1, ',' );
		sPort2.EraseLeadingChars();
		sPort2.EraseTrailingChars();
		sName2 = GetKeyName( i );
		if( sPort2 == sPort1  &&  sDriver1 == sDriver2 && sName1 != sName2 )
		{
			String aRet( sName2, RTL_TEXTENCODING_UTF8 );
			aRet += '=';
			aRet += String( ReadKey( i ), RTL_TEXTENCODING_ISO_8859_1 );
			return aRet;
		}
	}
	return String();
}

/**********************************************************************
 *	external functions for xprinter library
 **********************************************************************/

/**********************************************************************
 *	XpGetProfileString
 **********************************************************************/
extern "C"
int XpGetProfileString( const char* pSection,
						const char* pKey,
						const char* pDef,
						char* pBuffer,
						int nLen )
{
	XpDefaults::getXpDefaults().SetGroup( pSection );
	ByteString aValue = XpDefaults::getXpDefaults().ReadKey( pKey, pDef );
	if( pBuffer )
		strncpy( pBuffer, aValue.GetBuffer(), nLen );
	return aValue.Len();
}

/**********************************************************************
 *	XpWriteProfileString
 **********************************************************************/
extern "C"
char XpWriteProfileString( const char* pSection,
						   const char* pKey,
						   const char* pValue )
{
	XpDefaults::getXpDefaults().SetGroup( pSection );
	XpDefaults::getXpDefaults().WriteKey( pKey, pValue);
	return TRUE;
}

/**********************************************************************
 *	XpGetProfileSection
 **********************************************************************/
extern "C"
char** XpGetProfileSection( const char* pSection, int* pLen, const char* pDummy )
{
	XpDefaults::getXpDefaults().SetGroup( pSection );
	*pLen = XpDefaults::getXpDefaults().GetKeyCount();

	if( ! *pLen )
		return NULL;

	char** pRet = (char**)malloc( *pLen*sizeof( char* ) );
	for( int i = 0; i < *pLen; i++ )
	{
		ByteString aEntry( XpDefaults::getXpDefaults().GetKeyName( i ) );
		aEntry += "=";
		aEntry += XpDefaults::getXpDefaults().ReadKey( i );
		pRet[i] = strdup( aEntry.GetBuffer() );
	}
	return pRet;
}
