/*************************************************************************
 *
 *  $RCSfile: lst_dlst.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "lst_dlst.h"


#include "new_del.h"



/*** List ***/

void
ListDataList_CTOR( ListDataList_THIS,
				   Bool	i_bAutoDeleteData )
{
	THIS_->dpStart = 0;
	THIS_->pEnd = 0;
	THIS_->bAutoDeleteData = i_bAutoDeleteData;
}

void
ListDataList_DTOR( ListDataList_THIS )
{
	LDL_Empty(THIS_, THIS_->bAutoDeleteData);
}

void
LDL_Add( ListDataList_THIS,
		 ListTagData * i_pData )
{
	LDLElem * dpNewElem = 0;
	ASSIGN_NEW1(dpNewElem,LDLElem,i_pData);

	if (pThis->dpStart != 0)
	{
		LDLE_SetNext(pThis->pEnd,dpNewElem);
		pThis->pEnd = dpNewElem;
	}
	else
	{
		pThis->dpStart = dpNewElem;
		pThis->pEnd = pThis->dpStart;
	}
}

void
LDL_Empty( ListDataList_THIS,
		   Bool			  i_bDeleteData )
{
	LDLElem * pIter = 0;
	LDLElem * pDel =  0;

	if (pThis->dpStart == 0)
		return;

	pIter = LDLE_Next(pThis->dpStart);
	pDel =  pThis->dpStart;
	if (i_bDeleteData)
	{
		LDLE_DeleteData( pDel );
	}
	DELETE( pDel, LDLElem );


	while( pIter != 0 )
	{
		pDel = pIter;
		pIter = LDLE_Next(pIter);
		if (i_bDeleteData)
		{
			LDLE_DeleteData( pDel );
		}
		DELETE( pDel, LDLElem );
	}	/* end while */

	pThis->dpStart = 0;
	pThis->pEnd = 0;
}

LDLIterator
LDL_Begin( ListDataList_THIS )
{
	LDLIterator ret;
	LDLIterator_CTOR( &ret, pThis->dpStart );
	return ret;
}


/*** ListIterator ***/

void
LDLIterator_CTOR( LDLIterator_THIS,
				  LDLElem * i_pStart )
{
	pThis->pElement = i_pStart;
}

void
LDLI_opp( LDLIterator_THIS )
{
	if (pThis->pElement != 0)
		pThis->pElement = LDLE_Next(pThis->pElement);
}


Bool
LDLI_obool( LDLIterator_THIS )
{
	return pThis->pElement != 0;
}

ListTagData * 
LDLI_optr( LDLIterator_THIS )
{
	return pThis->pElement != 0
			? LDLE_Data(pThis->pElement)
			: 0;
}


/*** ListElement ***/

void
LDLElem_CTOR( LDLElem_THIS,
			  ListTagData * i_pData )
{
	pThis->pData = i_pData;
	pThis->pNext = 0;
}

void
LDLElem_DTOR( LDLElem_THIS )
{
}

ListTagData * 
LDLE_Data( LDLElem_THIS )
{
	return pThis->pData;
}

LDLElem *
LDLE_Next( LDLElem_THIS )
{
	return pThis->pNext;
}

void
LDLE_SetNext( LDLElem_THIS,
			  LDLElem *	i_pNext )
{
	pThis->pNext = i_pNext;
}

void
LDLE_DeleteData( LDLElem_THIS )
{
	DELETE(THIS_->pData,ListTagData);
}


