/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.PathPattern;
import com.jclark.xsl.expr.PathPatternBase;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PatternList {
    private Hashtable nameRules = new Hashtable();
    private Vector[] typeRules = new Vector[6];
    private Vector anyNameRules = new Vector();

    public Object get(Node node, ExprContext exprContext) throws XSLException {
        Vector vector = this.getVector(node);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (((PathPattern)vector.elementAt(n2)).matches(node, exprContext)) {
                return vector.elementAt(n2 + 1);
            }
            n2 += 2;
        }
        return null;
    }

    public PatternList() {
        int n = 0;
        do {
            this.typeRules[n] = new Vector();
        } while (++n < 6);
    }

    public void add(PathPattern pathPattern, Object object) {
        PathPatternBase pathPatternBase = (PathPatternBase)pathPattern;
        Name name = pathPatternBase.getMatchName();
        if (name == null) {
            byte by = pathPatternBase.getMatchNodeType();
            PatternList.append(this.typeRules[by], pathPatternBase, object);
            switch (by) {
                case 0: 
                case 2: 
                case 4: {
                    Enumeration enumeration = this.nameRules.elements();
                    while (enumeration.hasMoreElements()) {
                        PatternList.append((Vector)enumeration.nextElement(), pathPatternBase, object);
                    }
                    PatternList.append(this.anyNameRules, pathPatternBase, object);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        Vector vector = (Vector)this.nameRules.get(name);
        if (vector == null) {
            vector = (Vector)this.anyNameRules.clone();
            this.nameRules.put(name, vector);
        }
        PatternList.append(vector, pathPatternBase, object);
    }

    private Vector getVector(Node node) {
        Vector vector;
        Name name = node.getName();
        if (name != null && (vector = (Vector)this.nameRules.get(name)) != null) {
            return vector;
        }
        return this.typeRules[node.getType()];
    }

    public Enumeration getAll(Node node, ExprContext exprContext) {
        return new MatchEnumeration(this.getVector(node).elements(), node, exprContext);
    }

    private static void append(Vector vector, PathPattern pathPattern, Object object) {
        vector.addElement(pathPattern);
        vector.addElement(object);
    }

    private static class MatchEnumeration
    implements Enumeration {
        private Enumeration possibleMatches;
        private Node node;
        private Object nextMatch;
        private ExprContext context;

        public Object nextElement() {
            Object object = this.nextMatch;
            this.setNextMatch();
            return object;
        }

        MatchEnumeration(Enumeration enumeration, Node node, ExprContext exprContext) {
            this.node = node;
            this.possibleMatches = enumeration;
            this.context = exprContext;
            this.setNextMatch();
        }

        public boolean hasMoreElements() {
            return this.nextMatch != null;
        }

        void setNextMatch() {
            while (this.possibleMatches.hasMoreElements()) {
                PathPattern pathPattern = (PathPattern)this.possibleMatches.nextElement();
                try {
                    if (pathPattern.matches(this.node, this.context)) {
                        this.nextMatch = this.possibleMatches.nextElement();
                        return;
                    }
                }
                catch (XSLException xSLException) {}
                this.possibleMatches.nextElement();
            }
            this.nextMatch = null;
        }
    }
}

