/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NbProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -4535211234565221486L;
    private static ErrorManager execLog;
    private String processName;
    private String arguments;
    private String info;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Runtime;
    static /* synthetic */ Class class$org$openide$execution$NbProcessDescriptor;

    public NbProcessDescriptor(String string, String string2) {
        this(string, string2, null);
    }

    public NbProcessDescriptor(String string, String string2, String string3) {
        this.processName = string;
        this.arguments = string2;
        this.info = string3;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getInfo() {
        return this.info;
    }

    public Process exec(Format format, String[] stringArray, File file) throws IOException {
        return this.exec(format, stringArray, false, file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Process exec(Format format, String[] stringArray, boolean bl, File file) throws IOException {
        int n;
        int n2;
        Object object;
        Iterator iterator;
        block21: {
            Process process;
            block20: {
                String string = format == null ? this.arguments : format.format(this.arguments);
                String[] stringArray2 = NbProcessDescriptor.parseArguments(string);
                String[] stringArray3 = null;
                stringArray = NbProcessDescriptor.substituteEnv(format, stringArray);
                if (Utilities.getOperatingSystem() == 8192 && this.isJavaCmd(stringArray2)) {
                    stringArray3 = this.constructVMSCmdLine(format, stringArray2);
                } else {
                    stringArray3 = new String[stringArray2.length + 1];
                    stringArray3[0] = format == null ? this.processName : format.format(this.processName);
                    System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
                }
                NbProcessDescriptor.logArgs(stringArray3);
                if (stringArray != null && bl) {
                    String string2;
                    HashMap hashMap = new HashMap(100);
                    iterator = System.getProperties().entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) break;
                        Map.Entry entry = (Map.Entry)iterator.next();
                        string2 = (String)entry.getKey();
                        if (!string2.startsWith("Env-")) continue;
                        object = string2.substring(4);
                        hashMap.put((String)object, entry.getValue());
                    }
                    n2 = 0;
                    while (true) {
                        if (n2 >= stringArray.length) {
                            stringArray = new String[hashMap.size()];
                            int n3 = 0;
                            iterator = hashMap.entrySet().iterator();
                            break;
                        }
                        string2 = stringArray[n2];
                        int n4 = string2.indexOf(61);
                        if (n4 == -1) {
                            throw new IOException("No equal sign in name=value: " + string2);
                        }
                        hashMap.put(string2.substring(0, n4), string2.substring(n4 + 1));
                        ++n2;
                    }
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        stringArray[n3++] = (String)object.getKey() + '=' + (String)object.getValue();
                    }
                }
                n = Utilities.getOperatingSystem();
                iterator = null;
                n2 = 0;
                try {
                    if (n == 4) {
                        iterator = Thread.currentThread();
                        n2 = ((Thread)((Object)iterator)).getPriority();
                        ((Thread)((Object)iterator)).setPriority(5);
                    }
                    if (file == null) {
                        if (stringArray == null) {
                            Process process2 = Runtime.getRuntime().exec(stringArray3);
                            Object var15_22 = null;
                            if (n != 4) return process2;
                            ((Thread)((Object)iterator)).setPriority(n2);
                            return process2;
                        }
                        process = Runtime.getRuntime().exec(stringArray3, stringArray);
                        break block20;
                    }
                    try {
                        Method method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = NbProcessDescriptor.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("exec", array$Ljava$lang$String == null ? (array$Ljava$lang$String = NbProcessDescriptor.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = NbProcessDescriptor.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$File == null ? (class$java$io$File = NbProcessDescriptor.class$("java.io.File")) : class$java$io$File);
                        object = (Process)method.invoke((Object)Runtime.getRuntime(), stringArray3, stringArray, file);
                        break block21;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Class clazz;
                        if (class$org$openide$execution$NbProcessDescriptor == null) {
                            clazz = class$org$openide$execution$NbProcessDescriptor = NbProcessDescriptor.class$("org.openide.execution.NbProcessDescriptor");
                            throw new IOException(NbBundle.getBundle(clazz).getString("EXC_no_JDK13_exec"));
                        }
                        clazz = class$org$openide$execution$NbProcessDescriptor;
                        throw new IOException(NbBundle.getBundle(clazz).getString("EXC_no_JDK13_exec"));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        ErrorManager.getDefault().notify(throwable);
                        throw new IOException(throwable.toString());
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(exception);
                        throw new IOException(exception.toString());
                    }
                }
                catch (Throwable throwable) {
                    Object var15_25 = null;
                    if (n != 4) throw throwable;
                    ((Thread)((Object)iterator)).setPriority(n2);
                    throw throwable;
                }
            }
            Object var15_23 = null;
            if (n != 4) return process;
            ((Thread)((Object)iterator)).setPriority(n2);
            return process;
        }
        Object var15_24 = null;
        if (n != 4) return object;
        ((Thread)((Object)iterator)).setPriority(n2);
        return object;
    }

    private static void logArgs(String[] stringArray) {
        try {
            ResourceBundle resourceBundle = NbBundle.getBundle("org.openide.execution.Bundle");
            String string = resourceBundle.getString("CTL_Exec");
            String string2 = resourceBundle.getString("FMT_ExecParams");
            MessageFormat messageFormat = new MessageFormat(string2);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(string);
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println(messageFormat.format(new Object[]{new Integer(n), stringArray[n]}));
                ++n;
            }
            printWriter.close();
            NbProcessDescriptor.getExecLog().log(1, stringWriter.toString());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(exception);
        }
    }

    public Process exec(Format format, String[] stringArray) throws IOException {
        return this.exec(format, stringArray, null);
    }

    public Process exec(Format format) throws IOException {
        return this.exec(format, null);
    }

    public Process exec() throws IOException {
        return this.exec(null, null);
    }

    public int hashCode() {
        return this.processName.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NbProcessDescriptor)) {
            return false;
        }
        NbProcessDescriptor nbProcessDescriptor = (NbProcessDescriptor)object;
        return this.processName.equals(nbProcessDescriptor.processName) && this.arguments.equals(nbProcessDescriptor.arguments);
    }

    private static String[] parseArguments(String string) {
        return Utilities.parseParameters(string);
    }

    private static ErrorManager getExecLog() {
        if (execLog == null) {
            execLog = ErrorManager.getDefault().getInstance("IDE-Exec");
        }
        return execLog;
    }

    private boolean isJavaCmd(String[] stringArray) {
        return stringArray.length > 0 && (this.processName.endsWith("{/}java") || this.processName.endsWith("{/}javac"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] constructVMSCmdLine(Format format, String[] stringArray) throws IOException {
        PrintWriter printWriter = null;
        File file = null;
        String string = null;
        try {
            file = File.createTempFile("compilerparams", "pms");
            file.deleteOnExit();
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) == '@' && this.processName.endsWith("{/}javac")) {
                    string = new String(stringArray[n]);
                } else {
                    printWriter.println(stringArray[n]);
                }
                ++n;
            }
            Object var9_8 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        String[] stringArray2 = string != null ? new String[4] : new String[3];
        stringArray2[0] = format == null ? this.processName : format.format(this.processName);
        stringArray2[1] = "-V";
        stringArray2[2] = file.getAbsolutePath();
        if (stringArray2.length > 3) {
            stringArray2[3] = string;
        }
        return stringArray2;
    }

    private static String[] substituteEnv(Format format, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || format == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            stringArray2[n] = stringArray[n];
            if (stringArray2[n] != null && (n2 = stringArray2[n].indexOf(61)) >= 0) {
                String string = stringArray2[n].substring(n2 + 1);
                String string2 = stringArray2[n].substring(0, n2);
                stringBuffer.append(string2).append('=').append(format.format(string));
                stringArray2[n] = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
            ++n;
        }
        return stringArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

