/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.ErrorManager;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassLoader;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.InputOutput;

public class ThreadExecutor
extends Executor {
    static final long serialVersionUID = -7160546092135474445L;
    static /* synthetic */ Class class$org$openide$execution$ThreadExecutor;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(ExecInfo execInfo) throws IOException {
        ExecutorTask executorTask;
        TERunnable tERunnable = new TERunnable(execInfo);
        InputOutput inputOutput = this.needsIO() ? null : InputOutput.NULL;
        TERunnable tERunnable2 = tERunnable;
        synchronized (tERunnable2) {
            executorTask = ExecutionEngine.getDefault().execute(execInfo.getClassName(), tERunnable, inputOutput);
            tERunnable.setInputOutput(executorTask.getInputOutput());
            try {
                tERunnable.wait();
                Throwable throwable = tERunnable.getException();
                if (throwable != null && !(throwable instanceof ThreadDeath)) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw new FoldingIOException(throwable);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new FoldingIOException(interruptedException);
            }
        }
        return executorTask;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$execution$ThreadExecutor == null ? (class$org$openide$execution$ThreadExecutor = ThreadExecutor.class$("org.openide.execution.ThreadExecutor")) : class$org$openide$execution$ThreadExecutor);
    }

    protected void checkClass(Class clazz) throws IOException {
        Method method;
        try {
            method = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ThreadExecutor.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IOException iOException = new IOException(noSuchMethodException.toString());
            ErrorManager.getDefault().annotate(iOException, 256, null, NbBundle.getMessage(class$org$openide$execution$ThreadExecutor == null ? (class$org$openide$execution$ThreadExecutor = ThreadExecutor.class$("org.openide.execution.ThreadExecutor")) : class$org$openide$execution$ThreadExecutor, "EXC_NoSuchMethodException"), noSuchMethodException, null);
            throw iOException;
        }
        if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE) {
            IOException iOException = new IOException("wrong signature");
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(class$org$openide$execution$ThreadExecutor == null ? (class$org$openide$execution$ThreadExecutor = ThreadExecutor.class$("org.openide.execution.ThreadExecutor")) : class$org$openide$execution$ThreadExecutor, "EXC_not_public_static_void"));
            throw iOException;
        }
    }

    protected void executeClass(Class clazz, String[] stringArray) {
        try {
            Method method = clazz.getDeclaredMethod("main", stringArray.getClass());
            method.setAccessible(true);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof ThreadDeath)) {
                invocationTargetException.getTargetException().printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected ClassLoader createClassLoader(InputOutput inputOutput) {
        return new NbClassLoader(inputOutput);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TERunnable
    implements Runnable {
        private Throwable exception;
        private ExecInfo info;
        private InputOutput io;

        TERunnable(ExecInfo execInfo) {
            this.info = execInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String string = this.info.getClassName();
            String[] stringArray = this.info.getArguments();
            Class<?> clazz = null;
            TERunnable tERunnable = this;
            synchronized (tERunnable) {
                try {
                    try {
                        ClassLoader classLoader = ThreadExecutor.this.createClassLoader(this.io);
                        clazz = classLoader.loadClass(string);
                        if (clazz == null) {
                            throw new IOException();
                        }
                        if (clazz.getClassLoader() != classLoader) {
                            ErrorManager.getDefault().log(16, "The class " + clazz.getName() + " was loaded by an unexpected classloader: " + clazz.getClassLoader() + ". Usually this means you are trying to run a class from Filesystems via internal execution that is also in an enabled module JAR. The version in the JAR is being used.");
                        }
                        ThreadExecutor.this.checkClass(clazz);
                    }
                    catch (Exception exception) {
                        this.exception = exception;
                        Object var8_8 = null;
                        this.notifyAll();
                        return;
                    }
                    catch (LinkageError linkageError) {
                        this.exception = linkageError;
                        Object var8_9 = null;
                        this.notifyAll();
                        return;
                    }
                    Object var8_7 = null;
                    this.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.notifyAll();
                    throw throwable;
                }
            }
            ThreadExecutor.this.executeClass(clazz, stringArray);
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setInputOutput(InputOutput inputOutput) {
            this.io = inputOutput;
        }
    }
}

