/*************************************************************************
 *
 *  $RCSfile: getchobj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _GETCHOBJ_HXX
#define _GETCHOBJ_HXX

#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _INETSES_HXX //autogen
#include <inet/inetsess.hxx>
#endif

#ifndef _INETMAI_HXX //autogen
#include <inet/inetmain.hxx>
#endif

#ifndef _INETBND_HXX //autogen
#include <so3/inetbnd.hxx>
#endif

class Downloader;

class GetChannelObj : public SfxListener
{
	INetSessionRef			xINetSession;
	INetHttpConnection*		pHttpCon;
	INetHttpGetRequest*		pHttpGetReq;
	USHORT					nRedirectCount;

	INetFtpConnection*		pFtpCon;
	INetFtpGetDirReq*		pFtpGetDirReq;
	INetFtpGetFileReq*		pFtpGetFileReq;

	SvBindStatusCallbackRef	xCallBack;
	SvLockBytes*			pData;

	Downloader*				pBTXDecoder;
	ULONG					nBTXError;

	void*					pUserData;

	Link					aProgressHdl;
	Link 					aCallBackHdl;
	ULONG					nTotalSize;
	ULONG					nBytesCopied;

	INetURLObject 			aURL;
	String					aLocalFile;
	String 					aLocalSrcFile;
	AutoTimer				aLocalTimer;

	BOOL					bFinished;
	BOOL					bCloseIt;
	BOOL 					bSuccess;
	BOOL					bAllowUI;
	BOOL					bShowStatus;

	void CreateNewHttpDownload();
	void CreateNewFtpDownload();
	void CreateNewBTXDownload();
	void CloseDownload(BOOL bSuc);

	void CloseConnection();
	void WriteToFile(SvLockBytes* pLockBytes);
	void GetINetError(ULONG nId, INetRequest* pReq = NULL);

	DECL_LINK(LocalDownload, void*);
	DECL_LINK(BTXCallBack, void*);
protected:
	virtual void SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
								const SfxHint& rHint, const TypeId& rHintType);

public:
	GetChannelObj(INetSession* pSession);
	~GetChannelObj();

	void 					SetBTXDecoder(Downloader* pDecoder);

	void					SetShowStatus(BOOL bNew)	{ bShowStatus = bNew; }
	void					SetAllowUI(BOOL bNew)	   	{ bAllowUI = bNew; }
	BOOL 					IsSuccess() const 		   	{ return bSuccess; }
	BOOL 					IsFinish() const 		   	{ return bFinished; }
	ULONG					GetBTXError() const 		{ return nBTXError; }

	void					SetCloseIt(BOOL bNew)	   	{ bCloseIt = bNew; }
	BOOL					CanCloseIt() const		   	{ return bCloseIt; }

	void					SetProgressHdl(const Link& rLink)
							{ aProgressHdl = rLink; }
	void					SetCallBackHdl(const Link& rLink)
							{ aCallBackHdl = rLink; }

	void					SetUserData(void* pNew)		{ pUserData = pNew; }
	void*					GetUserData() const	   		{ return pUserData; }

	ULONG					GetTotalSize() const		{ return nTotalSize; }
	ULONG					GetBytesCopied() const		{ return nBytesCopied; }

	const INetURLObject& 	GetURL() const 				{ return aURL; }
	const String&			GetLocalFile() const		{ return aLocalFile; }
	SvLockBytes* 			GetData() const 			{ return pData; }

	BOOL 					Download(const INetURLObject& rURL, String const& rLocalFile,
									 BOOL bAsync = FALSE);
};

#endif // _GETCHOBJ_HXX
