/*************************************************************************
 *
 *  $RCSfile: UnoRuntime_Test.java,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 09:21:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.uno;

import com.sun.star.comp.connections.PipedConnection;
import complexlib.ComplexTestCase;

public final class UnoRuntime_Test extends ComplexTestCase {
    public String getTestObjectName() {
        return getClass().getName();
    }

    public String[] getTestMethodNames() {
        return new String[] { "test_CurrentContext",
                              "test_queryInterface",
                              "test_areSame",
                              "test_generateOid",
                              "test_getEnvironment",
                              "test_getBridge",
                              "test_reset" };
    }

    interface I1 {
    }

    private static Type I1_type = null;
    static {
        I1_type = new Type(I1.class);
    }

    static class Test1 {
    }

    static class Test2 implements IQueryInterface {
        class T2 implements I1 {
        }

        T2 t2 = new T2();

        public Object queryInterface(Type type) {
            Object object = type.equals(I1_type) ? t2 : null;

            return object;
        }

        public boolean isSame(Object object) {
            return object == t2;
        }

        public String getOid() {
            return null;
        }
    }

    static class Test3 implements I1 {
    }


    static class Test4 implements IQueryInterface {
        class T4 implements I1, IQueryInterface {
            public Object queryInterface(Type type) {
                return Test4.this.queryInterface(type);
            }

            public boolean isSame(Object object) {
                return UnoRuntime.areSame(Test4.this,object);
            }

            public String getOid() {
                return UnoRuntime.generateOid(Test4.this);
            }
        }

        T4 t4 = new T4();

        public Object queryInterface(Type type) {
            Object object = type.equals(I1_type) ? t4 : null;

            return object;
        }

        public boolean isSame(Object object) {
            return object == t4;
        }

        public String getOid() {
            return null;
        }
    }

    public void test_queryInterface() {
        // test if a query for an interface which is not supported gives zero
        Test1 test1 = new Test1();
        I1 i1 = (I1)UnoRuntime.queryInterface(I1.class, test1);
        assure("", i1 == null);


        // test if a query for an interface which is supported through IQueryInterface works
        Test2 test2 = new Test2();
        I1 i2 = (I1)UnoRuntime.queryInterface(I1.class, test2);
        assure("", i2 != null);

        // test if a query for an interface which is directly supported (through inheritance) works
        Test3 test3 = new Test3();
        I1 i3 = (I1)UnoRuntime.queryInterface(I1.class, test3);
        assure("", i3 != null);
    }

    public void test_areSame() {
        Test1 test1_1 = new Test1();
        Test1 test1_2 = new Test1();

        // test if two independent instances are not the same
        assure("", !UnoRuntime.areSame(test1_1, test1_2));

        // test if a delegator object is same as the delegator creator
        Test2 test2 = new Test2();
        I1 i1 = (I1)UnoRuntime.queryInterface(I1.class, test2);
        assure("", UnoRuntime.areSame(i1, test2));

        // test if delegator creator is not same with test1_1
        assure("", !UnoRuntime.areSame(test2, test1_1));
    }

    public void test_generateOid() {
        // test if UnoRuntime generates a Oid for a simple class
        Test1 test1 = new Test1();
        String oId=UnoRuntime.generateOid(test1);
//          System.err.println("#### UnoRuntime.generateOid(test1):" + oId);
        assure("", oId!=null);

        // test if UnoRuntime generates a Oid for a class
        // implementing IQueryInterface and returning null in getOid()
        Test2 test2 = new Test2();
        oId=UnoRuntime.generateOid(test2);
//          System.err.println("#### UnoRuntime.generateOid(test2):" + oId);
        assure("", oId!=null);

        // test if a delegator object has the same Oid as the delegator creator
        Test4 test4 = new Test4();
        oId=UnoRuntime.generateOid(test4);
//          System.err.println("#### UnoRuntime.generateOid(test4.i1):" + oId);
        I1 i1 = (I1)UnoRuntime.queryInterface(I1.class, test4);
        String oId2=UnoRuntime.generateOid(i1);
//          System.err.println("#### UnoRuntime.generateOid(test4.i1):" + oId2);
        assure("", oId2.equals(oId));
    }

    public void test_getEnvironment() throws java.lang.Exception {
        Object o1 = new Object();
        Object o2 = new Object();

        // get two environments with different contexts
        IEnvironment java_environment1 = UnoRuntime.getEnvironment("java", o1);
        IEnvironment java_environment2 = UnoRuntime.getEnvironment("java", o2);

        // ensure that the environments are different
        assure("", java_environment1 != java_environment2);

        // test if we get the same environment when we reget it
        assure("", UnoRuntime.areSame(java_environment1, UnoRuntime.getEnvironment("java", o1)));
        assure("", UnoRuntime.areSame(java_environment2, UnoRuntime.getEnvironment("java", o2)));

        // drop the environments and wait until they are gc
        java_environment1 = null;
        java_environment2 = null;
        System.out.println("waiting for gc to remove environments...");
        while(UnoRuntime.getEnvironmentCount() > 0) {
            System.gc();
            System.runFinalization();

            byte dummy[] = new byte[] {1, 1, 3};
        }
    }

    public void test_getBridge() throws java.lang.Exception {
        PipedConnection oneSide = new PipedConnection(new Object[0]);
        PipedConnection otherSide = new PipedConnection(new Object[]{oneSide});

        // get a bridge
        IBridge iBridge = UnoRuntime.getBridgeByName("java", null, "remote", "testname", new Object[]{"urp", oneSide, null});

        // reget the bridge, it must be the same as above
        IBridge iBridge_tmp = UnoRuntime.getBridgeByName("java", null, "remote", "testname", new Object[]{"urp", oneSide, null});
        assure("", UnoRuntime.areSame(iBridge_tmp, iBridge));

        // dispose the bridge, this removes the entry from the runtime
        iBridge.dispose();

        System.out.println("waiting for gc to remove bridges...");
        while(UnoRuntime.getBridgeCount() > 0 || UnoRuntime.getEnvironmentCount() > 0) {
            new Object();

            System.gc();
            System.runFinalization();
        }
    }

    public void test_reset() throws java.lang.Exception {
        PipedConnection oneSide = new PipedConnection(new Object[0]);
        PipedConnection otherSide = new PipedConnection(new Object[]{oneSide});

        IEnvironment java_environment = UnoRuntime.getEnvironment("java", null);

        IBridge iBridge = UnoRuntime.getBridgeByName("java", null, "remote", null, new Object[]{"urp", oneSide, null});
        iBridge.dispose();

        java_environment = null;
        iBridge = null;



        System.out.println("waiting for gc to remove objects...");
        while(UnoRuntime.getEnvironmentCount() > 0 || UnoRuntime.getBridgeCount() > 0) {
            System.gc();
            System.runFinalization();

            byte dummy[] = new byte[]{1,2,3};
        }
    }

    public void test_CurrentContext() throws java.lang.Exception
    {
        Thread_Impl t1 = new Thread_Impl();
        Thread_Impl t2 = new Thread_Impl();
        t1.start();
        t2.start();
        t1.join();
        t2.join();

        int h1 = ((Integer)t1.m_context.getValueByName( "value" )).intValue();
        int h2 = ((Integer)t2.m_context.getValueByName( "value" )).intValue();

        assure("", t1.m_context != t2.m_context);
        assure("", h1 == t1.hashCode());
        assure("", h2 == t2.hashCode());
        assure("", h1 != h2);
            // TODO  the hash codes of two different Thread objects are not
            // guaranteed to be different
    }

    private static final class CurrentContext_Impl implements XCurrentContext {
        private final Integer m_value
        = new Integer( Thread.currentThread().hashCode() );

        public Object getValueByName( String Name ) {
            if (Name.equals( "value" )) {
                return m_value;
            }
            return null;
        }
    }

    private final class Thread_Impl extends Thread {
        public XCurrentContext m_context = null;

        public void run() {
            Object o = UnoRuntime.getCurrentContext();
            assure("", o == null);

            XCurrentContext context = new CurrentContext_Impl();
            UnoRuntime.setCurrentContext( context );
            m_context = UnoRuntime.getCurrentContext();
            assure("", context == m_context);
            assure("",
                   ((Integer)m_context.getValueByName( "value" )).intValue()
                   == this.hashCode());

            UnoRuntime.setCurrentContext( null );
            o = UnoRuntime.getCurrentContext();
            assure("", o == null);
        }
    }
}
