
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.util.EditCookie;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;

public class EditAction extends NodeAction
{
    private Dialog dialog;
    
    public EditAction()
    {
    }

    public boolean enable(Node anode[])
    {
       
       return anode.length == 1 && anode[0].getCookie(EditCookie.class) != null;
    }

    public void performAction(Node anode[])
    {
             
        
        if(enable(anode))
        {
             
            final EditCookie ec = (EditCookie)anode[0].getCookie(EditCookie.class);
            final BasePanel p = ec.getEditPanel();
            DialogDescriptor exdialogdescriptor = new DialogDescriptor(p, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Customize"));
            exdialogdescriptor.setButtonListener( new ActionListener() {


                public void actionPerformed(ActionEvent actionevent)
                {
                    if(actionevent.getActionCommand().equals("OK"))
                    ec.reInit(p);
                    dialog.setVisible(false);
                    dialog.dispose();
                }

            });
          
            dialog = TopManager.getDefault().createDialog(exdialogdescriptor);
            dialog.setVisible(true);
        }
    }

    public String getName()
    {
        return NbBundle.getBundle(EditAction.class).getString("TXT_Edit");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    
}
