/*************************************************************************
 *
 *  $RCSfile: accmgr.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: cd $ $Date: 2001/08/03 18:10:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXACCMGR_HXX
#define _SFXACCMGR_HXX

#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif

#ifndef _ACCEL_HXX //autogen
#include <vcl/accel.hxx>
#endif

#include <tools/stream.hxx>

#include "cfgitem.hxx"

class SfxBindings;
class KeyEvent;

struct SfxAcceleratorConfigItem
{
	SfxAcceleratorConfigItem() : nCode( 0 ), nModifier( 0 ), nId( 0 ) {}

    sal_uInt16      nCode;
    sal_uInt16      nModifier;
    sal_uInt16      nId;
    ::rtl::OUString aCommand;
};

#include <vector>
typedef ::std::vector < SfxAcceleratorConfigItem > SfxAcceleratorItemList;


class SfxAcceleratorConfiguration;
class SfxAcceleratorManager: public SfxConfigItem
{
	Accelerator*	pAccel;
    SfxAcceleratorConfiguration*    pAccelCfg;
	USHORT			nIteratorPos;
	ResMgr* 		pResMgr;

    void            Convert();
	void			Clear();

public:
                    SfxAcceleratorManager(SfxConfigManager*);
                    SfxAcceleratorManager( const SfxAcceleratorManager& rOther, SfxConfigManager*);
                    SfxAcceleratorManager(const ResId&, SfxConfigManager*);
					~SfxAcceleratorManager();

    virtual int     Load(SotStorage&);
    virtual BOOL    Store(SotStorage&);
    virtual String  GetStreamName() const;
	virtual void    UseDefault();
    int             Load(SvStream&);
    BOOL            Store(SvStream&);

	// reading out the accelerator
    const SfxAcceleratorItemList& GetItems();
    USHORT          GetId( const KeyCode &rKeyCode ); // get SID by KeyCode
    KeyCode         GetKeyCode( USHORT nId );  // key code for a func-id

	// reconfiguring the accelerator
	void 			Reset(USHORT nCount);	// call this before reconfiguring
	void 			Reconfigure();			// call this after reconfiguring
	void 			AppendItem( USHORT nItemId, const KeyCode& rKeyCode );

    BOOL            Call( const KeyEvent&, SfxBindings& rBind, BOOL bGlobal = FALSE );
};


#endif
