:
eval 'exec perl -wS $0 ${1+"$@"}'
    if 0;
#*************************************************************************
#
#   $RCSfile: smoketest.pl,v $
#
#   $Revision: 1.8.2.8 $
#
#   last change: $Author: kz $ $Date: 2005/04/13 15:16:22 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

#
# smoketest - do the smoketest
#

use File::Path;
use File::Copy;
use Getopt::Long;

########################
#                       #
#   Globale Variablen   #
#                       #
#########################
$is_debug = 0;
$is_command_infos = 0;
$is_protocol_test = 1;
$is_remove_on_error = 0;
$is_remove_at_end = 1;
$is_oo = 0;

$gui = $ENV{GUI};
$temp_path = $ENV{TEMP};
$sversion_saved = 0;
$FileURLPrefix = "file:///";
$cygwin = "cygwin";

if (!defined($gui)) {
	print "The workstamp is missing. Please use setsolar\n";
	exit(1);
}

if (!defined($temp_path)) {
	print "Your temp value is missing. Please set your temp-variable\n";
	exit(1);
}

if ($^O =~ /$cygwin/) {
	$gui = $cygwin;
}

if ($gui eq "WNT") {
	$PathSeparator = '\\';
	$NewPathSeparator = ';';
	$dos = "$ENV{COMSPEC} -c";
	$PERL = "$dos $ENV{PERL}";
	$REMOVE_DIR = "$dos del /qsxyz";
	$REMOVE_FILE = "$dos del";
	$LIST_DIR = "$dos ls";
	$COPY_FILE = "$dos copy";
	$nul = '> NUL';
	$RESPFILE="response_fat_wnt";
	$SVERSION_INI = $ENV{USERPROFILE} . $PathSeparator . "Application Data" . $PathSeparator . "sversion.ini";
	$SOFFICEBIN = "soffice.exe";
}
elsif ($gui eq "UNX") {
	$PathSeparator = '/';
	$NewPathSeparator = ':';
	$dos = "";
	$PERL = "$ENV{PERL}";
	$REMOVE_DIR = "rm -rf";
	$REMOVE_FILE = "rm";
	$LIST_DIR = "ls";
	$COPY_FILE = "cp -f";
	$nul = '> /dev/null';
	$RESPFILE="response_fat_unx";
	$SVERSION_INI = $ENV{HOME} . $PathSeparator . ".sversionrc";
	$SOFFICEBIN = "soffice";
}
elsif ($gui eq $cygwin) {
	$PathSeparator = '/';
	$NewPathSeparator = ':';
	$dos = "";
	$PERL = "$ENV{PERL}";
	$REMOVE_DIR = "rm -rf";
	$REMOVE_FILE = "rm";
	$LIST_DIR = "ls";
	$COPY_FILE = "cp -f";
	$nul = '> /dev/null';
	$RESPFILE="response_fat_wnt";
	$SVERSION_INI = $ENV{USERPROFILE} . $PathSeparator . "Application Data" . $PathSeparator . "sversion.ini";
	$SOFFICEBIN = "soffice";
	$CygwinLineends = $/;
	$WinLineends = "\r\n";
	&SetWinLineends();
}
else {
	print_error ("not supported system\n",1);
}

if ($is_oo) {
	@install_list = (	'instsetoo'
	);
}
else {
	@install_list = (	'instset',
				'instsetoo'
	);
}

@error_messages = (	'',
			'',
			'Error during installation!',
			'Error: patching configuration failed!',
			'Error: starting office failed!',
			'Error during testing',
			'',
			'Error in setup log',
			'installationsset is not complete',
			'can not copy all basic scripts'
);

my $show_NoMessage = 0;
my $show_Message = 1;

my $error_setup = 2;
my $error_patchConfig = 3;
my $error_startOffice = 4;
my $error_testResult = 5;
my $error_deinstall = 6;
my $error_setup_log = 7;
my $error_installset = 8;
my $error_copyBasic = 9;

if ($is_oo) {
	$PRODUCT="OpenOffice.org";
}
else {
	$PRODUCT="Office";
}

$TESTSCRIPT="10erTest_auto.sxw";
$StandDir = $ENV{SOLARSRC} . $PathSeparator;
$SHIP="$ENV{SOLARROOT}$PathSeparator" . "ship" . $PathSeparator . "install$PathSeparator";
$PORDUCT = "$SHIP$ENV{INPATH}$PathSeparator$PRODUCT$PathSeparator";
$DATA="$ENV{DMAKE_WORK_DIR}$PathSeparator" . "data$PathSeparator";
$WORK_STAMP_LC=$ENV{WORK_STAMP};
$WORK_STAMP_LC =~ tr/A-Z/a-z/;

if (!IsFromShip() or $is_oo) {
	$is_protocol_test = 0;
}

if (defined($ENV{INSTALLPATH_TEST10})) {
	$installpath_without = $ENV{INSTALLPATH_TEST10};
}
else {
	$installpath_without = $temp_path . $PathSeparator . "office";
}

$installpath = $installpath_without . $PathSeparator;
$programpath = "$installpath". "program$PathSeparator";
$LOGPATH="$installpath" . "user" . $PathSeparator . "temp";
$ENV{STAR_REGISTRY}="";
$NewResponseFile = "$ENV{DMAKE_WORK_DIR}$PathSeparator$ENV{INPATH}$PathSeparator" . "misc$PathSeparator" . "response_fat.new";

if ($gui eq $cygwin) {
	$CygwinResponseFile = ConvertCygwinToWin_Shell($NewResponseFile); 
	$INSTALL="setup -r:$CygwinResponseFile";
}
else {
	$INSTALL="setup -r:$NewResponseFile";
}

#### options ####

$opt_nr = 0;
GetOptions('nr');

if ($opt_nr)  {
	$is_remove_at_end = 0; # do not remove installation
}
 
#### script id #####

( $script_name = $0 ) =~ s/^.*\b(\w+)\.pl$/$1/; 

$id_str = ' $Revision: 1.8.2.8 $ ';
$id_str =~ /Revision:\s+(\S+)\s+\$/
  ? ($script_rev = $1) : ($script_rev = "-");

print "$script_name -- version: $script_rev\n";


#### main ####

if ($gui eq $cygwin) {
	setInstallpath ("$DATA$RESPFILE", $NewResponseFile, ConvertCygwinToWin($installpath_without));
}
else {
	setInstallpath ("$DATA$RESPFILE", $NewResponseFile, $installpath_without);
}
if (!$is_debug) {
	removeOldInstallation($installpath);
	save_sversion ($SVERSION_INI);
}

if ($is_oo) {
	($INSTSETNAME, $INSTALLSET) = getInstset_oo();
}
else {
	($INSTSETNAME, $INSTALLSET) = getInstset();
}

print "Install: $INSTALLSET\n";
prepare();
doTest();

if (!$is_debug) {
	restore_sversion ($SVERSION_INI);
	if ($is_remove_at_end) {
		removeInstallation($installpath);
	}
	else {
		print_notRemoved ($installpath);
	}
}
print "smoketest successful!\n";
exit (0);

#########################
#                       #
#      Procedures       #
#                       #
#########################

sub getSubDirs {
	my ($startDir, $DirArray_ref) = @_;
	my ($dir);
	opendir(DIR,"$startDir");
	while($dir = readdir(DIR)) {
	if ($dir =~ /\.$/) {
		next;
	}
		push (@{$DirArray_ref}, "$startDir$dir");
	}
	closedir(DIR);

}

sub findSubDir {
	my ($DirArray_ref) = @_;
	my (@sortedArray, $dir, $instdir);
	@sortedArray = sort @{$DirArray_ref};
	foreach $dir (@sortedArray) {
		$instdir = "$dir$PathSeparator" . "Office$PathSeparator" . "normal$PathSeparator"; 
		if (-e $instdir) {
			return $instdir;
		} 
		$instdir = "$dir$PathSeparator" . "normal$PathSeparator"; 
		if (-e $instdir) {
			return $instdir;
		} 
	}
	return "";
}

sub prepare {
	my ($Command);
	if (!$is_debug) {
		mkpath ([$programpath], 0, 0777);
	}
	else {
		print "mkpath $programpath\n";
	}
	$Command = "$COPY_FILE \"$DATA" . "dbgsv.ini\" \"$programpath\"";
	execute_system ("$Command");
	if ($gui eq "UNX") {
		$ENV{ignore_patch_check}="t";
	}

}

sub is_Installset_ok {
	my ($installpath, $installname) = @_;
	my ($is_ok, $infile);
	$is_ok = 1;
    #$infile = $installpath . "protocol$PathSeparator";
    $infile = $INSTALLSET;
    my $prot = $PathSeparator . "protocol";
    $infile =~ s/_pre_//;
    $infile =~ s/[\/\\]normal[\/\\]//;
    $infile =~ s/$PRODUCT/$PRODUCT$prot/;
    $infile =~ s/\.(\d+)$/_$1\.html/;
    #if ($installname =~ /(?:_pre_){0,1}(.*)\.(\d+)/) {
    #	$infile .= "$1_$2.html";
    #	print "protocol: $infile\n" if $is_debug;
    #}

	open INTABLE, "<$infile" or return errorFromOpen ($infile);
        while(<INTABLE>) {
                $line = $_;
		if ( $line =~ />(error)(.*)</ ) {
			print "ERROR: $1$2\n";
			$is_ok = 0;
		}
	}
	close INTABLE;
	return $is_ok;
}

sub errorFromOpen {
	my ($file) = @_;
	print "ERROR: can't open $file\n";
	return 0;
}

sub doTest {
	my ($Command);

	# check installset (error 8)

	if (($INSTSETNAME ne "") and $is_protocol_test) {
		if (!is_Installset_ok ("$PORDUCT", $INSTSETNAME)) {
			print_error ($error_messages[$error_installset], $error_installset);
		}
	}

	# install office (error 2)

	$Command = "$INSTALLSET$INSTALL -mset:10er_test";
	execute_Command ($Command, $error_setup, $show_Message);

	if ($gui eq "UNX") {
		$Command = "chmod -R 777 \"$installpath\"*";
		execute_system ("$Command");
	}

	# check setup log file (error 7)

	$Command = "$PERL check_setup.pl \"$programpath" . "setup.log\"";
	execute_Command ($Command, $error_setup_log, $show_Message);

	# patch config (error 3)

	$Command = "$PERL config.pl \"$installpath \" \"$DATA \"";
	execute_Command ($Command, $error_patchConfig, $show_Message);

	# start office (error 9)
	$Command = "$COPY_FILE \"$DATA" . "scripts$PathSeparator" . "\"*.x* \"$installpath" . "user$PathSeparator" . "basic$PathSeparator" . "Standard$PathSeparator\" $nul";
	execute_Command ($Command, $error_copyBasic, $show_Message);

	# start office (error 4)

	print "Starte Testtool\n";

	if ((defined($ENV{OS})) && (defined($ENV{PROEXT})) && ($ENV{OS} eq "LINUX") && ($ENV{PROEXT} eq ".pro"))  {
		print "collecting statistic...\n";
		$Command = "$PERL stats.pl -p=\"$programpath" . "soffice\" -norestore -nocrashreport macro:///Standard.Global.StartTestWithDefaultOptions";
		execute_Command ($Command, $error_startOffice, $show_Message);
	}
	else {
		$Command = "\"$programpath" . "soffice\" -norestore -nocrashreport macro:///Standard.Global.StartTestWithDefaultOptions";
		execute_Command ($Command, $error_startOffice, $show_Message);
	}

	# test if smoketest is ok (error 5)

	$Command = "$PERL testlog.pl \"$LOGPATH\"";
	execute_Command ($Command, $error_testResult, $show_Message);

	# deinstall office (error 6)

	if ($is_remove_at_end) {
		print "Deinstalling Office\n";
	}
#	$Command = "$PERL deinstall.pl \"$LOGPATH\" \"$installpath\"";
#	execute_Command ($Command, $error_deinstall, $show_NoMessage);
}

sub startOfficeRemote {
	my $classpath = $ENV{CLASSPATH};
	my $Command;
	my $testdocpath = "file:///$DATA";
	my $java_files_path = $ENV{DMAKE_WORK_DIR} . "$PathSeparator$ENV{INPATH}$PathSeparator" . "class$PathSeparator";
	$classpath .= $NewPathSeparator . $java_files_path; 
	my $office_classpath = $programpath. "classes$PathSeparator";
	my @jarfiles = `$LIST_DIR -1 $office_classpath | grep .jar`;  

	# testdocpath to fileURL
	$testdocpath =~ s/\\/\//g;
	$testdocpath =~ s/\/\/\/\//\/\/\//g;

	foreach my $file (@jarfiles) {
		chomp $file;
		$classpath .= "$NewPathSeparator$programpath". "classes$PathSeparator" . $file;
	}	
	
	$Command = "java -classpath $classpath Test10 office=$programpath$SOFFICEBIN host=localhost port=8000 testsxw=$testdocpath$TESTSCRIPT try=10 timeout=1000 timestep=1000";
	system ("$Command $nul");
}

sub getInstset_oo {
	my ($INSTSET, $NEWINSTSET);
	my (@DirArray, $InstDir, $RootDir);
	print "get Instset\n" if $is_debug;
	$NEWINSTSET = "";
	if (IsFromShip()) {
#		$INSTSET="$LIST_DIR -t1 $PORDUCT | grep $ENV{WORK_STAMP}" . "__.*" . " | grep -v PASSED";
#		print "$INSTSET\n" if $is_debug;
#		$INSTSET = `$INSTSET`;
#		if ($INSTSET =~ /^(.+)\n/) {
#			$NEWINSTSET = $1;
#		}
#		$INSTSET = "$PORDUCT$NEWINSTSET$PathSeparator";
#		getSubDirs ("$INSTSET", \@DirArray);
#		$INSTSET = findSubDir (\@DirArray);
		($NEWINSTSET, $INSTSET) = getSetFromServer();
		if (($INSTSET ne "") and (-e $INSTSET)) {
			return ($NEWINSTSET, $INSTSET);
		}
	}
	else {
		$InstDir="";
		$RootDir=$ENV{DMAKE_WORK_DIR};
		$RootDir=~s/\w+$//;
		foreach $project (@install_list) {
			@DirArray=();
			if (-e "$RootDir$project$PathSeparator$ENV{INPATH}$PathSeparator") {
				$InstDir="$RootDir$project$PathSeparator$ENV{INPATH}$PathSeparator";
			}
			elsif (-e "$StandDir$project$PathSeparator$ENV{INPATH}$PathSeparator") {
				$InstDir="$StandDir$project$PathSeparator$ENV{INPATH}$PathSeparator";
			}
			if ($InstDir eq "") {
				next;
			}
			getSubDirs ("$InstDir", \@DirArray);
			$INSTSET = findSubDir (\@DirArray);
			if (($INSTSET ne "") and (-e $INSTSET)) {
				return ($NEWINSTSET, $INSTSET);
			}
		}
	}
	print_error ("no installationset found\n",2);
	return ($NEWINSTSET, $INSTSET);
}


sub getInstset {
	my ($INSTSET, $NEWINSTSET);
	my (@DirArray, $InstDir, $RootDir);
	print "get Instset\n" if $is_debug;
	$NEWINSTSET = "";
	if (IsFromShip()) {
#		$INSTSET="$LIST_DIR -t1 $PORDUCT | grep $WORK_STAMP_LC" . "_.*_01" . " | grep -v PASSED";
#		print "$INSTSET\n" if $is_debug;
#		$INSTSET = `$INSTSET`;
#		if ($INSTSET =~ /^(.+)\n/) {
#			$NEWINSTSET = $1;
#		}
#		$INSTSET = "$PORDUCT$NEWINSTSET$PathSeparator" . "normal$PathSeparator";
		($NEWINSTSET, $INSTSET) = getSetFromServer();
	}
	else {
		$InstDir="";
		$RootDir=$ENV{DMAKE_WORK_DIR}; 
		$RootDir=~s/\w+$//; 
		foreach $project (@install_list) {
			@DirArray=();
			if (-e "$RootDir$project$PathSeparator$ENV{INPATH}$PathSeparator") {
				$InstDir="$RootDir$project$PathSeparator$ENV{INPATH}$PathSeparator";
			}
			elsif (-e "$StandDir$project$PathSeparator$ENV{INPATH}$PathSeparator") {
				$InstDir="$StandDir$project$PathSeparator$ENV{INPATH}$PathSeparator";
			} 
			if ($InstDir eq "") {
				next;
			}
			getSubDirs ("$InstDir", \@DirArray);
			$INSTSET = findSubDir (\@DirArray);
			if (($INSTSET ne "") and (-e $INSTSET)) {
				return ($NEWINSTSET, $INSTSET);
			}
		}
		print_error ("no installationset found\n",2);
	}
	return ($NEWINSTSET, $INSTSET);
}

sub get_milestone {
    my ( $ws, $pf ) = @_;
	my ($milestone, $upd, $path);
	
	if ( $ws =~ /^\D+(\d+)$/) {
		$upd = $1;
	}
	
    $path = "$ENV{SOLAR_SOURCE_ROOT}$PathSeparator$ws$PathSeparator$upd" . "minor.mk";
    print "$path\n" if $is_debug;
    if ( !open(MINORMK,$path) ) {
        print "FATAL: can't open $path\n";
        return (0,0);
    }		
	
	if (!eof(MINORMK)) {
		while (<MINORMK>) {
			chomp;
			if ( /LAST_MINOR=(\w+)/ ) {
				$milestone = $1;
			}
		}
	
		close(MINORMK);
	}
	return ($milestone);
}
 
sub getSetFromServer {
    my ($DirName, $SetupFullPath);
    my $workspace = $ENV{WORK_STAMP};
    my $platform  = $ENV{INPATH};
    my $latestset;
    my $latestnumber = -1;
    if ( ! ( $workspace && $platform ) ) {
        die "Error: environment not set correctly.";
    }
    # get latest broadcastet milestone and pack number
    my $milestone = get_milestone( $workspace, $platform );
    my @sets = grep /$workspace;$platform;$milestone[-]/, `cmd_bcst -d PL2X`;
    foreach ( @sets ) {
        if ( /;($milestone[-](\d+))\s/ ) {
            if ( $2 > $latestnumber ) {
                $latestnumber = $2;
                $latestset = $1;
            }
        }
    }
    print "Latest install sets: $latestset\n" if $is_debug;
    # get supposed destination
    my $ws_lc = lc $workspace;
    @sets = grep /$ws_lc;$platform;$latestset;.*destination/, `cmd_bcst -d 9`;
    @sets = grep /[\/\\]$PRODUCT\/.*_01\./, @sets;
    if ( $#sets > 0 ) {
        warn "More than one install latest install set?";
    }
    if ( $sets[0] =~ /destination (.*$PRODUCT\/(.*\d))[\\\/]?\s?$/ ) {
        $SetupFullPath = $1 . "/normal/";
        $DirName = $2;
    }
    if ( $SetupFullPath =~ /^\/s.*\/install\// ) {
        if ( $gui eq "UNX" ) {
            $SetupFullPath = "/net/jumbo.germany" . $SetupFullPath;
        } else {
            $SetupFullPath = "\\\\jumbo" . $SetupFullPath;
        }
    }
    print "$DirName\t $SetupFullPath\n" if $is_debug;

    # compare with file system
    # at the moment just the existence is checked. For security reasons it might be
    # better to additionally check whether there are newer sets (this must not happen,
    # but who knows ...)
    if ( -d $SetupFullPath ) {
        return ($DirName, $SetupFullPath);
    } else {
        $SetupFullPath =~ s/$DirName/_pre_$DirName/;
        if ( -d $SetupFullPath ) {
            return ($DirName, $SetupFullPath);
        } else {
            die "Error: Cannot find install dir $SetupFullPath\n";
        }
    }
}

sub SetWinLineends () {
	$/ = $WinLineends;
}

sub SetCygwinLineends () {
	$/ = $CygwinLineends;
}

sub ConvertToFileURL {
	my ($filename) = @_;
	my ($FileURL);

	$FileURL = $FileURLPrefix . $filename;
	$FileURL =~ s/\\/\//g;
	$FileURL =~ s/\/\/\/\//\/\/\//; # 4 slashes to 3 slashes
	return ($FileURL);
}

sub ConvertCygwinToWin_Shell {
	my ($cygwinpath) = @_;
	my ($winpath);
	$winpath = ConvertCygwinToWin ($cygwinpath);
	$winpath =~ s/\\/\\\\/g;
	return ($winpath);
}

sub ConvertCygwinToWin {
	my ($cygwinpath) = @_;
	my ($winpath);
	SetCygwinLineends();
	$winpath=`cygpath --windows $cygwinpath`;
	chomp($winpath);
	SetWinLineends();
	return ($winpath);
}

sub save_sversion {
	my ($sversion) = @_;
	my ($sversion_bak) = $sversion . "_";
	if (-e $sversion) { 
		if (-e $sversion_bak) {
			execute_system("$REMOVE_FILE \"$sversion_bak\"");
		}
    		execute_system("$COPY_FILE \"$sversion\" \"$sversion_bak\"");
		execute_system("$REMOVE_FILE \"$sversion\"");
		$sversion_saved = 1;
	}
}

sub restore_sversion {
	my ($sversion) = @_;
	my ($sversion_bak) = $sversion . "_";
	if ($sversion_saved) {
		if (-e $sversion) {
			execute_system("$REMOVE_FILE \"$sversion\"");
		}
    		execute_system("$COPY_FILE \"$sversion_bak\" \"$sversion\"");
		execute_system("$REMOVE_FILE \"$sversion_bak\"");
		$sversion_saved = 0;
	}
}

sub removeOldInstallation  {
	my ($installpath) = @_;
	if (!$is_debug) {
		if (-e $installpath) {
			execute_system("$REMOVE_DIR \"$installpath\"");
		}
 		if (-e $installpath) {
			print_error ("can not clear old installation in $installpath\n", 3);
		}	
	}
}

sub removeInstallation  {
	my ($installpath) = @_;
	if (!$is_debug) {
		if (-e $installpath) {
			execute_system("$REMOVE_DIR \"$installpath\"");
		}
	}
}

sub setInstallpath {
	my ($infile, $outfile, $installpath) = @_;
	if (-e $outfile) {
		execute_system ("$REMOVE_FILE \"$outfile\"");
	
	}
	open OUTTABLE, ">$outfile" or die "Error: can\'t open solarfile $outfile";
	open INTABLE, "<$infile" or die "Error: can\'t open solarfile $infile";
        while(<INTABLE>) {
                $line = $_;
		if ( $line =~ /^DESTINATIONPATH=officeinstallpath/ ) {
			$line =~ s/officeinstallpath/$installpath/;
		}
		print OUTTABLE "$line";
	}
	close INTABLE;
	close OUTTABLE;
}

sub IsFromShip {
	return (((defined($ENV{UPDATER})) and ($ENV{UPDATER} eq "YES") and !defined($ENV{CWS_WORK_STAMP})) and (-d $SHIP)); 
}

sub execute_Command {
	my ($Command, $Errorcode, $showMessage) = @_;
	my ($Returncode);
	if (!$is_debug) {
		print "$Command\n" if $is_command_infos;
		$Returncode = system ("$Command");
		if ($Returncode) {
			if ($showMessage) {
				print_error ($error_messages[$Errorcode], $Errorcode);
			}
			else {
				do_exit ($Errorcode);
			}
		}
	}
	else {
		print "$Command\n";
	}
}

sub execute_system {
	my ($command) = shift;

	if ( $is_command_infos ) {
		print STDERR "TRACE_SYSTEM: $command\n";
	}
	open( COMMAND, "$command 2>&1 |");
	close(COMMAND);
}

sub print_warning
{
    my $message     = shift;

    print STDERR "$script_name: ";
    print STDERR "WARNING $message\n";
    return;
}

sub print_error
{
    my $message     = shift;
    my $error_code  = shift;

    print STDERR "$script_name: ";
    print STDERR "ERROR: $message\n";

    do_exit($error_code);
}

sub print_notRemoved {
	my ($installpath) = @_;
	print "no deinstallation from $installpath\n";
}

sub do_exit
{
    my $error_code  = shift;

    if ($sversion_saved) {
	restore_sversion ($SVERSION_INI);
    }
    if ($is_remove_on_error) {
	removeInstallation($installpath);
    }
    else {
	print_notRemoved ($installpath);
    }
    if ( $error_code ) {
	print STDERR "\nFAILURE: $script_name aborted.\n";
    }
    exit($error_code);
}
