/*------------------------------------------------------------------------

	$Workfile:   segmentc.hxx  $

	$Header: /cvs/tools/solenv/inc/segmentc.hxx,v 1.1.1.1 2000/09/20 14:43:17 hr Exp $



	Beschreibung:
	defines zur Segmentierung, Verwendung:

	SEG_EOFGLOBALS()
		vor die erste Func-Def, hinter alle globalen Variablen

	#pragma SEG_FUNCDEF(funcno)
		vor jede Funktion - dahinter eine Leerzeile!!!

	#pragma SEG_SEGCLASS(SEGMENTNAME,SEGMENTCLASSNAME)
		fuer harte Segmentierung - dahinter eine Leerzeile!!!

	ACHTUNG! wegen des MACs darf kein Leerzeichen hinter dem Segmentnamen
	auftauchen, direkt das Komma bzw. die schliessende Klammer dahinter!
	Weiterhin muss eine Leerzeile hinter der #pragma Zeile sein, auch wegen
 	des MACs ..

	#pragam SEG_EOFMODULE
		hinter die letzte Definition (also ganz zum Schluss)
		- dahinter eine Leerzeile!!!

	Segmentierung kann mit Compiler-Define NOSWSEG abgeschaltet werden und
	ist eh nur bei PRODUCT aktiv

	(c) Copyright 1989 - 1993, Star Division GmbH, Hamburg

------------------------------------------------------------------------*/

#ifndef _SEGMENTC_HXX
#define _SEGMENTC_HXX

#if defined(WNT) && defined(INTEL)
	#define NT_WIN95_INTEL
	#define SEGBASIC
#endif

#if defined(WIN) && defined(MSC)
	#define SEXPORT __export
	// Star-EXPORT, weil EXPORT gibt's oefter, z.B. in HM
	// aus historischen Gruenden fuer den Writer, das offizielle define ist
	// jetzt __EXPORT aus solar.h
#else
	#define SEXPORT
#endif

#ifdef MSC
	#pragma warning(once: 4068)
#endif

//------------------------------------------------------------------------
#if defined(NT_WIN95_INTEL)

	#if defined(TCOVER)
		// TCV-Version

		// C++Files mit TCOV-Code pro Funktion instrumentieren (tcovcl.exe)
		#include <tcov.hxx>

		#define SEG_SEGCLASS( seg, cls )
		#define SEG_EOFGLOBALS()
		#define SEG_EOFGLOBALSN(n)
		#define SEG_EOFMODULE
		#define SEG_FUNCDEF( funcid )
		#define SEG_SAMEAS( funcid )

	#elif defined(AUTOSEGS) || defined(FILESEGS)
		// SEG-Version
		//#error SEG NT/95 wird durch linken der PRODUCT mit /ORDER gemacht (OG)
		// BISLANG NOCH: EXTRA SEG BUILD

		// alle pragmas muessen vom Compiler verstanden werden
		#pragma warning(error: 4068)
		#pragma warning(error: 4612)

		// pro harter Segmentierung eine Section
		#define SEG_SEGCLASS( seg, cls ) code_seg( #seg, #cls )

		// vorsichtshalber: Antibug
		#define SEG_EOFGLOBALS() static void __SwMscAntiBug() {}
		#define SEG_EOFGLOBALSN(n) static void __SwMscAntiBug##n() {}

		// am Ende des Files: .text section
		#define SEG_EOFMODULE code_seg()

		// vor Fileanfang: .text Section
		#pragma code_seg()

		// sameas ist quasi nicht moeglich --> .text section
		// in Zukunft: SAMEAS abschaffen
		#define SEG_SAMEAS( funcid ) code_seg()

		// weiche Segmentierung: .text section
		#define SEG_FUNCDEF( funcid ) code_seg()

		// jetzt KEINE defines, sondern spaeter mit /ORDER linken
		// #include <segdefs.hxx>

	#elif defined(FUNCSEGS)
		// SIZ-Version machen

		// alle pragmas muessen vom Compiler verstanden werden
		#pragma warning(error: 4068)
		#pragma warning(error: 4612)

		// vorsichtshalber: Antibug
		#define SEG_EOFGLOBALS() static void __SwMscAntiBug() {}
		#define SEG_EOFGLOBALSN(n) static void __SwMscAntiBug##n() {}

		// vor Fileanfang: .text Section
		#pragma code_seg()

		//pro Funktion eine Section
		#define SEG_FUNCDEF( funcid ) code_seg( #funcid, "FUNCDEFS_CODE" )
		#define SEG_SAMEAS( funcid ) code_seg( #funcid, "FUNCDEFS_CODE" )

		// pro harter Segmentierung eine Section
		#define SEG_SEGCLASS( seg, cls ) code_seg( #seg, #cls )

		// am Ende des Files: .text section
		#define SEG_EOFMODULE code_seg()

	#elif defined(PRODUCT)
		// PRODUCT (FULL,DEMO,Kompakt ...) Version machen
		//

		// alle pragmas muessen vom Compiler verstanden werden
		// ausser: BASIC wg alten? ungueltigen (SEG) pragmas
		#ifndef SEGBASIC
			#pragma warning(error: 4068)
			#pragma warning(error: 4612)
		#endif

		// pro harter Segmentierung eine Section
		//#define SEG_SEGCLASS( seg, cls ) code_seg( #seg, #cls )
		// NEIN,
		// um Vergleich Product contra Seg zu ermoeglichen:
		#define SEG_SEGCLASS( seg, cls ) code_seg()

		// vorsichtshalber: Antibug
		#define SEG_EOFGLOBALS() static void __SwMscAntiBug() {}
		#define SEG_EOFGLOBALSN(n) static void __SwMscAntiBug##n() {}

		// am Ende des Files: .text section
		#define SEG_EOFMODULE code_seg()

		// vor Fileanfang: .text Section
		#pragma code_seg()

		// sameas ist quasi nicht moeglich --> .text section
		// in Zukunft: SAMEAS abschaffen
		#define SEG_SAMEAS( funcid ) code_seg()

		// weiche Segmentierung: .text section
		#define SEG_FUNCDEF( funcid ) code_seg()

		// jetzt KEINE defines, sondern spaeter mit /ORDER linken
		// #include <segdefs.hxx>

	#else
		//	Non-PRODUCT-Version machen
		#define SWG_SEGCLASS( seg, cls ) TuNix
		#define SEG_EOFGLOBALS()
		#define SEG_EOFGLOBALSN(n)
		#define SEG_EOFMODULE TuNix
		#define SEG_FUNCDEF( funcid ) TuNix
		#define SEG_SAMEAS( funcid ) TuNix
	#endif
#else
// hier kommt das bisherige Procedere: win3.1 MAC OS/2
//------------------------------------------------------------------------

#if defined( TCOVER )

	#include <tcov.hxx>
	#define SEG_SEGCLASS( seg, cls ) /* wird dann eh temporaer ersetzt */
	#define SEG_EOFGLOBALS()		 /* wird dann eh temporaer ersetzt */
	#define SEG_EOFGLOBALSN(n)		 /* wird dann eh temporaer ersetzt */
	#define SEG_EOFMODULE            /* wird dann eh temporaer ersetzt */
	#define SEG_FUNCDEF( funcid )	 /* wird dann eh temporaer ersetzt */
	#define SEG_SAMEAS( funcid )	 /* wird dann eh temporaer ersetzt */

#elif defined(FUNCSEGS) || defined(FILESEGS) || defined(AUTOSEGS) || defined(MAC)

	#if defined(MSC) &&  defined(WIN)

		#define SEG_EOFGLOBALS() static void __SwMscAntiBug() {}
		#define SEG_EOFGLOBALSN(n) static void __SwMscAntiBug##n() {}

		#if defined( FUNCSEGS )
			// SIZ-Version
			#define SEG_FUNCDEF( funcid ) code_seg( #funcid, "FUNCDEFS_CODE" )
		
			// am Fileende: <module>_text 
			#pragma SEG_EOFMODULE code_seg()

			#define SEG_SAMEAS( funcid ) code_seg( #funcid, "FUNCDEFS_CODE" )

		#elif defined( FILESEGS )
			// war mal eine Experimantalversion
			#define SEG_FUNCDEF( funcid ) code_seg( __FILE__, "FUNCDEFS_CODE" )
			#define SEG_EOFMODULE
			#define SEG_SAMEAS( funcid ) code_seg( __FILE__, "FUNCDEFS_CODE" )

		#else
			#pragma warning(error: 4068)
			#define SEG_FUNCDEF( funcid ) funcid

			#define SEG_SEGCLASS( seg, cls ) code_seg( #seg, #cls )

			#if defined(GLOBALOVERFLOW)
				#define SEG_EOFMODULE code_seg( "globaloverflow", "AUTO_CODE" )
			#elif defined(GLOBALOVERFLOW2)
				#define SEG_EOFMODULE code_seg( "globaloverflow2", "AUTO_CODE" )
			#elif defined(GLOBALOVERFLOW3)
				#define SEG_EOFMODULE code_seg( "globaloverflow3", "AUTO_CODE" )
			#else
				#define SEG_EOFMODULE code_seg( "globals", "AUTO_CODE" )
			#endif

			#define SEG_SAMEAS( funcid ) funcid

		#endif


		// 1. Segmenteinstellun: schon hier !!!!!!!!!!!!!!!
		#pragma code_seg()


	#elif defined(TCPP)
		#define SEG_SEGCLASS( seg, cls ) codeseg seg #cls
		#define SEG_EOFGLOBALS()
		#define SEG_EOFGLOBALSN(n)
		#define SEG_FUNCDEF( funcid ) funcid
		#define SEG_EOFMODULE codeseg globals "AUTO_CODE"
		#define SEG_SAMEAS( funcid ) funcid
		
		#pragma codeseg globals "AUTO_CODE"


	#elif defined(MAC)
		#define SEG_SEGCLASS( seg, cls ) segment seg
		#define SEG_EOFGLOBALS()
		#define SEG_EOFGLOBALSN(n)
		#define SEG_EOFMODULE segment globals
		#define SEG_FUNCDEF( funcid ) segment __FILE__
		#define SEG_SAMEAS( funcid ) segment __FILE__

	#else
		#define SWG_SEGCLASS( seg, cls ) TuNix
		#define SEG_EOFGLOBALS()
		#define SEG_EOFGLOBALSN(n)
		#define SEG_EOFMODULE
		#define SEG_FUNCDEF( funcid ) TuNix
		#define SEG_SAMEAS( funcid ) TuNix

	#endif

	#if defined(AUTOSEGS) || ( defined(MAC) && !defined(PPC) )
		#include <segdefs.hxx>
	#endif

#else // no segments

	#define SWG_SEGCLASS( seg, cls ) TuNix
	#define SEG_EOFGLOBALS()
	#define SEG_EOFGLOBALSN(n)
	#define SEG_EOFMODULE TuNix
	#define SEG_FUNCDEF( funcid ) TuNix
	#define SEG_SAMEAS( funcid ) TuNix

#endif

#endif // not NT_WIN_95_INTEL

#endif	// _SEGMENTC_HXX

/*------------------------------------------------------------------------
	$Log: segmentc.hxx,v $
	Revision 1.1.1.1  2000/09/20 14:43:17  hr
	initial import
	
	Revision 1.1  2000/02/11 17:33:18  hjs
	init tree
	
   
      Rev 1.10   11 Apr 1996 17:04:50   OG
   in der SIZ kein Segment "globals" mehr
   
      Rev 1.9   11 Apr 1996 16:01:04   OG
   harte Segmentierung (SEG_SEGCLASS) nicht mehr fuer ALLE Builds
   
      Rev 1.8   28 Mar 1996 17:32:18   TRI
   Base fuer OFFMGR
   
      Rev 1.7   15 Nov 1995 13:54:58   OG
   wg BASIC geaendert und wg ??
   
      Rev 1.6   13 Nov 1995 17:40:16   OG
   TCV fuer NT/95 eingebaut
   
      Rev 1.5   13 Nov 1995 13:38:02   OG
   komplett neue Anweisungen fuer NT/95 Segmentierung
   
      Rev 1.4   18 Sep 1995 10:49:28   OG
   GLOBALOVERFLOW[23] wg /PACKCODE:16Kb statt 64Kb
   
      Rev 1.2   11 Sep 1995 13:15:44   ER
   segdefs.hxx in spitzen Klammern

      Rev 1.1   26 Jun 1995 19:06:44   ER
   global overflow

      Rev 1.0   17 Aug 1994 14:39:00   NN
   Initial revision.

      Rev 1.0   02 Jun 1994 19:12:08   MI
   Initial revision.

      Rev 1.27   31 May 1994 18:32:44   ER
   mehr pm2b400

      Rev 1.26   27 May 1994 18:01:30   ER
   Erweiterung fuer pm2b400

      Rev 1.25   13 May 1994 15:48:02   MI
   Bug in SAMEAS

      Rev 1.24   11 Apr 1994 12:29:32   MI
   globals zusammengelegt

      Rev 1.23   09 Mar 1994 13:30:34   MI
   zurueckgetoucht  auf parr minuten nach alt

      Rev 1.22   09 Mar 1994 13:29:32   MI
   error bei unknown pragma und AUTOSEGS, EOFGLOB richtig

      Rev 1.21   08 Mar 1994 10:53:42   MI
   68er-MAC immer mit AUTOSEG

      Rev 1.20   05 Mar 1994 10:22:14   MI
   SEG_SAMEAS

      Rev 1.19   04 Mar 1994 08:10:34   SWG
   EOFGLOBALSN

      Rev 1.18   02 Mar 1994 20:04:22   MI
   default ohne segm. FUNCSEGS, FILESEGs etc.

      Rev 1.17   23 Feb 1994 22:23:08   ER
   SEXPORT

      Rev 1.16   22 Feb 1994 14:59:02   ER
   EXPORT --> SEXPORT

      Rev 1.15   22 Feb 1994 11:27:34   MI
   MAC immer mit Segmentierung; und TCOVER

      Rev 1.14   17 Feb 1994 01:46:30   ER
   #define SW_... wieder rein..

      Rev 1.13   16 Feb 1994 18:50:30   MI
   Segmentierung provisorisch scharf

      Rev 1.12   28 Jan 1994 16:33:36   ER
   erstmal keine Segmentierung fuer 'ne WIN-Product

      Rev 1.12   26 Jan 1994 12:54:30   MI
   neue Segmentierung

      Rev 1.11   18 Jan 1994 08:10:32   MI
   das Ding war Schrott

      Rev 1.9   15 Jan 1994 13:35:26   MI
   segdefs.hxx, SEG_FUNCDEF

      Rev 1.8   13 Jan 1994 17:02:34   MI
   MAC-Probleme mit SW_END_OF_GLOBALS

      Rev 1.7   13 Jan 1994 17:01:22   MI
   warning unknown #pragma nur einmal

      Rev 1.6   13 Jan 1994 08:14:30   MI
   wieder ein Hack...

      Rev 1.5   12 Jan 1994 17:55:56   MI
   andere Namen / scharf geschaltet

      Rev 1.4   09 Jan 1994 20:19:10   MI
   momentan nie aktiv

      Rev 1.3   14 Dec 1993 16:33:52   MI
   SwMscAntiBug wegen Segment-Compiler-Fehler

      Rev 1.2   05 Sep 1993 17:15:24   ER
   Segmentierung mit Compiler-Define NOSWSEG abschaltbar

      Rev 1.1   02 Sep 1993 14:39:58   ER
   Erklaerung zur Verwendung

      Rev 1.0   05 Aug 1993 11:08:42   ER
   Initial revision.
------------------------------------------------------------------------*/

