/*************************************************************************
#*
#*    $RCSfile: log.cxx,v $
#*
#*    class Log
#*
#*    Description       class for logging program progress, state and errors
#*						to files and/or stdout
#*
#*    Creation Date     sz  09/27/2000
#*    last change       $Author: lla $ $Date: 2003/01/28 10:13:34 $
#*    $Revision: 1.2 $
#*
#*    Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
#*
#*************************************************************************

      Source Code Control System - Header

      $Header: /cvs/tools/testshl2/source/result/log.cxx,v 1.2 2003/01/28 10:13:34 lla Exp $

      Source Code Control System - Update

*************************************************************************/

#ifndef __QADEV_REGSCAN_LOG_HXX__
#include "log.hxx"
#endif

// #include <hash_map>
// #include <list>
// #include <set>

using namespace std;

::osl::FileBase::RC Log::open( sal_Bool append ) {

	::osl::FileBase::RC ret;

	if ( ! append ) {
        ret = ::osl::File::remove( m_logurl );
	}

    if( m_logfile->open( OpenFlag_Write ) == ::osl::FileBase::E_NOENT ) {
        ret = m_logfile->open( OpenFlag_Write | OpenFlag_Create );
	}
	else  {
        ret = m_logfile->setPos( Pos_End, 0 );
	}
	return ret;
}

::osl::FileBase::RC Log::write( const sal_Char* buf, sal_Bool v ) {
	sal_uInt64 uBytes=0;
    sal_uInt32 len = 0;
    const sal_Char* ptr = buf;

    if( ptr ) {
        while( *ptr++ ) len++;
    }

	if ( v ) {
		// cout << buf << flush;
		printf("%s", buf);
	}
    return m_logfile->write( buf, len , uBytes );
}

::osl::FileBase::RC Log::write( const rtl::OString& buf, sal_Bool v  ) {
	sal_uInt64 uBytes=0;
	if ( v ) {
		// cout << buf.getStr() << flush;
		printf("%s", buf.getStr());
	}
    return m_logfile->write( buf.getStr(), buf.getLength(), uBytes );
}
/*
// LLA: due to a problem with sal/OUStingBuffer getLength() which isn't const, this
// is so not compilable.
::osl::FileBase::RC Log::write( rtl::OStringBuffer const& buf, sal_Bool v  ) {
	sal_uInt64 uBytes=0;
	if ( v ) {
		cout << buf.getStr() << flush;
	}
    return m_logfile->write( buf.getStr(), buf.getLength(), uBytes );
}
*/
::osl::FileBase::RC Log::write( const rtl::OUString& buf,
									rtl_TextEncoding tenc, sal_Bool v  ) {
	sal_uInt64 uBytes=0;
	if ( ! tenc ) {
		tenc = RTL_TEXTENCODING_ASCII_US;
	}
	rtl::OStringBuffer osbuf(
							rtl::OUStringToOString( buf, tenc ).getStr() );

	if ( v ) {
		// cout << osbuf.getStr() << flush;
		printf("%s", osbuf.getStr());		
	}
    return m_logfile->write( osbuf.getStr(), osbuf.getLength(), uBytes );
}

Log &operator <<( Log &_aLog, const sal_Char * _sValue )
{ 
	_aLog.write(_sValue); return _aLog;
}
Log &operator <<( Log &_aLog, rtl::OString const& _sValue )
{ 
	_aLog.write(_sValue); return _aLog;
}
Log &operator <<( Log &_aLog, rtl::OUString const& _sValue )
{ 
	_aLog.write(_sValue); return _aLog;
}
//! Log &operator <<( Log &_aLog, rtl::OStringBuffer const& _sValue )
//! { 
//! 	_aLog.write(_sValue); return _aLog;
//! }
