/*************************************************************************
 *
 *  $RCSfile: rmtconn.hxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: sb $ $Date: 2001/10/24 13:19:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTCONN_HXX_
#define _UCPRMT_RMTCONN_HXX_

#include <hash_map>

#ifndef _COM_SUN_STAR_CONNECTION_CONNECTIONSETUPEXCEPTION_HPP_
#include <com/sun/star/connection/ConnectionSetupException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_NOCONNECTEXCEPTION_HPP_
#include <com/sun/star/connection/NoConnectException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_ILLEGALIDENTIFIEREXCEPTION_HPP_
#include <com/sun/star/ucb/IllegalIdentifierException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandProcessor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XFILEIDENTIFIERCONVERTER_HPP_
#include <com/sun/star/ucb/XFileIdentifierConverter.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _OSL_INTERLOCK_H_
#include <osl/interlck.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include <salhelper/simplereferenceobject.hxx>
#endif

#ifndef _UCB_REGEXPMAP_HXX_
#include <regexpmap.hxx>
#endif

#if defined UCB_RAP_OFFLINE
#ifndef INCLUDED_RAPOFFLINESTORAGEERROR_HXX
#include <rapofflinestorageerror.hxx>
#endif
#endif // UCB_RAP_OFFLINE
#ifndef _UCPRMT_RMTUUID_HXX_
#include <rmtuuid.hxx>
#endif

namespace com { namespace sun { namespace star {
    namespace lang { class XMultiServiceFactory; }
    namespace ucb {
        class InteractiveAugmentedIOException;
        class XContent;
        class XContentIdentifier;
    }
} } }
namespace ucprmt {
    class Connection;
    class ContentProvider;
    namespace offline {
        class Provider;
        class Storage;
    }
}

namespace ucprmt {

//============================================================================
class ConnectionMap: public salhelper::SimpleReferenceObject
{
    friend class Connection; // to access releaseConnection()

public:
    ConnectionMap(com::sun::star::uno::Reference<
                          com::sun::star::lang::XMultiServiceFactory > const &
                      rTheFactory,
                  rtl::Reference< ContentProvider > const & rTheProvider);

    rtl::Reference< ContentProvider > getProvider() const;

    rtl::Reference< Connection >
    getConnection(rtl::OUString const & rRemoteProviderURL);

private:
    typedef std::hash_map< rtl::OUString, Connection *, rtl::OUStringHash >
        HashMap;

    com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory >
        m_xFactory;
    rtl::Reference< ContentProvider > m_xProvider;
    UUIDSupplier m_aUUIDSupplier;
    osl::Mutex m_aMutex;
    HashMap m_aProviderToConnectionMap;

    void releaseConnection(Connection * pConnection) throw ();
};

//============================================================================
class Connection: public com::sun::star::ucb::XContentProvider,
                  public com::sun::star::ucb::XContentIdentifierFactory,
                  public com::sun::star::ucb::XCommandProcessor,
                  public com::sun::star::ucb::XFileIdentifierConverter
{
public:
    Connection(com::sun::star::uno::Reference<
                       com::sun::star::lang::XMultiServiceFactory > const &
                   rTheFactory,
               rtl::Reference< ConnectionMap > const & rTheConnectionMap,
               rtl::OUString const & rTheRemoteProviderURL,
               UUIDSupplier & rUUIDSupplier);

    ~Connection() throw ();

    //========================================================================
    // com::sun::star::uno::XInterface:

    virtual com::sun::star::uno::Any SAL_CALL
    queryInterface(com::sun::star::uno::Type const & rType)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

    //========================================================================
    // com::sun::star::ucb::XContentProvider:

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
    queryContent(com::sun::star::uno::Reference<
                         com::sun::star::ucb::XContentIdentifier > const &
                     rIdentifier)
        throw (com::sun::star::ucb::IllegalIdentifierException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL
    compareContentIds(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rId1,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rId2)
        throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::ucb::XContentIdentifierFactory:

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    SAL_CALL
    createContentIdentifier(rtl::OUString const & rContentId)
        throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::ucb::XCommandProcessor:

    virtual sal_Int32 SAL_CALL createCommandIdentifier()
        throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Any SAL_CALL
    execute(com::sun::star::ucb::Command const & rCommand,
            sal_Int32,
            com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &)
        throw (com::sun::star::uno::Exception,
               com::sun::star::ucb::CommandAbortedException,
               com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL abort(sal_Int32 nCommandId)
        throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::ucb::XFileIdentifierConverter:

    virtual sal_Int32 SAL_CALL
    getFileProviderLocality(rtl::OUString const & rBaseURL)
        throw (com::sun::star::uno::RuntimeException);

    virtual rtl::OUString SAL_CALL
    getFileURLFromSystemPath(rtl::OUString const & rBaseURL,
                             rtl::OUString const & rSystemPath)
        throw (com::sun::star::uno::RuntimeException);

    virtual rtl::OUString SAL_CALL
    getSystemPathFromFileURL(rtl::OUString const & rURL)
        throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // Implementation:

    com::sun::star::uno::Reference<
        com::sun::star::lang::XMultiServiceFactory >
    getFactory() const { return m_xFactory; }

    bool addLocalURITemplate(rtl::OUString const & rTemplate, bool bOverwrite)
        throw (com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    bool removeLocalURITemplate(rtl::OUString const & rTemplate)
        throw (com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    rtl::OUString mapToLocalURI(rtl::OUString const & rRemoteURI)
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    mapToLocalIdentifier(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rRemoteIdentifier)
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    mapToLocalContent(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContent > const &
            rRemoteContent)
        throw (com::sun::star::uno::RuntimeException);

    rtl::OUString mapToRemoteURI(rtl::OUString const & rLocalURI)
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    mapToRemoteContent(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContent > const &
            rContent)
        throw (com::sun::star::uno::RuntimeException);

    bool mapsToThisConnection(rtl::OUString const & rLocalURI) const
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::ucb::InteractiveAugmentedIOException
    mapToLocalException(
        com::sun::star::ucb::InteractiveAugmentedIOException const &
            rException)
        throw (com::sun::star::uno::RuntimeException);

    inline bool isUUID(com::sun::star::uno::Sequence< sal_Int8 > const &
                           rIdentifier) const
        throw (com::sun::star::uno::RuntimeException)
    { return m_aUUID.equals(rIdentifier); }

#if defined UCB_RAP_OFFLINE
    void setOfflineMode(bool bMode) throw (offline::StorageError);
#endif // UCB_RAP_OFFLINE

    inline bool hasOfflineMode() const { return m_bOfflineMode; }

#if defined UCB_RAP_OFFLINE
    rtl::Reference< offline::Storage > getStorage()
        throw (offline::StorageError);
#endif // UCB_RAP_OFFLINE

private:
    typedef ucb::RegexpMap< bool > RegexpToBoolMap;

    class ChangeListener;

    com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory >
        m_xFactory;
    rtl::Reference< ConnectionMap > m_xConnectionMap;
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentProvider >
        m_xRemoteProvider;
    rtl::Reference< ChangeListener > m_xChangeListener;
    rtl::OUString m_aRemoteProviderURL;
    rtl::OUString m_aConnectionData;
    rtl::OUString m_aLocalURIPrefix;
    RegexpToBoolMap m_aLocalToRemoteURIs;
    RegexpToBoolMap m_aRemoteToLocalURIs;
    osl::Mutex m_aMutex;
    oslInterlockedCount m_nRefCount;
    UUID m_aUUID;
    sal_Int32 m_nLocalityFactor;
#if defined UCB_RAP_OFFLINE
    rtl::Reference< offline::Provider > m_xOfflineProvider;
    rtl::Reference< offline::Storage > m_xStorage;
#endif // UCB_RAP_OFFLINE
    bool m_bOfflineMode;

    Connection(Connection const &); // not implemented
    Connection & operator =(Connection const &); // not implemented

    com::sun::star::uno::Reference< com::sun::star::ucb::XContentProvider >
    getRemoteProvider()
        throw (com::sun::star::connection::NoConnectException,
               com::sun::star::connection::ConnectionSetupException,
               com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    void resetRemoteProvider();

    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    mapToRemoteIdentifier(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rIdentifier) const
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    normalizeLocalIdentifier(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rIdentifier) const
        throw (com::sun::star::uno::RuntimeException);

    bool isLocalIdentifier(
             com::sun::star::uno::Reference<
                     com::sun::star::ucb::XContentIdentifier > const &
                 rIdentifier) const
        throw (com::sun::star::uno::RuntimeException);

    bool isLocalContent(com::sun::star::uno::Reference<
                                com::sun::star::ucb::XContent > const &
                            rContent) const
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    getLocalContent(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rLocalIdentifier,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rRemoteIdentifier)
        throw (com::sun::star::connection::NoConnectException,
               com::sun::star::connection::ConnectionSetupException,
               com::sun::star::lang::IllegalArgumentException,
               com::sun::star::ucb::IllegalIdentifierException,
               com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    getLocalContent(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rLocalIdentifier,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContent > const &
            rRemoteContent)
        throw (com::sun::star::uno::RuntimeException);

    com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
    getRemoteContent(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rRemoteIdentifier)
        throw (com::sun::star::connection::NoConnectException,
               com::sun::star::connection::ConnectionSetupException,
               com::sun::star::lang::IllegalArgumentException,
               com::sun::star::ucb::IllegalIdentifierException,
               com::sun::star::uno::RuntimeException);

#if defined UCB_RAP_OFFLINE
    void setOfflineProvider() throw (offline::StorageError);

    void clearOfflineProvider();
#endif // UCB_RAP_OFFLINE

    friend class ConnectionMap; // to access m_nRefCount
    friend class ChangeListener; // to access resetRemoteProvider()
};

}

#endif // _UCPRMT_RMTCONN_HXX_
