/*************************************************************************
 *
 *  $RCSfile: metric.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hdu $ $Date: 2001/11/19 16:38:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_METRIC_HXX
#define _SV_METRIC_HXX

#ifndef _SV_FONT_HXX
#include <font.hxx>
#endif

// ------------------
// - ImplFontMetric -
// ------------------

class ImplFontMetric
{
	friend class FontInfo;
	friend class FontMetric;
	friend class OutputDevice;

private:
	USHORT				mnRefCount; 	// Referenz-Counter
	FontType			meType; 		// Fonttyp
	BOOL				mbDevice;		// Device-Font
	long				mnAscent;		// Ascent
	long				mnDescent;		// Descent
	long				mnLeading;		// Internal-Leading
	long				mnLineHeight;	// Ascent+Leading
	long				mnSlant;		// Slant
	USHORT				mnFirstChar;	// 1. druckbare Zeichen
	USHORT				mnLastChar; 	// Letztes druckbare Zeichen
};

// ------------
// - FontInfo -
// ------------

class FontInfo : public Font
{
	friend class OutputDevice;

protected:
	ImplFontMetric* 	mpImplMetric;	 // Implementation

public:
						FontInfo();
						FontInfo( const FontInfo& rInfo );
						~FontInfo();

	FontType			GetType() const
							{ return mpImplMetric->meType; }
	BOOL				IsDeviceFont() const
							{ return mpImplMetric->mbDevice; }

	FontInfo&			operator =( const FontInfo& rInfo );
	BOOL				operator ==( const FontInfo& rInfo ) const;
	BOOL				operator !=( const FontInfo& rInfo ) const
							{ return !(FontInfo::operator==( rInfo )); }

#ifdef SMART_UNO_GENERATION
	void				getFont_( Font& rFont ) const	{ rFont = *this; }
	void				setFont_( const Font& rFont )	{ *((Font*)this) = rFont; }

	FontType			getType() const 			{ return GetType(); }
	void				setType( FontType e )		{ mpImplMetric->meType = e;}

	BOOL				getDeviceFont() const			{ return IsDeviceFont(); }
	void				setDeviceFont( BOOL b ) 		{ mpImplMetric->mbDevice = b; }
#endif
};

// --------------
// - FontMetric -
// --------------

class FontMetric : public FontInfo
{
public:
						FontMetric() {}
						FontMetric( const FontMetric& rMetric ) :
							FontInfo( rMetric ) {}
						~FontMetric() {}

	long				GetAscent() const
							{ return mpImplMetric->mnAscent; }
	long				GetDescent() const
							{ return mpImplMetric->mnDescent; }
	long				GetLeading() const
							{ return mpImplMetric->mnLeading; }
	long				GetLineHeight() const
							{ return mpImplMetric->mnLineHeight; }
	long				GetSlant() const
							{ return mpImplMetric->mnSlant; }

	BOOL				ExistChar( USHORT c ) const;

	FontMetric& 		operator =( const FontMetric& rMetric );
	BOOL				operator ==( const FontMetric& rMetric ) const
							{ return FontInfo::operator ==( rMetric ); }
	BOOL				operator !=( const FontMetric& rMetric ) const
							{ return FontInfo::operator !=( rMetric ); }

#ifdef SMART_UNO_GENERATION
	void				getFontInfo_( FontInfo& rFontInfo ) const	{ rFontInfo = *this; }
	void				setFontInfo_( const FontInfo& rInfo ) { *((FontInfo*)this)=rInfo; }
	long				getAscent() const				{ return GetAscent(); }
	void				setAscent( long n ) 			{ mpImplMetric->mnAscent = n; }
	long				getDescent() const				{ return GetDescent(); }
	void				setDescent( long n )			{ mpImplMetric->mnDescent = n; }
	long				getLeading() const				{ return GetLeading(); }
	void				setLeading( long n )			{ mpImplMetric->mnLeading = n; }
	long				getSlant() const				{ return GetSlant(); }
	void				setSlant( long n )				{ mpImplMetric->mnSlant = n; }
	USHORT				getFirstChar() const			{ return mpImplMetric->mnFirstChar; }
	void				setFirstChar( USHORT n )		{ mpImplMetric->mnFirstChar = n; }
	USHORT				getLastChar() const 			{ return mpImplMetric->mnLastChar; }
	void				setLastChar( USHORT n ) 		{ mpImplMetric->mnLastChar = n; }
#endif
};

inline FontMetric& FontMetric::operator =( const FontMetric& rMetric )
{
	FontInfo::operator = ( rMetric );
	return *this;
}

inline BOOL FontMetric::ExistChar( USHORT c ) const
{
	if ( (mpImplMetric->mnFirstChar <= c) && (c <= mpImplMetric->mnLastChar) )
		return TRUE;
	else
		return FALSE;
}

// ---------------
// - FontCharMap -
// ---------------

typedef sal_uInt32 sal_UCS4;

class FontCharMap
{
private:
    const sal_UCS4*     mpRangeCodes;      // pairs of StartCode/(EndCode+1)
    ULONG               mnRangeCount;
    ULONG               mnCharCount;

#if _SOLAR__PRIVATE
friend class OutputDevice;
    int                 ImplFindRange( sal_UCS4 ) const;
    void                ImplSetRanges( ULONG nPairs, const sal_UCS4* pCodes );
    void                ImplSetDefaultRanges();
#endif // _SOLAR__PRIVATE

public:
                        FontCharMap();
                        ~FontCharMap();

    BOOL                IsDefaultMap() const;
    BOOL                HasChar( sal_UCS4 ) const;
    ULONG               GetCharCount() const { return mnCharCount; }

    sal_UCS4            GetFirstChar() const;
    sal_UCS4            GetLastChar() const;

    sal_UCS4            GetNextChar( sal_UCS4 ) const;
    sal_UCS4            GetPrevChar( sal_UCS4 ) const;

    ULONG               GetRangeCount() const { return mnRangeCount; }
    void                GetRange( ULONG i, sal_UCS4& rFirst, sal_UCS4& rLast ) const;

    FontCharMap&        operator=( const FontCharMap& );

private:
    // copy constructor is not allowed and not implemented
                        FontCharMap( const FontCharMap& );
};

// ----------------
// - TextRectInfo -
// ----------------

class TextRectInfo
{
	friend class OutputDevice;

private:
	long			mnMaxWidth;
	USHORT			mnLineCount;
	BOOL			mbEllipsis;

public:
					TextRectInfo();

	USHORT			GetLineCount() const { return mnLineCount; }
	long			GetMaxLineWidth() const { return mnMaxWidth; }
	BOOL			IsEllipses() const { return mbEllipsis; }

	BOOL			operator ==( const TextRectInfo& rInfo ) const
						{ return ((mnMaxWidth	== rInfo.mnMaxWidth)	&&
								  (mnLineCount	== rInfo.mnLineCount)	&&
								  (mbEllipsis	== rInfo.mbEllipsis)); }
	BOOL			operator !=( const TextRectInfo& rInfo ) const
						{ return !(TextRectInfo::operator==( rInfo )); }

#ifdef SMART_UNO_GENERATION
	long			getMaxWidth() const 		{ return mnMaxWidth; }
	void			setMaxWidth( long n )		{ mnMaxWidth = n; }
	USHORT			getLineCount() const		{ return mnLineCount; }
	void			setLineCount( USHORT n )	{ mnLineCount = n; }
	BOOL			getEllipsis() const 		{ return mbEllipsis; }
	void			setEllipsis( BOOL b )		{ mbEllipsis = b; }
#endif
};

inline TextRectInfo::TextRectInfo()
{
	mnMaxWidth		= 0;
	mnLineCount 	= 0;
	mbEllipsis		= FALSE;
}

#endif // _SV_METRIC_HXX
