/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import java.nio.ByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class Message_1_1
extends MessageBase {
    static final int UPPER_THREE_BYTES_OF_INT_MASK = 255;
    private static ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.protocol");
    int magic = 0;
    GIOPVersion GIOP_version = null;
    byte flags = 0;
    byte message_type = 0;
    int message_size = 0;

    Message_1_1() {
    }

    Message_1_1(int n, GIOPVersion gIOPVersion, byte by, byte by2, int n2) {
        this.magic = n;
        this.GIOP_version = gIOPVersion;
        this.flags = by;
        this.message_type = by2;
        this.message_size = n2;
    }

    public GIOPVersion getGIOPVersion() {
        return this.GIOP_version;
    }

    public int getType() {
        return this.message_type;
    }

    public int getSize() {
        return this.message_size;
    }

    public boolean isLittleEndian() {
        return (this.flags & 1) == 1;
    }

    public boolean moreFragmentsToFollow() {
        return (this.flags & 2) == 2;
    }

    public void setThreadPoolToUse(int n) {
        int n2 = n << 2;
        n2 &= 0xFF;
        this.flags = (byte)(n2 |= this.flags);
    }

    public void setSize(ByteBuffer byteBuffer, int n) {
        this.message_size = n;
        int n2 = n - 12;
        if (!this.isLittleEndian()) {
            byteBuffer.put(8, (byte)(n2 >>> 24 & 0xFF));
            byteBuffer.put(9, (byte)(n2 >>> 16 & 0xFF));
            byteBuffer.put(10, (byte)(n2 >>> 8 & 0xFF));
            byteBuffer.put(11, (byte)(n2 >>> 0 & 0xFF));
        } else {
            byteBuffer.put(8, (byte)(n2 >>> 0 & 0xFF));
            byteBuffer.put(9, (byte)(n2 >>> 8 & 0xFF));
            byteBuffer.put(10, (byte)(n2 >>> 16 & 0xFF));
            byteBuffer.put(11, (byte)(n2 >>> 24 & 0xFF));
        }
    }

    public FragmentMessage createFragmentMessage() {
        switch (this.message_type) {
            case 2: 
            case 5: 
            case 6: {
                throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
            }
            case 3: 
            case 4: {
                if (!this.GIOP_version.equals(GIOPVersion.V1_1)) break;
                throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (this.GIOP_version.equals(GIOPVersion.V1_1)) {
            return new FragmentMessage_1_1(this);
        }
        if (this.GIOP_version.equals(GIOPVersion.V1_2)) {
            return new FragmentMessage_1_2(this);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public void read(InputStream inputStream) {
    }

    public void write(OutputStream outputStream) {
        outputStream.write_long(this.magic);
        Message_1_1.nullCheck(this.GIOP_version);
        this.GIOP_version.write(outputStream);
        outputStream.write_octet(this.flags);
        outputStream.write_octet(this.message_type);
        outputStream.write_ulong(this.message_size);
    }
}

