/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.client;

import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.dispatch.DispatchContext;
import com.sun.xml.internal.ws.client.dispatch.impl.encoding.DispatchSerializer;
import com.sun.xml.internal.ws.encoding.internal.InternalEncoder;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.simpletype.EncoderUtils;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.SOAPDecoder;
import com.sun.xml.internal.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.internal.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPConnectionUtil;
import com.sun.xml.internal.ws.util.xml.StAXSource;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.WebServiceException;

public class SOAPXMLDecoder
extends SOAPDecoder {
    protected DispatchSerializer getSerializerInstance() {
        return DispatchSerializer.SOAP_1_0;
    }

    public SOAPMessage toSOAPMessage(MessageInfo messageInfo) {
        WSConnection wSConnection = messageInfo.getConnection();
        return SOAPConnectionUtil.getSOAPMessage(wSConnection, messageInfo, this.getBindingId());
    }

    protected void decodeEnvelope(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, boolean bl, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (this.isDispatch(messageInfo)) {
            this.dispatchUtil.collectPrefixes(xMLStreamReader);
        }
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        if (this.skipHeader(messageInfo)) {
            this.skipHeader(xMLStreamReader, messageInfo);
        } else {
            this.decodeHeader(xMLStreamReader, messageInfo, internalMessage);
        }
        if (bl) {
            this.skipBody(xMLStreamReader);
        } else {
            this.decodeBody(xMLStreamReader, internalMessage, messageInfo);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 8);
    }

    private static String convertNull(String string) {
        return string != null ? string : "";
    }

    protected void decodeBody(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
        if (dispatchContext != null) {
            XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
            XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getBodyTag());
            int n = XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            if (n != 2) {
                BodyBlock bodyBlock;
                QName qName = xMLStreamReader.getName();
                if (qName.equals(this.getFaultTag())) {
                    SOAPFaultInfo sOAPFaultInfo = this.decodeFault(xMLStreamReader, internalMessage, messageInfo);
                    bodyBlock = new BodyBlock(sOAPFaultInfo);
                } else {
                    JAXBContext jAXBContext = this.getJAXBContext(messageInfo);
                    if (jAXBContext == null) {
                        bodyBlock = new BodyBlock(this.getSerializerInstance().deserializeSource(xMLStreamReader, this.dispatchUtil));
                    } else {
                        JAXBBeanInfo jAXBBeanInfo = null;
                        Unmarshaller unmarshaller = (Unmarshaller)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.unmarshaller");
                        jAXBBeanInfo = unmarshaller != null ? JAXBBeanInfo.fromStAX(xMLStreamReader, jAXBContext, unmarshaller) : JAXBBeanInfo.fromStAX(xMLStreamReader, jAXBContext);
                        bodyBlock = new BodyBlock(jAXBBeanInfo);
                    }
                }
                internalMessage.setBody(bodyBlock);
            }
            XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
            XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getBodyTag());
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        } else {
            super.decodeBody(xMLStreamReader, internalMessage, messageInfo);
        }
    }

    public void toMessageInfo(InternalMessage internalMessage, MessageInfo messageInfo) {
        RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (runtimeContext != null) {
            SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            InternalEncoder internalEncoder = sOAPEPTFactory.getInternalEncoder();
            internalEncoder.toMessageInfo(internalMessage, messageInfo);
        } else if (internalMessage != null && internalMessage.getBody() != null) {
            if (internalMessage.getBody().getValue() instanceof SOAPFaultInfo) {
                messageInfo.setResponseType(1);
                messageInfo.setResponse(internalMessage.getBody().getValue());
            } else if (internalMessage.getBody().getValue() instanceof Exception) {
                messageInfo.setResponseType(2);
                messageInfo.setResponse(internalMessage.getBody().getValue());
            } else {
                messageInfo.setResponseType(0);
                this.setAttachments(internalMessage, messageInfo);
                if (internalMessage.getBody().getValue() instanceof JAXBBeanInfo) {
                    messageInfo.setResponse(((JAXBBeanInfo)internalMessage.getBody().getValue()).getBean());
                } else {
                    messageInfo.setResponse(internalMessage.getBody().getValue());
                }
            }
        } else {
            messageInfo.setResponseType(0);
        }
    }

    private void setAttachments(InternalMessage internalMessage, MessageInfo messageInfo) {
    }

    protected void decodeEnvelope(XMLStreamReader xMLStreamReader, MessageInfo messageInfo) {
        InternalMessage internalMessage = this.decodeInternalMessage(xMLStreamReader, messageInfo);
        this.toMessageInfo(internalMessage, messageInfo);
    }

    protected InternalMessage decodeInternalMessage(XMLStreamReader xMLStreamReader, MessageInfo messageInfo) {
        InternalMessage internalMessage = new InternalMessage();
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        this.decodeHeader(xMLStreamReader, messageInfo, internalMessage);
        this.decodeBody(xMLStreamReader, internalMessage, messageInfo);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 8);
        return internalMessage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalMessage toInternalMessage(SOAPMessage sOAPMessage, MessageInfo messageInfo) {
        InternalMessage internalMessage;
        block6: {
            XMLStreamReader xMLStreamReader = null;
            try {
                InternalMessage internalMessage2 = new InternalMessage();
                this.processAttachments(messageInfo, internalMessage2, sOAPMessage);
                Source source = sOAPMessage.getSOAPPart().getContent();
                xMLStreamReader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(sOAPMessage));
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                this.decodeEnvelope(xMLStreamReader, internalMessage2, false, messageInfo);
                internalMessage = internalMessage2;
                if (xMLStreamReader == null) break block6;
            }
            catch (DeserializationException deserializationException) {
                try {
                    throw new WebServiceException(deserializationException.getCause());
                    catch (Exception exception) {
                        throw new WebServiceException(exception);
                    }
                }
                catch (Throwable throwable) {
                    if (xMLStreamReader != null) {
                        XMLStreamReaderUtil.close(xMLStreamReader);
                    }
                    throw throwable;
                }
            }
            XMLStreamReaderUtil.close(xMLStreamReader);
        }
        return internalMessage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalMessage toInternalMessage(SOAPMessage sOAPMessage, InternalMessage internalMessage, MessageInfo messageInfo) {
        XMLStreamReader xMLStreamReader = null;
        try {
            this.processAttachments(messageInfo, internalMessage, sOAPMessage);
            Source source = sOAPMessage.getSOAPPart().getContent();
            xMLStreamReader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(sOAPMessage));
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            this.decodeEnvelope(xMLStreamReader, internalMessage, !this.isDispatch(messageInfo), messageInfo);
            if (!this.isDispatch(messageInfo)) {
                this.convertBodyBlock(internalMessage, messageInfo);
            }
            if (xMLStreamReader == null) return internalMessage;
        }
        catch (DeserializationException deserializationException) {
            try {
                throw new WebServiceException(deserializationException.getCause());
                catch (Exception exception) {
                    throw new WebServiceException(exception);
                }
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                XMLStreamReaderUtil.close(xMLStreamReader);
                throw throwable;
            }
        }
        XMLStreamReaderUtil.close(xMLStreamReader);
        return internalMessage;
    }

    public String getSOAPBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected SOAPFaultInfo decodeFault(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        Object object;
        Object object2;
        String string;
        String string2;
        QName qName;
        block15: {
            Method method;
            RuntimeContext runtimeContext;
            block13: {
                block14: {
                    runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
                    XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
                    XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT);
                    method = messageInfo.getMethod();
                    XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                    XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
                    XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT_CODE);
                    XMLStreamReaderUtil.nextContent(xMLStreamReader);
                    String string3 = xMLStreamReader.getText();
                    String string4 = "";
                    string3 = EncoderUtils.collapseWhitespace(string3);
                    String string5 = XmlUtil.getPrefix(string3);
                    if (string5 != null && (string4 = xMLStreamReader.getNamespaceURI(string5)) == null) {
                        throw new DeserializationException("xsd.unknownPrefix", string5);
                    }
                    String string6 = XmlUtil.getLocalPart(string3);
                    qName = new QName(string4, string6);
                    XMLStreamReaderUtil.next(xMLStreamReader);
                    XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
                    XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT_CODE);
                    XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                    XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
                    XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT_STRING);
                    XMLStreamReaderUtil.nextContent(xMLStreamReader);
                    string2 = "";
                    if (xMLStreamReader.getEventType() == 4) {
                        do {
                            string2 = string2 + xMLStreamReader.getText();
                            XMLStreamReaderUtil.next(xMLStreamReader);
                        } while (xMLStreamReader.getEventType() == 4);
                    }
                    XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
                    XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT_STRING);
                    string = null;
                    object2 = null;
                    if (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 1) break block13;
                    object = xMLStreamReader.getName();
                    if (((QName)object).equals(SOAPConstants.QNAME_SOAP_FAULT_ACTOR)) {
                        XMLStreamReaderUtil.nextContent(xMLStreamReader);
                        if (xMLStreamReader.getEventType() == 4) {
                            string = xMLStreamReader.getText();
                            XMLStreamReaderUtil.next(xMLStreamReader);
                        }
                        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
                        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT_ACTOR);
                        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                        object = xMLStreamReader.getName();
                    }
                    if (!((QName)object).equals(SOAPConstants.QNAME_SOAP_FAULT_DETAIL)) break block14;
                    if (XMLStreamReaderUtil.nextContent(xMLStreamReader) == 1) {
                        if (messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context") == null) {
                            object2 = this.readFaultDetail(xMLStreamReader, messageInfo);
                        } else {
                            XMLStreamReaderUtil.skipElement(xMLStreamReader);
                            XMLStreamReaderUtil.next(xMLStreamReader);
                        }
                    }
                    XMLStreamReaderUtil.nextContent(xMLStreamReader);
                    break block15;
                }
                if (internalMessage.getHeaders() == null) break block15;
                boolean bl = false;
                for (HeaderBlock headerBlock : internalMessage.getHeaders()) {
                    if (!runtimeContext.getModel().isKnownFault(headerBlock.getName(), method)) continue;
                    bl = true;
                    object2 = headerBlock.getValue();
                }
                if (!bl) {
                    object2 = null;
                }
                XMLStreamReaderUtil.next(xMLStreamReader);
                break block15;
            }
            if (internalMessage.getHeaders() != null) {
                for (HeaderBlock headerBlock : internalMessage.getHeaders()) {
                    if (!runtimeContext.getModel().isKnownFault(headerBlock.getName(), method)) continue;
                    object2 = headerBlock.getValue();
                }
            }
        }
        object = new SOAPFaultInfo(string2, qName, string, object2, this.getBindingId());
        if (xMLStreamReader.getEventType() == 4 && xMLStreamReader.isWhiteSpace()) {
            XMLStreamReaderUtil.nextContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, SOAPConstants.QNAME_SOAP_FAULT);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        return object;
    }

    protected final Object readFaultDetail(XMLStreamReader xMLStreamReader, MessageInfo messageInfo) {
        Object object;
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (runtimeContext == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            return null;
        }
        QName qName = xMLStreamReader.getName();
        if (runtimeContext.getModel().isKnownFault(qName, messageInfo.getMethod()) && (object = runtimeContext.getDecoderInfo(qName)) != null && object instanceof JAXBBridgeInfo) {
            JAXBBridgeInfo jAXBBridgeInfo = (JAXBBridgeInfo)object;
            jAXBBridgeInfo.deserialize(xMLStreamReader, runtimeContext.getBridgeContext());
            int n = xMLStreamReader.getEventType();
            if (n != 1 && n != 2) {
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            }
            while (xMLStreamReader.getEventType() == 1) {
                XMLStreamReaderUtil.skipElement(xMLStreamReader);
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            }
            XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
            XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getFaultDetailTag());
            return jAXBBridgeInfo;
        }
        return this.decodeFaultDetail(xMLStreamReader);
    }

    protected Detail decodeFaultDetail(XMLStreamReader xMLStreamReader) {
        try {
            Transformer transformer = XmlUtil.newTransformer();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            Detail detail = sOAPMessage.getSOAPBody().addFault().addDetail();
            do {
                transformer.transform(new StAXSource(xMLStreamReader, true), new DOMResult(detail));
            } while (XMLStreamReaderUtil.nextContent(xMLStreamReader) == 1);
            return detail;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException("sender.response.cannotDecodeFaultDetail", sOAPException);
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException("sender.response.cannotDecodeFaultDetail", transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new WebServiceException("sender.response.cannotDecodeFaultDetail", transformerFactoryConfigurationError);
        }
    }

    protected JAXBContext getJAXBContext(MessageInfo messageInfo) {
        JAXBContext jAXBContext = null;
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        if (requestContext != null) {
            jAXBContext = (JAXBContext)requestContext.copy().get("com.sun.xml.internal.ws.jaxbcontext");
        }
        return jAXBContext;
    }

    protected String getBindingId(MessageInfo messageInfo) {
        String string;
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request");
        if (requestContext != null && (string = (String)requestContext.get("com.sun.xml.internal.ws.binding")) != null) {
            return string;
        }
        return this.getBindingId();
    }

    public String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    protected QName getSenderFaultCode() {
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    protected QName getReceiverFaultCode() {
        return SOAPConstants.FAULT_CODE_CLIENT;
    }

    protected QName getVersionMismatchFaultCode() {
        return SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
    }
}

