/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    private Line2D line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (n2 > 0) {
            Number number3 = xYDataset.getXValue(n, n2 - 1);
            Number number4 = xYDataset.getYValue(n, n2 - 1);
            if (number4 != null) {
                double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
                double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
                if (d4 == d2) {
                    this.line.setLine(d3, d4, d, d2);
                    graphics2D.draw(this.line);
                } else {
                    this.line.setLine(d3, d4, d, d4);
                    graphics2D.draw(this.line);
                    this.line.setLine(d, d4, d, d2);
                    graphics2D.draw(this.line);
                }
            }
        }
        if (valueAxis.isCrosshairLockedOnData()) {
            if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (valueAxis2.isCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
    }
}

