/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudgrwal.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:11:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#include "pairs.hxx"

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "schview.hxx"

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif


#include <svx/svxids.hrc>

#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "attrib.hrc"
#include "attrib.hxx"
#include "undgrwal.hxx"
#include "fudgrwal.hxx"
#include "chmod3d.hxx"

TYPEINIT1(SchFuDiagramWall, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuDiagramWall::SchFuDiagramWall(SchViewShell* pViewSh, SchWindow* pWin,
								   SchView* pView, ChartModel* pDoc,
								   SfxRequest& rReq,
								   Point &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	aMDPos       = rMDPos;
	const SfxItemSet* pArgs = rReq.GetArgs();

	if (!pArgs)
	{
//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SchAttribTabDlg* pDlg =	new SchAttribTabDlg(&pViewSh->GetViewFrame()->GetWindow(),
//                   								    ATTR_DIAGRAM_WALL, &pDoc->GetDiagramWallAttr(),
//								                    pDoc->GetObjectShell(), pDoc, 0, pDoc->ChartStyle());
		SfxItemSet aChartAreaItems(pDoc->GetPool(),nAreaAndChartWhichPairs);

		aChartAreaItems.Put(pDoc->GetDiagramWallAttr());

/*		long nShapeType=pDoc->GetChartShapeType();
		if(nShapeType!=CHART_SHAPE3D_ANY)
			aChartAreaItems.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nShapeType));
*/
		SchAttribTabDlg* pDlg =	new SchAttribTabDlg(NULL,
			ATTR_DIAGRAM_WALL,&aChartAreaItems,
			pDoc->GetObjectShell(), pDoc, 0, pDoc->ChartStyle());

		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*pDlg->GetOutputItemSet());
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	SfxItemSet aOldAttr ( pDoc->GetDiagramWallAttr());

	pDoc->ChangeDiagramWallAttr(*pArgs, NULL);

	//Style-items filtern, damit die Scene nicht die Wand(farb)attr erhaelt
/*	SfxItemSet aChartSet(pDoc->GetPool(),SCHATTR_STYLE_SHAPE,SCHATTR_STYLE_SHAPE,0);
	aChartSet.Put(*pArgs);

	pDoc->PutAttr(aChartSet);
	*/
	if(pDoc->IsAttrChangeNeedsBuildChart(*pArgs))
		pDoc->BuildChart(FALSE);

	SchUndoDiagramWall* pUndo =	new SchUndoDiagramWall(*pDoc, aOldAttr, *pArgs);
	pUndo->SetComment(String(SchResId(STR_UNDO_DIAGRAM_WALL)));
	pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramWall::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramWall::Deactivate()
{
}



