/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undmovsize.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 15:01:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_UNDMOVSIZE_HXX
#define _SCH_UNDMOVSIZE_HXX

#include "schundo.hxx"

class SfxItemSet;
/*************************************************************************
|*
|* Undo for Move or Size
|*
\************************************************************************/

class SchUndoMoveOrResize : public SchUndoAction
{
public:
	TYPEINFO();

	SchUndoMoveOrResize(ChartModel& rChDoc, UINT16 nObjId
		, const Rectangle& rOldRect, const Rectangle& rNewRect );

	SchUndoMoveOrResize(ChartModel& rChDoc, UINT16 nObjId
		, const Rectangle& rOldRect, const Rectangle& rNewRect
		, const ::basegfx::B3DHomMatrix& rOldMatrix, const ::basegfx::B3DHomMatrix& rNewMatrix );

	virtual ~SchUndoMoveOrResize(){}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;

	void SetCommentTemplate(USHORT nResId);

	static void GetGeoAttribFromItemSet(const SfxItemSet& rAttr
		, Rectangle& rPosAndSize, Rectangle& rRotation );

private:
	void DoIt(const Rectangle& rRect, const ::basegfx::B3DHomMatrix& rOldMatrix);

	void MoveSdrObject(const Point& rNewPos);
	void ModifyDiagram(const Rectangle& rRect, const ::basegfx::B3DHomMatrix& rOldMatrix);
	SdrObject* GetObject(UINT16 nObjId);

private:
	UINT16 m_nObjId;
	Rectangle m_aOldRect;
	Rectangle m_aNewRect;
	::basegfx::B3DHomMatrix m_aOldSceneMatrix;
	::basegfx::B3DHomMatrix m_aNewSceneMatrix;
};

#endif

