/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: struold.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 01:04:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_tools.hxx"

// =======================================================================

xub_StrLen svwstrlen( const sal_Unicode* pCharStr )
{
	const sal_Unicode* pTempStr = pCharStr;
	while ( *pTempStr )
		pTempStr++;
	return (xub_StrLen)(pTempStr - pCharStr);
}

// -----------------------------------------------------------------------

sal_Unicode* svwmemset( sal_Unicode* pCharStr, sal_Unicode c, xub_StrLen n )
{
	sal_Unicode* pTempStr = pCharStr;
	while ( n-- )
		*(pTempStr++) = c;
	return pCharStr;
}

// -----------------------------------------------------------------------

int svwstrcmp( const sal_Unicode* pStr1, const sal_Unicode* pStr2 )
{
	int nRet;
	while ( ((nRet = ((int)*pStr1)-((int)*pStr2)) == 0) &&
			*pStr2 )
	{
		pStr1++;
		pStr2++;
	}

	return nRet;
}

// -----------------------------------------------------------------------

int svwstrncmp( const sal_Unicode* pStr1, const sal_Unicode* pStr2,
				xub_StrLen nCount )
{
	int nRet = 0;
	while ( nCount &&
			((nRet = ((int)*pStr1)-((int)*pStr2)) == 0) &&
			*pStr2 )
	{
		pStr1++;
		pStr2++;
		nCount--;
	}

	return nRet;
}

// -----------------------------------------------------------------------

sal_Unicode* svwstrncpy( sal_Unicode* pStr1, const sal_Unicode* pStr2,
						 xub_StrLen nMaxLen )
{
	sal_Unicode*	pDest = pStr1;
	xub_StrLen		i;
	// Kopieren bis *scr = 0
	for ( i=0 ; i < nMaxLen && *pStr2 ; i++ )
		*(pDest++) = *(pStr2++);
	// Evt. mit Nullen abschliesen
	if ( i < nMaxLen )
		*(pDest++) = 0;
	return pStr1;
}

// =======================================================================

#ifdef SAL_UNICODE_NOTEQUAL_WCHAR_T

xub_StrLen ImplStringLen( const wchar_t* pStr )
{
	const wchar_t* pTempStr = pStr;
	while( *pTempStr )
		pTempStr++;
	return (xub_StrLen)(pTempStr-pStr);
}

// -----------------------------------------------------------------------

UniString::UniString( const wchar_t* pWCharStr )
: mpData(NULL)
{
	DBG_CTOR( UniString, DbgCheckUniString );

	// Stringlaenge ermitteln
	xub_StrLen nLen;
	if ( !pWCharStr )
		nLen = 0;
	else
		nLen = ImplStringLen( pWCharStr );

	// Ist es kein leerer String
	if ( nLen )
	{
		if ( nLen > STRING_MAXLEN )
			nLen = STRING_MAXLEN;

		// Verwaltungsdaten anlegen und String kopieren
		mpData = ImplAllocData( nLen );
		for ( xub_StrLen i = 0; i < nLen; i++ )
			mpData->maStr[i] = pWCharStr[i];
	}
	else
	{
		STRING_NEW((STRING_TYPE **)&mpData);
	}
}

// -----------------------------------------------------------------------

UniString::UniString( const wchar_t* pWCharStr, xub_StrLen nLen )
	: mpData(NULL)
{
	DBG_CTOR( UniString, DbgCheckUniString );

	if ( !pWCharStr )
	{
		STRING_NEW((STRING_TYPE **)&mpData);
 
		return;
	}

	if ( nLen == STRING_LEN )
		nLen = ImplStringLen( pWCharStr );

#ifdef DBG_UTIL
	if ( DbgIsAssert() )
	{
		for ( xub_StrLen i = 0; i < nLen; i++ )
		{
			if ( !pWCharStr[i] )
			{
				DBG_ERROR( "String::String() : nLen is wrong" );
			}
		}
	}
#endif

	// Ist es kein leerer String
	if ( nLen )
	{
		if ( nLen > STRING_MAXLEN )
			nLen = STRING_MAXLEN;

		// Verwaltungsdaten anlegen und String kopieren
		mpData = ImplAllocData( nLen );
		for ( xub_StrLen i = 0; i < nLen; i++ )
			mpData->maStr[i] = pWCharStr[i];
	}
	else
	{
		STRING_NEW((STRING_TYPE **)&mpData);
	}
}
#endif

// =======================================================================

BOOL UniString::IsPrintable() const
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );

	// Den gesammten String nach Printable-Zeichen absuchen
	const sal_Unicode* pStr = mpData->maStr;
	while ( *pStr )
	{
		// Wenn ein Zeichen im String nicht Printable ist, ist der
		// ganze String nicht printable
		if ( (*pStr < 256) && !String::IsPrintable( (char)*pStr, CHARSET_ANSI ) )
			return FALSE;
		pStr++;
	}

	return TRUE;
}

// -----------------------------------------------------------------------

BOOL UniString::IsPrintable( sal_Unicode c )
{
	if ( c < 256 )
		return String::IsPrintable( (char)c, CHARSET_ANSI );
	return TRUE;
}

// -----------------------------------------------------------------------

StringCompare UniString::Compare( const sal_Unicode* pCharStr,
								  xub_StrLen nLen ) const
{
	StringCompare eComp = CompareTo( pCharStr, nLen );
	if ( eComp == COMPARE_LESS )
		return COMPARE_GREATER;
	else if ( eComp == COMPARE_GREATER )
		return COMPARE_LESS;
	else
		return COMPARE_EQUAL;
}

// -----------------------------------------------------------------------

sal_Unicode& UniString::operator [] ( xub_StrLen nIndex )
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );
	DBG_ASSERT( nIndex <= mpData->mnLen, "UniString::operator[] - nIndex > UniString.Len()" );

	// Daten kopieren, wenn noetig
	if ( mpData->mnLen )
		ImplCopyData( this );

	// Referenz auf den Character an der Position nIndex zurueckgeben
	return mpData->maStr[nIndex];
}

// -----------------------------------------------------------------------

UniString UniString::Cut( xub_StrLen nIndex, xub_StrLen nCount )
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );

	// Ausschnitt retten, Auschneiden und ausgeschnittenen String zurueckgeben
	UniString aTempStr = Copy( nIndex, nCount );
	Erase( nIndex, nCount );
	return aTempStr;
}

// -----------------------------------------------------------------------

UniString& UniString::Replace( const UniString& rStr, xub_StrLen nIndex )
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );
	DBG_CHKOBJ( &rStr, UniString, DbgCheckUniString );

	// Muss ueberhaupt etwas ersetzt werden
	if ( (nIndex >= mpData->mnLen) || !rStr.mpData->mnLen )
		return *this;

	// Daten kopieren, wenn noetig
	ImplCopyData( this );

	// Anzahl der zu ersetzenden Zeichen ermitteln
	xub_StrLen nCount = Min( (xub_StrLen)(mpData->mnLen-nIndex), (xub_StrLen)(rStr.mpData->mnLen) );

	// Zeichen ersetzen
	for ( xub_StrLen i = 0; i < nCount; i++ )
		mpData->maStr[i+nIndex] = rStr.mpData->maStr[i];

	return *this;
}
