/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ffitem.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 01:07:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_tools.hxx"

#include <prewin.h>
#include <shutil.h>
#include <postwin.h>

#include <fastfsys.hxx>
#include "parser.hxx"
#include "impffsys.hxx"


ItemIDPathData::ItemIDPathData() :
m_bIsValid( FALSE ),
m_bIsDesktop( FALSE )
{
}

//--------------------------------------------------------------------------
//	Constructors & Destructor
//--------------------------------------------------------------------------

ItemIDPath::ItemIDPath()
{
	pData = new ItemIDPathData();
}

//--------------------------------------------------------------------------

ItemIDPath::~ItemIDPath()
{
	delete pData;
}

//--------------------------------------------------------------------------

ItemIDPath::ItemIDPath( void *pidl, size_t size )
{
	pData = new ItemIDPathData();
	
	pData->m_aPath = CItemIDList( (LPCITEMIDLIST) pidl );
	if ( !size )
		WIN_SHFree( pidl );
}

//--------------------------------------------------------------------------

ItemIDPath::ItemIDPath( const ItemIDPath & rPath )
{
	pData = new ItemIDPathData( *rPath.pData );
}

//--------------------------------------------------------------------------

ItemIDPath::ItemIDPath( const String &rDescription, BOOL )
{
	pData = new ItemIDPathData();

	String	aPath = GetHostNotationFromURL( rDescription );
	String	aSpecial;


	// Um auch URLs zu verstehen, die sowohl aus einem vorderen
	// "normalen" Teil und einem hinteren speziellen Teil bestehen
	// splitten wir die URL bei Bedarf.

	USHORT	nIndex = aPath.Search( '{', 0 );

	if ( nIndex != STRING_NOTFOUND )
	{
		aSpecial = aPath.Copy( nIndex );
		aPath.Erase( nIndex );
	}

	if ( aPath.Len() )
		pData->m_aPath = CItemIDList( aPath );
	else
		pData->m_aPath = CItemIDList( CSIDL_ROOT );

	if ( aSpecial.Len() )
		pData->m_aPath += ParseSpecialURL( aSpecial );
}

//--------------------------------------------------------------------------

ItemIDPath::ItemIDPath( SpecialFolderID eFolder )
{
	int nFolder;

	// Hack !!!

	switch ( eFolder )
	{
	case FOLDER_DESKTOP:
		nFolder = CSIDL_DESKTOP;
		break;
	case FOLDER_ROOT:
	case FOLDER_DRIVES:		// Das ist Ullies Root
		nFolder = CSIDL_ROOT;
		break;
	case FOLDER_NETWORK:
		nFolder = CSIDL_NETWORK;
		break;
	case FOLDER_CONTROLS:
		nFolder = CSIDL_CONTROLS;
		break;
	case FOLDER_PRINTERS:
		nFolder = CSIDL_PRINTERS;
		break;
	default:
		nFolder = -1;
		break;
	}

	pData = new ItemIDPathData();

	pData->m_aPath = CItemIDList( nFolder );
}

//--------------------------------------------------------------------------
//	Assignment
//--------------------------------------------------------------------------

ItemIDPath & ItemIDPath::operator = ( const ItemIDPath & rPath )
{
	*pData = *rPath.pData;

	return *this;
}

//--------------------------------------------------------------------------

ItemIDPath & ItemIDPath::operator = ( const String &rFileDescription )
{
	*this = ItemIDPath( rFileDescription );
	return *this;
}

//--------------------------------------------------------------------------
//	Concatenation
//--------------------------------------------------------------------------

ItemIDPath & ItemIDPath::operator += ( const ItemIDPath & rPath )
{
	pData->m_aPath += rPath.pData->m_aPath;
	pData->m_bIsDesktop = pData->m_bIsDesktop;

	return *this;
}

//--------------------------------------------------------------------------

ItemIDPath ItemIDPath::operator + ( const ItemIDPath & rPath ) const
{
	ItemIDPath	aCopy(*this);
	aCopy += rPath;
	return aCopy;
}

//--------------------------------------------------------------------------
//	Comparision
//--------------------------------------------------------------------------

int ItemIDPath::operator == ( const ItemIDPath & rPath ) const
{
	return pData->m_aPath == rPath.pData->m_aPath;
}

//--------------------------------------------------------------------------

int ItemIDPath::operator != ( const ItemIDPath & rPath ) const
{
	return !operator == ( rPath );
}

//--------------------------------------------------------------------------
//	ItemIDPath::SetData
//--------------------------------------------------------------------------

void ItemIDPath::SetData( void *pidl, size_t size )
{
	pData->m_aPath = CItemIDList( (LPCITEMIDLIST)pidl );

	if ( !size )
		WIN_SHFree( pidl );
}

//--------------------------------------------------------------------------
//	ItemIDPath::GetDataPtr
//--------------------------------------------------------------------------

const void * ItemIDPath::GetDataPtr() const
{
	return (LPCITEMIDLIST)pData->m_aPath;
}

//--------------------------------------------------------------------------
//	ItemIDPath::GetDataSize
//--------------------------------------------------------------------------

size_t ItemIDPath::GetDataSize() const
{
	ULONG	cb = WIN_SHGetIDListSize( (LPCITEMIDLIST)pData->m_aPath );

	return cb;
}

//--------------------------------------------------------------------------
//	ItemIDPath::GetFileDescription
//--------------------------------------------------------------------------

String	ItemIDPath::GetFileDescription () const
{
	return GetURLFromHostNotation(pData->m_aPath.GetFilePath());
}


//--------------------------------------------------------------------------
//	ItemIDPath::GetHostNotationPath
//--------------------------------------------------------------------------

String	ItemIDPath::GetHostNotationPath () const
{
	return pData->m_aPath.GetFilePath();
}


//--------------------------------------------------------------------------
//	ItemIDPath::GetBinaryDescription
//--------------------------------------------------------------------------

String	ItemIDPath::GetBinaryDescription () const
{
	return CreateStringFromItemIDList( pData->m_aPath );
}


//--------------------------------------------------------------------------
//	ItemIDPath::GetTokenCount
//--------------------------------------------------------------------------

int ItemIDPath::GetTokenCount() const
{
	return pData->m_aPath.GetTokenCount();
}

//--------------------------------------------------------------------------
//	ItemIDPath::GetToken
//--------------------------------------------------------------------------

ItemIDPath ItemIDPath::GetToken( int nIndex ) const
{
	ItemIDPath	aCopy;
	aCopy.pData->m_aPath = pData->m_aPath[nIndex];
	return aCopy;
}

//--------------------------------------------------------------------------
//	ItemIDPath::Split
//--------------------------------------------------------------------------


BOOL ItemIDPath::Split( ItemIDPath &rParent, ItemIDPath &rChild ) const
{
	pData->m_aPath.Split( rParent.pData->m_aPath, rChild.pData->m_aPath );
	return rParent.pData->m_aPath.IsValid() && rChild.pData->m_aPath.IsValid();
}

//--------------------------------------------------------------------------

ItemIDPath ItemIDPath::operator[] ( int nIndex ) const
{
	return GetToken( nIndex );
}

	
