/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.XMLStreamReaderImpl;
import com.sun.org.apache.xerces.internal.util.NamespaceContextWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.xml.internal.stream.events.AttributeImpl;
import com.sun.xml.internal.stream.events.NamespaceImpl;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamFilterImpl
implements XMLStreamReader {
    private StreamFilter fStreamFilter = null;
    private XMLStreamReader fStreamReader = null;
    private int fCurrentEventType = -1;
    private QName fElementName = null;
    private String fLocalName = null;
    private boolean fHasName = false;
    private boolean fReadNext = true;
    private boolean fHasMoreEvents = true;
    private boolean fReadFromCache = true;
    private ArrayList fCachedAttributes = null;
    private ArrayList fCachedNamespaceAttr = null;
    private NamespaceContextWrapper fCachedNamespaceContext = null;
    private String fCachedElementText = null;
    private int fCachedEventType = -1;
    private String fCachedVersion = null;
    private String fCachedEncoding = null;
    private boolean fCachedStandalone = false;
    private Location fCachedLocation = null;
    private String fCachedTextValue = null;
    private String fCachedPITarget = null;
    private String fCachedPIData = null;
    private String fCachedCharEncoding = null;
    private static boolean DEBUG = false;

    public XMLStreamFilterImpl(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) {
        this.fStreamReader = xMLStreamReader;
        this.fStreamFilter = streamFilter;
        this.fCachedAttributes = new ArrayList();
        this.fCachedNamespaceAttr = new ArrayList();
        try {
            if (!this.fStreamFilter.accept(this.fStreamReader)) {
                this.next();
                this.cache();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            System.err.println("Error while creating a stream Filter" + xMLStreamException);
        }
        this.fCurrentEventType = this.fStreamReader.getEventType();
        if (DEBUG) {
            System.out.println("Cached Event" + this.fCachedEventType);
        }
    }

    protected void setStreamFilter(StreamFilter streamFilter) {
        this.fStreamFilter = streamFilter;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.fReadNext) {
            this.fReadNext = false;
            this.cache();
            if (DEBUG) {
                System.out.println("Cached Event in hasNext" + this.fCachedEventType);
            }
            return this.readNext();
        }
        return this.fHasMoreEvents;
    }

    public void close() throws XMLStreamException {
        this.fStreamReader.close();
    }

    public int getAttributeCount() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeCount();
        }
        return this.fCachedAttributes.size();
    }

    public QName getAttributeName(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeName(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getName();
        }
        return null;
    }

    public String getAttributeNamespace(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeNamespace(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getName().getNamespaceURI();
        }
        return null;
    }

    public String getAttributePrefix(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributePrefix(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getName().getPrefix();
        }
        return null;
    }

    public String getAttributeType(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeType(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getDTDType();
        }
        return null;
    }

    public String getAttributeValue(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeValue(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getValue();
        }
        return null;
    }

    public String getAttributeValue(String string, String string2) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeValue(string, string2);
        }
        if (this.fCachedEventType != 1 || this.fCachedEventType != 10) {
            throw new IllegalStateException("Current event state is " + this.fCachedEventType);
        }
        for (int i = 0; i < this.fCachedAttributes.size(); ++i) {
            AttributeImpl attributeImpl = (AttributeImpl)this.fCachedAttributes.get(i);
            if (attributeImpl == null || !attributeImpl.getName().getLocalPart().equals(string2) || !string.equals(attributeImpl.getName().getNamespaceURI())) continue;
            return attributeImpl.getValue();
        }
        return null;
    }

    public String getCharacterEncodingScheme() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getCharacterEncodingScheme();
        }
        return this.fCachedCharEncoding;
    }

    public String getElementText() throws XMLStreamException {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getElementText();
        }
        if (this.fCachedEventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        return this.fCachedElementText;
    }

    public String getEncoding() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getEncoding();
        }
        return this.fCachedEncoding;
    }

    public int getEventType() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getEventType();
        }
        return this.fCachedEventType;
    }

    public String getLocalName() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getLocalName();
        }
        return this.fLocalName;
    }

    public Location getLocation() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getLocation();
        }
        return this.fCachedLocation;
    }

    public QName getName() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getName();
        }
        if (this.fCachedEventType == 1 || this.fCachedEventType == 2) {
            return this.fElementName;
        }
        throw new IllegalArgumentException("Illegal to call getName() when event type is " + this.fCachedEventType);
    }

    public NamespaceContext getNamespaceContext() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceContext();
        }
        return this.fCachedNamespaceContext;
    }

    public int getNamespaceCount() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceCount();
        }
        if (this.fCachedEventType == 1 || this.fCachedEventType == 2 || this.fCachedEventType == 13) {
            return this.fCachedNamespaceAttr.size();
        }
        throw new IllegalStateException("Current event state is " + this.fCachedEventType);
    }

    public String getNamespacePrefix(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespacePrefix(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getName().getPrefix();
        }
        return null;
    }

    public String getNamespaceURI() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceURI();
        }
        if ((this.fCachedEventType == 1 || this.fCachedEventType == 2) && this.fElementName != null) {
            return this.fElementName.getNamespaceURI();
        }
        return null;
    }

    public String getNamespaceURI(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceURI(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.getName().getNamespaceURI();
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceURI();
        }
        return this.fCachedNamespaceContext.getNamespaceURI(string);
    }

    public String getPIData() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getPIData();
        }
        return this.fCachedPIData;
    }

    public String getPITarget() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getPITarget();
        }
        return this.fCachedPITarget;
    }

    public String getPrefix() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getPrefix();
        }
        if (this.fCachedEventType == 1 || this.fCachedEventType == 2) {
            return this.fElementName.getPrefix();
        }
        return null;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.fStreamReader.getProperty(string);
    }

    public String getText() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getText();
        }
        return this.fCachedTextValue;
    }

    public char[] getTextCharacters() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextCharacters();
        }
        if (this.fCachedTextValue != null) {
            return this.fCachedTextValue.toCharArray();
        }
        return null;
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextCharacters(n, cArray, n2, n3);
        }
        if (cArray == null) {
            throw new NullPointerException("target char array can't be null");
        }
        if (n2 < 0 || n3 < 0 || n < 0 || n2 >= cArray.length || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.fCachedTextValue == null) {
            return 0;
        }
        int n4 = 0;
        int n5 = this.fCachedTextValue.length() - n;
        if (n5 < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
        }
        n4 = n5 < n3 ? n5 : n3;
        System.arraycopy(this.fCachedTextValue, n, cArray, n2, n4);
        return n4;
    }

    public int getTextLength() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextLength();
        }
        if (this.fCachedTextValue != null) {
            return this.fCachedTextValue.length();
        }
        return 0;
    }

    public int getTextStart() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextStart();
        }
        return 0;
    }

    public String getVersion() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getVersion();
        }
        return this.fCachedVersion;
    }

    public boolean hasName() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.hasName();
        }
        return this.fCachedEventType == 1 || this.fCachedEventType == 2 || this.fCachedEventType == 9 || this.fCachedEventType == 3;
    }

    public boolean hasText() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.hasText();
        }
        return this.fCachedTextValue != null;
    }

    public boolean isAttributeSpecified(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isAttributeSpecified(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            return attributeImpl.isSpecified();
        }
        return false;
    }

    public boolean isCharacters() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isCharacters();
        }
        return this.fCachedEventType == 4;
    }

    public boolean isEndElement() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isEndElement();
        }
        return this.fCachedEventType == 2;
    }

    public boolean isStandalone() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isStandalone();
        }
        return this.fCachedStandalone;
    }

    public boolean isStartElement() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isStartElement();
        }
        return this.fCachedEventType == 1;
    }

    public boolean isWhiteSpace() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isWhiteSpace();
        }
        if (this.isCharacters() || this.fCachedEventType == 12) {
            if (this.fCachedTextValue == null) {
                return false;
            }
            char[] cArray = this.fCachedTextValue.toCharArray();
            int n = 0;
            int n2 = this.fCachedTextValue.length();
            for (int i = n; i < n2; ++i) {
                if (XMLChar.isSpace(cArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int next() throws XMLStreamException {
        if (this.fReadNext) {
            if (this.readNext()) {
                this.fReadFromCache = false;
            }
        } else {
            this.fReadNext = true;
            this.fReadFromCache = false;
        }
        return this.fCurrentEventType;
    }

    public int nextTag() throws XMLStreamException {
        if (this.fReadNext) {
            if (this.readNextTag()) {
                this.fReadFromCache = false;
            }
        } else {
            this.fReadNext = true;
            if (this.fCurrentEventType != 1 || this.fCurrentEventType != 2) {
                this.fCurrentEventType = this.fStreamReader.nextTag();
                this.fReadFromCache = false;
            }
        }
        return this.fCurrentEventType;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (!this.fReadFromCache) {
            this.fStreamReader.require(n, string, string2);
        } else {
            if (n != this.fCachedEventType) {
                throw new XMLStreamException("Event type " + XMLStreamReaderImpl.getEventTypeString(n) + " specified did not match with current parser event");
            }
            if (string != null && !string.equals(this.getNamespaceURI())) {
                throw new XMLStreamException("Namespace URI " + string + " specified did not match with current namespace URI");
            }
            if (string2 != null && !string2.equals(this.getLocalName())) {
                throw new XMLStreamException("LocalName " + string2 + " specified did not match with current local name");
            }
        }
    }

    public boolean standaloneSet() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.standaloneSet();
        }
        return this.fCachedStandalone;
    }

    public String getAttributeLocalName(int n) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeLocalName(n);
        }
        AttributeImpl attributeImpl = this.getCachedAttribute(n);
        if (attributeImpl != null) {
            attributeImpl.getName().getLocalPart();
        }
        return null;
    }

    private void cache() {
        this.fReadFromCache = true;
        this.fCachedEventType = this.fCurrentEventType;
        this.clearCache();
        this.fCachedLocation = this.fStreamReader.getLocation();
        switch (this.fCurrentEventType) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                this.fCachedTextValue = this.fStreamReader.getText();
                break;
            }
            case 11: {
                this.fCachedTextValue = this.fStreamReader.getText();
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                this.fElementName = this.fStreamReader.getName();
                this.fHasName = this.fStreamReader.hasName();
                this.fLocalName = this.fElementName.getLocalPart();
                this.cacheNamespaceContext();
                break;
            }
            case 15: {
                break;
            }
            case 14: {
                break;
            }
            case 9: {
                this.fLocalName = this.fStreamReader.getLocalName();
                this.fCachedTextValue = this.fStreamReader.getText();
                break;
            }
            case 3: {
                this.fCachedPIData = this.fStreamReader.getPIData();
                this.fCachedPITarget = this.fStreamReader.getPITarget();
                break;
            }
            case 7: {
                this.fCachedVersion = this.fStreamReader.getVersion();
                this.fCachedEncoding = this.fStreamReader.getEncoding();
                this.fCachedStandalone = this.fStreamReader.isStandalone();
                this.fCachedCharEncoding = this.fStreamReader.getCharacterEncodingScheme();
                break;
            }
            case 1: {
                try {
                    this.fElementName = this.fStreamReader.getName();
                    this.fHasName = this.fStreamReader.hasName();
                    this.fLocalName = this.fElementName.getLocalPart();
                    if (DEBUG) {
                        System.out.println("Name is " + this.fLocalName);
                        System.out.println("Name is " + this.fElementName);
                    }
                    this.cacheAttributes();
                    this.cacheNamespaceAttributes();
                    this.cacheNamespaceContext();
                    if (!this.fStreamReader.hasText()) break;
                    this.fCachedElementText = this.fStreamReader.getElementText();
                    break;
                }
                catch (Exception exception) {
                    System.err.println("Error occurred while trying to cache START_ELEMENT" + exception.getMessage());
                }
            }
        }
    }

    private boolean readNext() throws XMLStreamException {
        while (this.fStreamReader.hasNext()) {
            this.fStreamReader.next();
            this.fHasMoreEvents = this.fStreamFilter.accept(this.fStreamReader);
            if (!this.fHasMoreEvents) continue;
            this.fCurrentEventType = this.fStreamReader.getEventType();
            return true;
        }
        this.fHasMoreEvents = false;
        return false;
    }

    private boolean readNextTag() throws XMLStreamException {
        while (this.fStreamReader.hasNext()) {
            this.fStreamReader.nextTag();
            this.fHasMoreEvents = this.fStreamFilter.accept(this.fStreamReader);
            if (!this.fHasMoreEvents) continue;
            this.fCurrentEventType = this.fStreamReader.getEventType();
            return true;
        }
        this.fHasMoreEvents = false;
        return false;
    }

    private void cacheAttributes() {
        int n = this.fStreamReader.getAttributeCount();
        QName qName = null;
        String string = null;
        String string2 = null;
        AttributeImpl attributeImpl = null;
        this.fCachedAttributes.clear();
        for (int i = 0; i < n; ++i) {
            qName = this.fStreamReader.getAttributeName(i);
            string = qName.getPrefix();
            string2 = qName.getLocalPart();
            attributeImpl = new AttributeImpl();
            attributeImpl.setName(qName);
            attributeImpl.setAttributeType(this.fStreamReader.getAttributeType(i));
            attributeImpl.setSpecified(this.fStreamReader.isAttributeSpecified(i));
            attributeImpl.setValue(this.fStreamReader.getAttributeValue(i));
            this.fCachedAttributes.add(attributeImpl);
        }
    }

    protected void cacheNamespaceAttributes() {
        int n = this.fStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        this.fCachedNamespaceAttr.clear();
        for (int i = 0; i < n; ++i) {
            string = this.fStreamReader.getNamespaceURI(i);
            string2 = this.fStreamReader.getNamespacePrefix(i);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            this.fCachedNamespaceAttr.add(namespaceImpl);
        }
    }

    private void cacheNamespaceContext() {
        NamespaceContextWrapper namespaceContextWrapper = (NamespaceContextWrapper)this.fStreamReader.getNamespaceContext();
        NamespaceSupport namespaceSupport = new NamespaceSupport(namespaceContextWrapper.getNamespaceContext());
        this.fCachedNamespaceContext = new NamespaceContextWrapper(namespaceSupport);
    }

    private AttributeImpl getCachedAttribute(int n) {
        if (this.fCachedEventType == 1 || this.fCachedEventType == 10) {
            if (n < this.fCachedAttributes.size()) {
                return (AttributeImpl)this.fCachedAttributes.get(n);
            }
        } else {
            throw new IllegalStateException("Current event state is " + this.fCachedEventType);
        }
        return null;
    }

    private void clearCache() {
        this.fCachedAttributes.clear();
        this.fCachedNamespaceAttr.clear();
        this.fCachedNamespaceContext = null;
        this.fCachedElementText = null;
        this.fCachedVersion = null;
        this.fCachedEncoding = null;
        this.fCachedLocation = null;
        this.fCachedTextValue = null;
        this.fCachedPITarget = null;
        this.fCachedPIData = null;
        this.fCachedCharEncoding = null;
        this.fElementName = null;
        this.fHasName = false;
        this.fLocalName = null;
    }
}

