/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.PropertyPermission;
import sun.misc.Launcher;
import sun.security.util.SecurityConstants;

class PathPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 8133287259134945693L;
    private File[] path;
    private Permissions perms;
    URL codeBase;

    PathPermissions(File[] fileArray) {
        this.path = fileArray;
        this.perms = null;
        this.codeBase = null;
    }

    URL getCodeBase() {
        return this.codeBase;
    }

    public void add(Permission permission) {
        throw new SecurityException("attempt to add a permission");
    }

    private synchronized void init() {
        if (this.perms != null) {
            return;
        }
        this.perms = new Permissions();
        this.perms.add(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
        this.perms.add(new PropertyPermission("java.*", "read"));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < PathPermissions.this.path.length; ++i) {
                    String string;
                    File file = PathPermissions.this.path[i];
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = file.getAbsolutePath();
                    }
                    if (i == 0) {
                        PathPermissions.this.codeBase = Launcher.getFileURL(new File(string));
                    }
                    if (file.isDirectory()) {
                        if (string.endsWith(File.separator)) {
                            PathPermissions.this.perms.add(new FilePermission(string + "-", "read"));
                            continue;
                        }
                        PathPermissions.this.perms.add(new FilePermission(string + File.separator + "-", "read"));
                        continue;
                    }
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n == -1) continue;
                    string = string.substring(0, n + 1) + "-";
                    PathPermissions.this.perms.add(new FilePermission(string, "read"));
                }
                return null;
            }
        });
    }

    public boolean implies(Permission permission) {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.implies(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        if (this.perms == null) {
            this.init();
        }
        Permissions permissions = this.perms;
        synchronized (permissions) {
            return this.perms.elements();
        }
    }

    public String toString() {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.toString();
    }
}

