/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Scale.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:14:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "Scale.hxx"
#include "macros.hxx"

using namespace ::com::sun::star;

using ::osl::MutexGuard;

namespace
{
static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart2.Scale" ));
} // anonymous namespace

namespace chart
{

Scale::Scale( uno::Reference< uno::XComponentContext > const & xContext ) :
        m_xContext( xContext )
{}

Scale::Scale( uno::Reference< uno::XComponentContext > const & xContext,
                const chart2::ScaleData & rScaleData ) :
        m_aScale( rScaleData ),
        m_xContext( xContext )
{}

Scale::~Scale()
{}

void SAL_CALL Scale::setScaleData( const chart2::ScaleData& aScale )
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_aScale = aScale;
    // \--
}

chart2::ScaleData SAL_CALL Scale::getScaleData()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_aScale;
    // \--
}

// ____ XServiceInfo ____

uno::Sequence< ::rtl::OUString > Scale::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.Scale" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( Scale, lcl_aServiceName );

} //  namespace chart
