/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dp_resource.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: vg $ $Date: 2006/09/26 14:21:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_desktop.hxx"

#include "dp_misc.h"
#include "dp_resource.h"
#include "osl/module.hxx"
#include "osl/mutex.hxx"
#include "rtl/ustring.h"
#include "cppuhelper/implbase1.hxx"
#include "unotools/configmgr.hxx"


using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using ::rtl::OUString;

namespace dp_misc {
namespace {

struct OfficeLocale :
        public rtl::StaticWithInit<const lang::Locale, OfficeLocale> {
    const lang::Locale operator () () {
        OUString slang;
        if (! (::utl::ConfigManager::GetDirectConfigProperty(
                   ::utl::ConfigManager::LOCALE ) >>= slang))
            throw RuntimeException( OUSTR("Cannot determine language!"), 0 );
        //fallback, the locale is currently only set when the user starts the
        //office for the first time.
        if (slang.getLength() == 0)
            slang =  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("en-US"));
        return toLocale(slang);
    }
};

void dummy() {}
struct DeploymentResMgr : public rtl::StaticWithInit<
    ResMgr *, DeploymentResMgr> {
    ResMgr * operator () () {
        return ResMgr::CreateResMgr( "deployment" LIBRARY_SOLARUPD(),
                                     OfficeLocale::get() );
    }
};

osl::Mutex s_mutex;

} // anon namespace

//==============================================================================
ResId getResId( USHORT id )
{
    const osl::MutexGuard guard( s_mutex );
    return ResId( id, DeploymentResMgr::get() );
}

//==============================================================================
String getResourceString( USHORT id )
{
    const osl::MutexGuard guard( s_mutex );
    String ret( ResId( id, DeploymentResMgr::get() ) );
    if (ret.SearchAscii( "%PRODUCTNAME" ) != STRING_NOTFOUND) {
        static String s_brandName;
        if (s_brandName.Len() == 0) {
            OUString brandName(
                ::utl::ConfigManager::GetDirectConfigProperty(
                    ::utl::ConfigManager::PRODUCTNAME ).get<OUString>() );
            s_brandName = brandName;
        }
        ret.SearchAndReplaceAllAscii( "%PRODUCTNAME", s_brandName );
    }
    return ret;
}

//throws an Exception on failure
//primary subtag 2 or three letters(A-Z, a-z), i or x
void checkPrimarySubtag(::rtl::OUString const & tag)
{
	sal_Int32 len = tag.getLength();
	sal_Unicode const * arLang = tag.getStr();
	if (len < 1 || len > 3)
		throw Exception(OUSTR("Invalid language string."), 0);

	if (len == 1 
		&& (arLang[0] != 'i' && arLang[0] != 'x'))
		throw Exception(OUSTR("Invalid language string."), 0);

	if (len == 2 || len == 3)
	{
		for (sal_Int32 i = 0; i < len; i++)
		{
			if ( !((arLang[i] >= 'A' && arLang[i] <= 'Z')
				|| (arLang[i] >= 'a' && arLang[i] <= 'z')))
			{
				throw Exception(OUSTR("Invalid language string."), 0);
			}
		}
	}
}

//throws an Exception on failure
//second subtag 2 letter country code or 3-8 letter other code(A-Z, a-z, 0-9)
void checkSecondSubtag(::rtl::OUString const & tag, bool & bIsCountry)
{
	sal_Int32 len = tag.getLength();
	sal_Unicode const * arLang = tag.getStr();
	if (len < 2 || len > 8)
		throw Exception(OUSTR("Invalid language string."), 0);
	//country code
	bIsCountry = false;
	if (len == 2)		
	{
		for (sal_Int32 i = 0; i < 2; i++)
		{
			if (!( (arLang[i] >= 'A' && arLang[i] <= 'Z')
				|| (arLang[i] >= 'a' && arLang[i] <= 'z')))
			{
				throw Exception(OUSTR("Invalid language string."), 0);
			}
		}
		bIsCountry = true;
	}

	if (len > 2)
	{
		for (sal_Int32 i = 0; i < len; i++)
		{
			if (!( (arLang[i] >= 'A' && arLang[i] <= 'Z')
				|| (arLang[i] >= 'a' && arLang[i] <= 'z') 
				|| (arLang[i] >= '0' && arLang[i] <= '9') ))
			{
				throw Exception(OUSTR("Invalid language string."), 0);
			}
		}
	}
}

void checkThirdSubtag(::rtl::OUString const & tag)
{
	sal_Int32 len = tag.getLength();
	sal_Unicode const * arLang = tag.getStr();
	if (len < 1 || len > 8)
		throw Exception(OUSTR("Invalid language string."), 0);	

	for (sal_Int32 i = 0; i < len; i++)
	{
		if (!( (arLang[i] >= 'A' && arLang[i] <= 'Z')
			|| (arLang[i] >= 'a' && arLang[i] <= 'z') 
			|| (arLang[i] >= '0' && arLang[i] <= '9') ))
		{
			throw Exception(OUSTR("Invalid language string."), 0);
		}
	}
}

//=============================================================================

//We parse the string acording to RFC 3066
//We only use the primary sub-tag and two subtags. That is lang-country-variant
//We do some simple tests if the string is correct. Actually this should do a 
//validating parser
//We may have the case that there is no country tag, for example en-welsh
::com::sun::star::lang::Locale toLocale( ::rtl::OUString const & slang )
{
	OUString _sLang = slang.trim();
    ::com::sun::star::lang::Locale locale;
    sal_Int32 nIndex = 0;
	OUString lang = _sLang.getToken( 0, '-', nIndex );
	checkPrimarySubtag(lang);
	locale.Language = lang;
	OUString country = _sLang.getToken( 0, '-', nIndex );
	if (country.getLength() > 0)
	{
		bool bIsCountry = false;
		checkSecondSubtag(country, bIsCountry);
		if (bIsCountry)
		{
			locale.Country = country;
		}
		else
		{
			 locale.Variant = country;
		}
	}
    if (locale.Variant.getLength() == 0)
	{
		OUString variant = _sLang.getToken( 0, '-', nIndex );
		if (variant.getLength() > 0)
		{
			checkThirdSubtag(variant);
			locale.Variant = variant;
		}
	}
   
    return locale;
}

//==============================================================================
lang::Locale const & getOfficeLocale()
{
    return OfficeLocale::get();
}

}

