/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: errorhdl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 13:06:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_extensions.hxx"


#ifndef _COM_SUN_STAR_TASK_XINTERACTIONCONTINUATION_HPP_
#include <com/sun/star/task/XInteractionContinuation.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONRETRY_HPP_
#include <com/sun/star/task/XInteractionRetry.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONAPPROVE_HPP_
#include <com/sun/star/task/XInteractionApprove.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONDISAPPROVE_HPP_
#include <com/sun/star/task/XInteractionDisapprove.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONABORT_HPP_
#include <com/sun/star/task/XInteractionAbort.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif

#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif

#include <rtl/uuid.h>
#include <rtl/memory.h>

#include "errorhdl.hxx"

using namespace ::rtl;
using namespace ::com::sun::star;

#include <cppuhelper/implbase5.hxx> 

class InteractionContinuationImpl : public ::cppu::WeakImplHelper5< task::XInteractionRetry, task::XInteractionApprove, task::XInteractionDisapprove, task::XInteractionAbort, lang::XUnoTunnel >
{
private:
	sal_Bool	mbSelected;
	USHORT	mEC;
public:
	InteractionContinuationImpl( USHORT ErrorContinuation );

	sal_Bool isSelected() const { return mbSelected; }
	USHORT getErrorContinuation() const { return mEC; }

	// XInteractionContinuation
	virtual void SAL_CALL select(void) throw(uno::RuntimeException);

	static const uno::Sequence< sal_Int8 > & getUnoTunnelId() throw();
	static InteractionContinuationImpl* getImplementation( uno::Reference< uno::XInterface > xInt ) throw();
    virtual sal_Int64 SAL_CALL getSomething( const uno::Sequence< sal_Int8 >& aIdentifier ) throw(uno::RuntimeException);
};

InteractionContinuationImpl::InteractionContinuationImpl( USHORT ErrorContinuation )
: mbSelected( sal_False ),
  mEC( ErrorContinuation )
{
}

void SAL_CALL InteractionContinuationImpl::select(void) throw(uno::RuntimeException)
{
	mbSelected = sal_True;
}

const ::com::sun::star::uno::Sequence< sal_Int8 > & InteractionContinuationImpl::getUnoTunnelId() throw()
{
	static ::com::sun::star::uno::Sequence< sal_Int8 > * pSeq = 0;
	if( !pSeq )
	{
		::osl::Guard< ::osl::Mutex > aGuard( ::osl::Mutex::getGlobalMutex() );
		if( !pSeq )
		{
			static ::com::sun::star::uno::Sequence< sal_Int8 > aSeq( 16 );
			rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0, sal_True );
			pSeq = &aSeq;
		}
	}
	return *pSeq;
}
\
InteractionContinuationImpl* InteractionContinuationImpl::getImplementation( uno::Reference< uno::XInterface > xInt ) throw()
{
	::com::sun::star::uno::Reference< ::com::sun::star::lang::XUnoTunnel > xUT( xInt, ::com::sun::star::uno::UNO_QUERY );
	if( xUT.is() )
		return (InteractionContinuationImpl*)xUT->getSomething( InteractionContinuationImpl::getUnoTunnelId() );
	else
		return NULL;
}
\
sal_Int64 SAL_CALL InteractionContinuationImpl::getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& rId ) throw(::com::sun::star::uno::RuntimeException)
{
	if( rId.getLength() == 16 && 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(),
														 rId.getConstArray(), 16 ) )
	{
		return (sal_Int64)this;
	}
	return 0;
}

// --------------------------------------------------------------------
// XInteractionContinuation

InteractionRequest_impl::InteractionRequest_impl( const uno::Any& rRequest, USHORT nResponseFlags )
: maRequest( rRequest )
{
	sal_Int32 nLength = 0;
	if( nResponseFlags & EC_YES ) nLength++;
	if( nResponseFlags & EC_NO ) nLength++;
	if( nResponseFlags & EC_RETRY ) nLength++;
	if( nResponseFlags & EC_ABORT ) nLength++;

	maContinuations.realloc( nLength );
	uno::Reference< task::XInteractionContinuation >* pContinuations = maContinuations.getArray();

	if( nResponseFlags & EC_YES )
		*pContinuations++ = (task::XInteractionApprove*)new InteractionContinuationImpl( EC_YES );

	if( nResponseFlags & EC_NO )
		*pContinuations++ = (task::XInteractionDisapprove*)new InteractionContinuationImpl( EC_NO );

	if( nResponseFlags & EC_RETRY )
		*pContinuations++ = (task::XInteractionRetry*)new InteractionContinuationImpl( EC_RETRY );

	if( nResponseFlags & EC_ABORT )
		*pContinuations++ = (task::XInteractionAbort*)new InteractionContinuationImpl( EC_ABORT );
}

uno::Any SAL_CALL InteractionRequest_impl::getRequest(void) throw(uno::RuntimeException)
{
	return maRequest;
}

uno::Sequence< uno::Reference< task::XInteractionContinuation > > InteractionRequest_impl::getContinuations(void) throw(uno::RuntimeException)
{
	return maContinuations;
}

USHORT InteractionRequest_impl::getSelection() const
{
	sal_Int32 nLength = maContinuations.getLength();
	const uno::Reference< task::XInteractionContinuation >* pContinuations = maContinuations.getConstArray();

	while( nLength-- )
	{
		InteractionContinuationImpl* pCont = InteractionContinuationImpl::getImplementation( *pContinuations++ );
		
		if( pCont && pCont->isSelected() )
			return pCont->getErrorContinuation();
	}

	return 0;
}

ucb::IOErrorCode SvStreamErrorToUCBIoErrorCode( ULONG nError )
{
	ucb::IOErrorCode eReturn;
	switch( nError )
	{
	case SVSTREAM_GENERALERROR:			eReturn = ucb::IOErrorCode_ABORT; break;
	case SVSTREAM_FILE_NOT_FOUND:		eReturn = ucb::IOErrorCode_NOT_EXISTING; break;
	case SVSTREAM_PATH_NOT_FOUND:		eReturn = ucb::IOErrorCode_NOT_EXISTING_PATH; break;
	case SVSTREAM_TOO_MANY_OPEN_FILES:	eReturn = ucb::IOErrorCode_OUT_OF_FILE_HANDLES; break;
	case SVSTREAM_ACCESS_DENIED:		eReturn = ucb::IOErrorCode_ACCESS_DENIED; break;
	case SVSTREAM_SHARING_VIOLATION:	eReturn = ucb::IOErrorCode_LOCKING_VIOLATION; break;

	case SVSTREAM_INVALID_ACCESS:		eReturn = ucb::IOErrorCode_INVALID_ACCESS; break;
	case SVSTREAM_CANNOT_MAKE:			eReturn = ucb::IOErrorCode_CANT_CREATE; break;
	case SVSTREAM_INVALID_PARAMETER:	eReturn = ucb::IOErrorCode_INVALID_PARAMETER; break;

	case SVSTREAM_READ_ERROR:			eReturn = ucb::IOErrorCode_CANT_READ; break;
	case SVSTREAM_WRITE_ERROR:			eReturn = ucb::IOErrorCode_CANT_WRITE; break;
	case SVSTREAM_SEEK_ERROR:			eReturn = ucb::IOErrorCode_CANT_SEEK; break;
	case SVSTREAM_TELL_ERROR:			eReturn = ucb::IOErrorCode_CANT_TELL; break;

	case SVSTREAM_OUTOFMEMORY:			eReturn = ucb::IOErrorCode_OUT_OF_MEMORY; break;

	case SVSTREAM_FILEFORMAT_ERROR:		eReturn = ucb::IOErrorCode_WRONG_FORMAT; break;
	case SVSTREAM_WRONGVERSION:			eReturn = ucb::IOErrorCode_WRONG_VERSION;
	case SVSTREAM_DISK_FULL:			eReturn = ucb::IOErrorCode_OUT_OF_DISK_SPACE; break;

	case ERRCODE_IO_BADCRC:				eReturn = ucb::IOErrorCode_BAD_CRC; break;

	case SVSTREAM_OK:
	default:
										eReturn = ucb::IOErrorCode_UNKNOWN;
	}

	return eReturn;
}

