<?xml version="1.0" encoding="UTF-8"?>
<!--

    OpenOffice.org - a multi-platform office productivity suite
 
    $RCSfile: master_document.xsl,v $
 
    $Revision: 1.6 $
 
    last change: $Author: rt $ $Date: 2005/09/08 22:09:06 $
 
    The Contents of this file are made available subject to
    the terms of GNU Lesser General Public License Version 2.1.
 
 
      GNU Lesser General Public License Version 2.1
      =============================================
      Copyright 2005 by Sun Microsystems, Inc.
      901 San Antonio Road, Palo Alto, CA 94303, USA
 
      This library is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License version 2.1, as published by the Free Software Foundation.
 
      This library is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
 
      You should have received a copy of the GNU Lesser General Public
      License along with this library; if not, write to the Free Software
      Foundation, Inc., 59 Temple Place, Suite 330, Boston,
      MA  02111-1307  USA
 
-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:office="http://openoffice.org/2000/office"
		xmlns:style="http://openoffice.org/2000/style"
		xmlns:text="http://openoffice.org/2000/text"
		xmlns:table="http://openoffice.org/2000/table"
		xmlns:draw="http://openoffice.org/2000/drawing"
		xmlns:fo="http://www.w3.org/1999/XSL/Format"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:number="http://openoffice.org/2000/datastyle"
		xmlns:svg="http://www.w3.org/2000/svg"
		xmlns:chart="http://openoffice.org/2000/chart"
		xmlns:dr3d="http://openoffice.org/2000/dr3d"
		xmlns:math="http://www.w3.org/1998/Math/MathML"
		xmlns:form="http://openoffice.org/2000/form"
		xmlns:script="http://openoffice.org/2000/script"
		xmlns:dc="http://purl.org/dc/elements/1.1/"
		xmlns:meta="http://openoffice.org/2000/meta"
		xmlns:config="http://openoffice.org/2001/config"
		xmlns:help="http://openoffice.org/2000/help"
		xmlns:java="http://xml.apache.org/xslt/java"
		xmlns:sxg="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoMasterDocument"
		xmlns:sxg-xt="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoNodeHandlingXT"
		xmlns="http://www.w3.org/1999/xhtml"
		version="1.0"
		exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java sxg sxg-xt">

	<xsl:include href="master_refs_workaround.xsl" />
	<xsl:include href="master_chapter_numbering.xsl" />
	<xsl:include href="master_usability_links.xsl" />

	<!--
	SUMMARY:
	 following parameter triggers a (quite time consuming) workaround for enabling of chapter links in the table-of-content.

	IN DETAIL:
	 Currently some links used in the Office XML (for example, in the content table as '#7.Some%20Example%20Headline%7Outline')
	 are not a valid URLs (cp. bug id# 102311).
	 No file destination is specified nor exist any anchor element for these links in the Office XML.
	 A workaround for this transformation therefore had to be made. This time-consuming mechanism is disabled by default and
	 can be activated by a parameter (i.e. 'childDocumentExist'). A creation of an anchor is made for each header element.
	 All header titles gonna be encoded to be usable in a relative URL.  -->
	<xsl:param name="childDocumentExist" select="boolean(/*/office:body/text:section/text:section-source/@xlink:href)" />

	<!-- Used for the bug workaround of missing content table links
		To avoid ambigous HTML references from the content table -->
	<xsl:param name="currentChildContentRef" />

	<!-- Used for the bug workaround of missing content table links
		By this node-set the relation between content-table link and children document header can be unambigous established -->
	<xsl:param name="contentTableHeadings" />



	<!-- ******************************************************************************************************* -->
	<!-- ***  TRANSFORMATION OF ALL CHILD DOCUMENTS OF THE MASTER DOCUMENT BY USING A EXTERNAL HELPER CLASS  *** -->
	<!-- ******************************************************************************************************* -->


	<!-- a new element 'contentTableHeadings' will be added to the helper variable the first time a child will be transformed -->
	<xsl:template name="transform-global-document-and-children">
		<xsl:param name="globalData" />

		<xsl:choose>
			<xsl:when test="$globalData/content-table-headings">
				<xsl:call-template name="start-child-transformation">
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- The necessary auxiliary variable hasn't build yet.
				This variable gonna store all headers (with chapter numbers) and the URL of their files

				After the creation the template 'start-self-and-children-transformation'
				is being called!  -->
				<xsl:call-template name="create-helper-variables-for-Content-Table">
					<xsl:with-param name="globalData" select="$globalData" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="start-self-and-children-transformation">
		<xsl:param name="globalData" />

		<xsl:if test="$debugEnabled">
			<xsl:call-template name="debug-content-table-headings-variable">
				<xsl:with-param name="globalData" select="$globalData" />
			</xsl:call-template>

			<xsl:message>Parsing the master document...</xsl:message>
		</xsl:if>


		<xsl:apply-templates>
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:apply-templates>


		<xsl:if test="$debugEnabled">
			<xsl:message>Parsing the child documents...</xsl:message>
		</xsl:if>
		<xsl:call-template name="start-child-transformation">
			<xsl:with-param name="globalData" select="$globalData" />
		</xsl:call-template>
	</xsl:template>




	<xsl:template name="start-child-transformation">
		<xsl:param name="globalData" />

		<xsl:if test="$debugEnabled">
			<xsl:message>Starting the child transformations...</xsl:message>
		</xsl:if>

		<!-- As the childs of a master document (with suffix .sxg) do not know anything about their global parent,
			the transformation of master documents children have to be done implizit.
			Otherwise the chapter number of the children will always start with zero, as they do not know anything about the
			proceding chapters.
			Furthermore, they don't have any links about preceeding and following documents and no linking for usability reasons
			could be done. Therefore the children have to be transformed during the transformation of a global (sxg) document -->
		<xsl:if test="$debugEnabled">
			<xsl:choose>
				<xsl:when test="$globalData/content-table-headings">
					<xsl:message>Contentable data exists as global data!</xsl:message>
				</xsl:when>
				<xsl:otherwise>
					<xsl:message>No Contentable global data exists!</xsl:message>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<!-- testcase giving out the variable as file
		<xsl:element name="debug-output">
		<xsl:copy-of select="$globalData/content-table-headings" />
		</xsl:element> -->

		<!-- currently this function only works with node-sets from XT -->
		<xsl:choose>
			<xsl:when test="function-available('sxg-xt:transform-children')">
				<xsl:message>
					<xsl:value-of select="sxg-xt:transform-children( $globalData/content-table-headings, string($sourceBaseURL), string($targetBaseURL), string($optionalURLSuffix), string($dpi), string($outputType), $childDocumentExist, $debugEnabled)" />
				</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Java method transformChildren to transform all children of a master document could not be found. Be sure to use the XT processor.</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="debug-content-table-headings-variable">
		<xsl:param name="globalData" />

		<xsl:message>
			<xsl:text>**** THE HEADING VARIABLE **** </xsl:text>
		</xsl:message>

		<xsl:for-each select="$globalData/content-table-headings/heading">
			<xsl:message>
				<xsl:text>**** new heading:        </xsl:text>
			</xsl:message>
			<xsl:message>content-table-id:      <xsl:value-of select="@content-table-id" />
			</xsl:message>
			<xsl:message>child-document-no:     <xsl:value-of select="@child-document-no" />
			</xsl:message>
			<xsl:message>file-url:              <xsl:value-of select="@file-url" />
			</xsl:message>
			<xsl:message>out-file-url:          <xsl:value-of select="@out-file-url" />
			</xsl:message>
			<xsl:message>level:                 <xsl:value-of select="@level" />
			</xsl:message>
			<xsl:message>title:                 <xsl:value-of select="@title" />
			</xsl:message>
			<xsl:message>encoded-title:         <xsl:value-of select="@encoded-title" />
			</xsl:message>
			<xsl:message>absolute-chapter-level:<xsl:value-of select="@absolute-chapter-level" />
			</xsl:message>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>