/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: frameloaderfactory.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 14:10:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICES_FRAMELOADERFACTORY_HXX_
#include <services/frameloaderfactory.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XSYNCHRONOUSFRAMELOADER_HPP_
#include <com/sun/star/frame/XSynchronousFrameLoader.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::beans					;
using namespace ::com::sun::star::frame					;
using namespace ::com::sun::star::container				;
using namespace ::com::sun::star::lang					;
using namespace ::com::sun::star::registry				;
using namespace ::com::sun::star::uno					;
using namespace ::cppu									;
using namespace ::osl									;
using namespace ::rtl									;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
FrameLoaderFactory::FrameLoaderFactory( const Reference< XMultiServiceFactory >& xFactory )
		//	Init baseclasses first
		//	Attention:
		//		Don't change order of initialization!
		//      ThreadHelpBase is a struct with a mutex as member. We can't use a mutex as member directly, while
		//		we must garant right initialization and a valid value of this! First initialize
		//		baseclasses and then members. And we need the mutex for other baseclasses !!!
		:	ThreadHelpBase	(			)
		,	OWeakObject		(			)
		// Init member
		,	m_xFactory		( xFactory	)
		,	m_aCache		(			)
{
	// Safe impossible cases
	// We can't work without valid initialization.
	LOG_ASSERT( impldbg_checkParameter_FrameLoaderFactory( xFactory ), "FrameLoaderFactory::FrameLoaderFactory()\nInvalid parameter detected!\n" )
	// Safe impossible cases
	// We need our cache for working.
    LOG_ASSERT( !(m_aCache.isValidOrRepairable()==sal_False), "FrameLoaderFactory::FrameLoaderFactory()\nInitializing of cache failed. Factory can't work so!\n" )
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
FrameLoaderFactory::~FrameLoaderFactory()
{
	// Our cache is cleared automaticly!
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************
DEFINE_XINTERFACE_5						(	FrameLoaderFactory						,
											OWeakObject								,
											DIRECT_INTERFACE(XTypeProvider			),
											DIRECT_INTERFACE(XServiceInfo			),
											DIRECT_INTERFACE(XMultiServiceFactory	),
											DIRECT_INTERFACE(XNameAccess			),
											DIRECT_INTERFACE(XElementAccess			)
										)

DEFINE_XTYPEPROVIDER_5					(	FrameLoaderFactory	,
											XTypeProvider		,
											XServiceInfo		,
											XMultiServiceFactory,
											XNameAccess			,
											XElementAccess
										)

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE	(	FrameLoaderFactory						,
                                            OWeakObject                             ,
                                            SERVICENAME_FRAMELOADERFACTORY          ,
											IMPLEMENTATIONNAME_FRAMELOADERFACTORY
										)

DEFINE_INIT_SERVICE                     (   FrameLoaderFactory,
                                            {
                                            }
                                        )

//*****************************************************************************************************************
//	XMultiServiceFactory
//*****************************************************************************************************************
Reference< XInterface > SAL_CALL FrameLoaderFactory::createInstance( const OUString& sTypeName ) throw(	Exception		,
							  														 	  				RuntimeException)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Safe impossible cases
	// Method not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_createInstance( sTypeName ), "FrameLoaderFactory::createInstance()\nInvalid parameter detected!\n" )

	// Set default return value if search for registered one failed.
	Reference< XInterface > xLoader;

	// Search registeres loader for these type.
	// Without arguments we search straight forward from begin to end in cache!
	CheckedStringListIterator	pIterator	;
	OUString					sLoaderName	;
	while	(
				( m_aCache.searchLoaderForType( sTypeName, pIterator, sLoaderName )	==	sal_True	)	&&
				( xLoader.is()														==	sal_False	)
			)
	{
		// Try to create found loader.
		xLoader = Reference< XInterface >( m_xFactory->createInstance( sLoaderName ), UNO_QUERY );
		// Warn programmer for invalid registered loader.
		LOG_ASSERT( !(xLoader.is()==sal_False), "FrameLoaderFactory::createInstance()\nI found a registered loader for your given type name .. but couldn't create it!\n" )
		// If it was ok - set his own configuration on loader!
		if( xLoader.is() == sal_True )
		{
			impl_initializeLoader( xLoader, m_aCache.getLoader( sLoaderName ) );
		}
	}

	// Return result of operation.
	return xLoader;
}

//*****************************************************************************************************************
//	XMultiServiceFactory
//*****************************************************************************************************************
Reference< XInterface > SAL_CALL FrameLoaderFactory::createInstanceWithArguments(	const	OUString&			sTypeName	,
																					const	Sequence< Any >&	seqArguments) throw(	Exception		,
																																		RuntimeException)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Safe impossible cases
	// Method not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_createInstanceWithArguments( sTypeName, seqArguments ), "FrameLoaderFactory::createInstanceWidthArguments()\nInvalid parameter detected!\n" )

	// Set default return value if search for registered one failed.
	Reference< XInterface > xLoader;

	// Search registeres loader for these type.

	/*TODO: There exist no defined arguments yet for loader search!
			Ignore it ...
	 */

	xLoader = createInstance( sTypeName );

	// Return result of operation.
	return xLoader;
}

//*****************************************************************************************************************
//	XMultiServiceFactory
//*****************************************************************************************************************
Sequence< OUString > SAL_CALL FrameLoaderFactory::getAvailableServiceNames() throw( RuntimeException )
{
	LOG_ASSERT( sal_False, "FrameLoaderFactory::getAvailableServiceNames()\nNot supported! Please use XNameAcces instead of these!\n" )
	return Sequence< OUString >();
}

//*****************************************************************************************************************
//	XNameAccess
//*****************************************************************************************************************
Any SAL_CALL FrameLoaderFactory::getByName( const OUString& sName ) throw(	NoSuchElementException	,
																			WrappedTargetException	,
																			RuntimeException		)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Set default return value if search failed.
	Any aAny;

	if( m_aCache.existsLoader( sName ) == sal_False )
	{
		throw NoSuchElementException( DECLARE_ASCII("FrameLoaderFactory::getByName()\nSpecified frame loader not exist!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Try to get all informations about these loader from configuration.
	aAny <<= m_aCache.getLoaderProperties( sName );

	// Return result of operation.
	return aAny;
}

//*****************************************************************************************************************
//	XNameAccess
//*****************************************************************************************************************
Sequence< OUString > SAL_CALL FrameLoaderFactory::getElementNames() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return m_aCache.getAllLoaderNames();
}

//*****************************************************************************************************************
//	XNameAccess
//*****************************************************************************************************************
sal_Bool SAL_CALL FrameLoaderFactory::hasByName( const OUString& sName ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return m_aCache.existsLoader( sName );
}

//*****************************************************************************************************************
//	XElementAccess
//*****************************************************************************************************************
Type SAL_CALL FrameLoaderFactory::getElementType() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return( ::getCppuType( (const Sequence< PropertyValue >*)NULL ) );
}

//*****************************************************************************************************************
//	XElementAccess
//*****************************************************************************************************************
sal_Bool SAL_CALL FrameLoaderFactory::hasElements() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return m_aCache.hasLoaders();
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void FrameLoaderFactory::impl_initializeLoader( Reference< XInterface >& xLoader, const Loader& aLoaderInfo )
{
	// Support given loader the new property mechanism?
	Reference< XSynchronousFrameLoader > xSyncLoader( xLoader, UNO_QUERY );
	// For follow check it's neccessary to cast xSyncLoader instead of xLoader here.
	// The new mechanism must support both interfaces!
	// But another normal frame loader CAN support XInitialization without XSynchronous... -
	// in that case we can't shure if that means the same ...!
	Reference< XInitialization > xInit( xSyncLoader, UNO_QUERY );

	if( xInit.is() == sal_True )
	{
		// Yes these loader support the new mechanism.
		// Try to set configuration values on it.
		Sequence< Any > lProperties( 1 );
		lProperties[0] <<= m_aCache.getLoaderProperties( aLoaderInfo.sName );
		xInit->initialize( lProperties );
	}
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool FrameLoaderFactory::impldbg_checkParameter_FrameLoaderFactory( const Reference< XMultiServiceFactory >& xFactory )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xFactory		==	NULL		)	||
			( xFactory.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool FrameLoaderFactory::impldbg_checkParameter_createInstance( const OUString& sTypeName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sTypeName			==	NULL	)	||
			( sTypeName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool FrameLoaderFactory::impldbg_checkParameter_createInstanceWithArguments	(	const	OUString&			sTypeName	,
																					const	Sequence< Any >&	seqArguments)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sTypeName			==	NULL	)	||
			( sTypeName.getLength()	<	1		)	||
			( &seqArguments			==	NULL	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool FrameLoaderFactory::impldbg_checkParameter_getByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool FrameLoaderFactory::impldbg_checkParameter_hasByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
