/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccLegendEntry.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:59:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccLegendEntry.hxx"

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif

// for SolarMutex
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SVDITER_HXX
#include <svx/svditer.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif

using ::rtl::OUString;
using namespace ::com::sun::star::accessibility;

namespace accessibility
{

LegendEntry::LegendEntry( AccessibleBase * pParent, sal_uInt16 nIndex ) :
        AccessibleChartElement( AccessibleUniqueId( ObjectId, nIndex ),
                                pParent,
                                false /* has no children */ ),
    m_nIndex( nIndex )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->IsPieChart()
                ? pModel->GetFullDataPointAttr( nIndex, 0 )
                : pModel->GetDataRowAttr( nIndex ) );
    // \-- solar
}

LegendEntry::~LegendEntry()
{}

// bool LegendEntry::NotifyHint( const SfxHint & rHint, sal_uInt16 nObjId ) const
// {
//     if( ( nObjId == CHOBJID_LEGEND_SYMBOL_COL ||
//           nObjId == CHOBJID_LEGEND_SYMBOL_ROW )
//         && rHint.ISA( SdrHint ) )
//     {
//         const SdrHint & rSdrHint = static_cast< const SdrHint & >( rHint );
//         if( rSdrHint.GetKind() == HINT_OBJCHG )
//         {
//             // /--
//             ::osl::ClearableMutexGuard aGuard( GetMutex());
//             sal_uInt16 nIndex = m_nIndex;
//             ChartModel * pModel = GetChartModel();
//             aGuard.clear();
//             // \--

//             bool bFound = false;

//             {
//                 // /-- solar
//                 ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
//                 bool bIsPieChart = (true && pModel->IsPieChart());
//                 const SdrObject * pObj = rSdrHint.GetObject();

//                 if( bIsPieChart )
//                 {
//                     SchDataPoint *pDataPoint = GetDataPoint( *pObj );
//                     if( pDataPoint &&
//                         pDataPoint->GetCol() == nIndex )
//                     {
//                         OSL_ASSERT( pDataPoint->GetRow() == 0 );
//                         bFound = true;
//                     }
//                 }
//                 else
//                 {
//                     SchDataRow *pDataRow = GetDataRow( *pObj );
//                     if( pDataRow &&
//                         pDataRow->GetRow() == nIndex )
//                     {
//                         bFound = true;
//                     }
//                 }
//                 // \-- solar
//             }

//             if( bFound )
//             {
//                 ::com::sun::star::uno::Any aEmpty;
//                 BroadcastAccEvent( AccessibleEventId::ACCESSIBLE_VISIBLE_DATA_EVENT, aEmpty, aEmpty );
// #if OSL_DEBUG_LEVEL > 1
//                 OSL_TRACE(
//                     ::rtl::OUStringToOString(
//                         OUString( RTL_CONSTASCII_USTRINGPARAM(
//                                       "Visible data event sent by: " )) +
//                         const_cast< LegendEntry * >( this )->getAccessibleName(),
//                         RTL_TEXTENCODING_ASCII_US ).getStr() );
// #endif
//                 return true;
//             }
//         }
//     }

//     return AccessibleBase::NotifyHint( rHint, nObjId );
// }

OUString SAL_CALL LegendEntry::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return ( OUString( RTL_CONSTASCII_USTRINGPARAM( "LegendEntry " ) ) +
             OUString::valueOf( static_cast< sal_Int32 >( m_nIndex + 1 )) );
}

OUString SAL_CALL LegendEntry::getToolTipText()
    throw (::com::sun::star::uno::RuntimeException)
{
    CheckDisposeState();

    ChartModel* pModel = NULL;
    SchWindow * pWin   = NULL;
    sal_uInt16 nIndex = 0;

    {
        ::osl::MutexGuard aGuard( GetMutex());

        pModel = GetChartModel();
        pWin = GetWindow();
        nIndex = m_nIndex;
    }

    if( pModel != NULL &&
        pWin != NULL )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        if( pModel->IsPieChart())
            return OUString( pWin->GetQuickHelpText( CHOBJID_DIAGRAM_DATA, pModel, TRUE, 0, nIndex ));
        else
            return OUString( pWin->GetQuickHelpText( CHOBJID_DIAGRAM_ROWGROUP, pModel, TRUE, nIndex ));
        // \-- solar
    }
    else
        return OUString();
}

bool LegendEntry::UpdateChildren()
{
    // nothing for now
    return true;
}

SdrObject * LegendEntry::GetDrawObject() const
{

    SdrObject * pShape = NULL;
    SdrObject * pResult = NULL;
    bool bIsPieChart = false;
    ChartModel * pModel = GetChartModel();

    // /--
    ::osl::ClearableMutexGuard aGuard( GetMutex());
    sal_uInt16 nIndex = m_nIndex;
    aGuard.clear();
    // \--

    if( pModel )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        bIsPieChart = (true && pModel->IsPieChart());

        pShape = GetObjWithId( CHOBJID_LEGEND, *(pModel->GetPage( 0 )));
        OSL_ASSERT( pShape );
        OSL_ASSERT( pShape->IsGroupObject() );

        SdrObjListIter aIterator( *(pShape->GetSubList()), IM_FLAT );
        while( aIterator.IsMore())
        {
            pShape = aIterator.Next();
            if( bIsPieChart )
            {
                if( GetObjectIdNum( *pShape ) == CHOBJID_LEGEND_SYMBOL_COL )
                {
                    SchDataPoint *pDataPoint = GetDataPoint( *pShape );
                    if( pDataPoint &&
                        pDataPoint->GetCol() == nIndex )
                    {
                        OSL_ASSERT( pDataPoint->GetRow() == 0 );
                        pResult = pShape;
                        break;
                    }
                }
            }
            else
            {
                if( GetObjectIdNum( *pShape ) == CHOBJID_LEGEND_SYMBOL_ROW )
                {
                    SchDataRow *pDataRow = GetDataRow( *pShape );
                    if( pDataRow &&
                        pDataRow->GetRow() == nIndex )
                    {
                        pResult = pShape;
                        break;
                    }
                }
            }
        }
        // \-- solar
    }

    return pResult;
}

OUString SAL_CALL LegendEntry::getImplementationName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccLegendEntry" ));
}

}  // namespace accessibility
