/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccStatisticsObject.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:59:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccStatisticsObject.hxx"

#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif
#ifndef _SVDITER_HXX
#include <svx/svditer.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif

using ::rtl::OUString;

namespace accessibility
{

StatisticsObject::StatisticsObject( AccessibleBase * pParent,
                                    StatisticsObjectType eType,
                                    sal_uInt16 nSeriesIndex ) :

        AccessibleChartElement(
            AccessibleUniqueId( static_cast< sal_uInt16 >( eType ), nSeriesIndex ),
            pParent,
            false, /* has no children */
            true ),

        m_eType( eType ),
        m_nSeriesIndex( nSeriesIndex )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    switch( eType )
    {
        case MEAN_VAL_LINE:
            SetItemSet( pModel->GetAverageAttr( m_nSeriesIndex ));
            break;
        case ERROR_BARS:
            SetItemSet( pModel->GetErrorAttr( m_nSeriesIndex ));
            break;
        case REGRESSION:
            SetItemSet( pModel->GetRegressAttr( m_nSeriesIndex ));
            break;
    }
    // \-- solar
}

StatisticsObject::~StatisticsObject()
{
}

OUString SAL_CALL StatisticsObject::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return getToolTipText();
}

SdrObject * StatisticsObject::GetDrawObject() const
{
    SdrObject * pShape = NULL;
    SdrObject * pResult = NULL;

    ChartModel * pModel = GetChartModel();
    if( pModel != NULL )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex());
        const SdrObjList & rObjList = *(pModel->GetPage( 0 ));

        // first search the diagram
        SdrObjListIter aIterator( rObjList, IM_FLAT );
        while( aIterator.IsMore())
        {
            pShape = aIterator.Next();
            if( pShape->IsGroupObject())
            {
                if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM )
                {
                    // search in diagram
                    SdrObjListIter aIter2( *(pShape->GetSubList()), IM_FLAT );
                    while( aIter2.IsMore())
                    {
                        if( m_eType == REGRESSION ||
                            m_eType == MEAN_VAL_LINE )
                        {
                            pShape = aIter2.Next();
                            UINT16 nCompareId = ( m_eType == REGRESSION
                                ? CHOBJID_DIAGRAM_REGRESSION
                                : CHOBJID_DIAGRAM_AVERAGEVALUE );
                            if( GetObjectIdNum( *pShape ) == nCompareId )
                            {
                                SchDataRow * pDataRow = GetDataRow( *pShape );
                                if( pDataRow &&
                                    pDataRow->GetRow() == m_nSeriesIndex )
                                {
                                    pResult = pShape;
                                    break;
                                }
                            }
                        }
                        else
                        {
                            pShape = aIter2.Next();
                            if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM_STATISTICS_GROUP )
                            {
                                SchDataRow * pDataRow = GetDataRow( *pShape );
                                if( pDataRow &&
                                    pDataRow->GetRow() == m_nSeriesIndex )
                                {
                                    // the error bars consist of three lines per
                                    // data point all these objects have the
                                    // CHOBJID_DIAGRAM_ERROR and are not grouped,
                                    // therefore we return the entire group here
                                    if( m_eType == ERROR_BARS )
                                    {
                                        pResult = pShape;
                                        break;
                                    }
                                    else
                                    {
                                        // search in the group that contains all statistics objects
                                        SdrObjListIter aIter3( *(pShape->GetSubList()), IM_FLAT );
                                        while( aIter3.IsMore())
                                        {
                                            pShape = aIter3.Next();
                                            if( GetObjectIdNum( *pShape ) == static_cast< sal_uInt16 >( m_eType ))
                                            {
                                                pResult = pShape;
                                            break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        // \-- solar
    }
    return pResult;
}

OUString SAL_CALL StatisticsObject::getImplementationName() 
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccStatisticsObject" ));
}

}  // namespace accessibility
