/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undmovpieseg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:18:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

//svdraw.hxx
//#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV



#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#include "schdll.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "undmovpieseg.hxx"
#include "schresid.hxx"
#include "strings.hrc"

TYPEINIT1(SchUndoMovePieSeg, SchUndoAction);

//*************************************************************************
//*************************************************************************

SchUndoMovePieSeg::SchUndoMovePieSeg(ChartModel& rChDoc
		, long nColumn, long nOldOff, long nNewOff )
		: SchUndoAction(rChDoc), m_nCol(nColumn)
		, m_nOldOff(nOldOff)
		, m_nNewOff(nNewOff)
{
	SetComment(String(SchResId(STR_UNDO_DATA_POINT)));
}

//*************************************************************************
//*************************************************************************

void SchUndoMovePieSeg::Undo()
{
	DoMove(m_nOldOff);
}

//*************************************************************************
//*************************************************************************

void SchUndoMovePieSeg::Redo()
{
	DoMove(m_nNewOff);
}

//************************************************************************/
//************************************************************************/

BOOL SchUndoMovePieSeg::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}

//************************************************************************/
//************************************************************************/

void SchUndoMovePieSeg::DoMove(long nOff)
{
	rDoc.SetUseRelativePositions(TRUE);
	rDoc.SetPieSegOfs( m_nCol, nOff );
	rDoc.BuildChart(FALSE);
}

