/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wmf.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 15:43:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"

#include "winmtf.hxx"
#include "emfwr.hxx"
#include "wmfwr.hxx"
#include "wmf.hxx"

// -----------------------------------------------------------------------------

BOOL ConvertWMFToGDIMetaFile( SvStream & rStreamWMF, GDIMetaFile & rGDIMetaFile, FilterConfigItem* pConfigItem )
{
	UINT32 nMetaType;
	UINT32 nOrgPos = rStreamWMF.Tell();
	UINT16 nOrigNumberFormat = rStreamWMF.GetNumberFormatInt();
	rStreamWMF.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
	rStreamWMF.Seek( 0x28 );
	rStreamWMF >> nMetaType;
	rStreamWMF.Seek( nOrgPos );
	if ( nMetaType == 0x464d4520 )
	{
		if ( EnhWMFReader( rStreamWMF, rGDIMetaFile, pConfigItem ).ReadEnhWMF() == FALSE )
			rStreamWMF.SetError( SVSTREAM_FILEFORMAT_ERROR );
	}
	else
	{
		WMFReader( rStreamWMF, rGDIMetaFile, pConfigItem ).ReadWMF();
	}
	rStreamWMF.SetNumberFormatInt( nOrigNumberFormat );
	return !rStreamWMF.GetError();
}

// -----------------------------------------------------------------------------

BOOL ReadWindowMetafile( SvStream& rStream, GDIMetaFile& rMTF, FilterConfigItem* pFilterConfigItem )
{
	UINT32 nMetaType;
	UINT32 nOrgPos = rStream.Tell();
	UINT16 nOrigNumberFormat = rStream.GetNumberFormatInt();
	rStream.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
	rStream.Seek( 0x28 );
	rStream >> nMetaType;
	rStream.Seek( nOrgPos );
	if ( nMetaType == 0x464d4520 )
	{
		if ( EnhWMFReader( rStream, rMTF, NULL ).ReadEnhWMF() == FALSE )
			rStream.SetError( SVSTREAM_FILEFORMAT_ERROR );
	}
	else
	{
		WMFReader( rStream, rMTF, pFilterConfigItem ).ReadWMF();
	}
	rStream.SetNumberFormatInt( nOrigNumberFormat );
	return !rStream.GetError();
}

// -----------------------------------------------------------------------------

BOOL ConvertGDIMetaFileToWMF( const GDIMetaFile & rMTF, SvStream & rTargetStream,
							  FilterConfigItem* pConfigItem, BOOL bPlaceable)
{
	WMFWriter aWMFWriter;
	return aWMFWriter.WriteWMF( rMTF, rTargetStream, pConfigItem, bPlaceable );
}

// -----------------------------------------------------------------------------

BOOL ConvertGDIMetaFileToEMF( const GDIMetaFile & rMTF, SvStream & rTargetStream,
							  FilterConfigItem* pConfigItem )
{
	EMFWriter aEMFWriter;
	return aEMFWriter.WriteEMF( rMTF, rTargetStream, pConfigItem );
}

// -----------------------------------------------------------------------------

BOOL WriteWindowMetafile( SvStream& rStream, const GDIMetaFile& rMTF )
{
	return WMFWriter().WriteWMF( rMTF, rStream, NULL );
}

// -----------------------------------------------------------------------------

BOOL WriteWindowMetafileBits( SvStream& rStream, const GDIMetaFile& rMTF )
{
	return WMFWriter().WriteWMF( rMTF, rStream, NULL, FALSE );
}
