/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BlockManagerBase.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:06:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _XMLSEARCH_DB_BLOCKMANAGERBASE_HXX_
#define _XMLSEARCH_DB_BLOCKMANAGERBASE_HXX_


#ifndef _RTL_USTRING_
#include  <rtl/ustring>
#endif
#ifndef _XMLSEARCH_EXCEP_XMLSEARCHEXCEPTIONS_HXX_
#include <excep/XmlSearchExceptions.hxx>
#endif
#ifndef _XMLSEARCH_DB_BLOCK_HXX_
#include <db/Block.hxx>
#endif


namespace xmlsearch {
	
	namespace db {
		
		
		class BlockManagerBase     // Interface
		{
		public:
			
			virtual void lock( sal_Int32   blNum ) throw( xmlsearch::excep::IllegalIndexException ) = 0;
			virtual void unlock( sal_Int32 blNum ) throw( xmlsearch::excep::IllegalIndexException ) = 0;
			virtual bool isLocked( sal_Int32 blNum ) throw( xmlsearch::excep::IllegalIndexException ) = 0;
      
			virtual void modf( sal_Int32 blNum ) throw( xmlsearch::excep::IllegalIndexException ) = 0;
			virtual void close( bool update ) throw( xmlsearch::excep::IOException ) = 0;
      
			virtual Block* accessBlock( sal_Int32 blNum ) throw( xmlsearch::excep::NoSuchBlock ) = 0;
			virtual Block* newBlock() throw( xmlsearch::excep::XmlSearchException ) = 0;
			virtual void writeBlock( Block* bl ) throw( xmlsearch::excep::IOException ) = 0;
		};
		
		
	}
}


#endif
