/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: heap.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 15:09:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_configmgr.hxx"

#include "heap.hxx"

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

// -----------------------------------------------------------------------------	

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------
        const Heap::Size c_nDefaultSize = 4096;
    // -------------------------------------------------------------------------
        Heap::Heap(HeapManager& _impl)
        : m_impl(_impl)
        , m_heap(_impl.createHeap(c_nDefaultSize))
        , m_size(c_nDefaultSize)
        {
        }
    // -------------------------------------------------------------------------

        Heap::Heap(HeapManager& _impl, Size _nInitialSize)
        : m_impl(_impl)
        , m_heap(_impl.createHeap(_nInitialSize))
        , m_size(_nInitialSize)
        {
        }
    // -------------------------------------------------------------------------

        Heap::Heap(HeapManager& _impl, HeapId const & _anId)
        : m_impl(_impl)
        , m_size(0)
        {
            m_heap = _impl.attachHeap(_anId,m_size);
        }
    // -------------------------------------------------------------------------

        Heap::~Heap()
        {
            m_impl.destroyHeap(m_heap);
        }
    // -------------------------------------------------------------------------

        Heap::Size Heap::grow(Size _nReqSize) // returns the (possibly new) base
        {
            Size nNewSize = m_impl.growHeap(m_heap, _nReqSize);

            if (nNewSize)
            {
                OSL_ENSURE(nNewSize >= _nReqSize, "Error: Heapmanager returns invalid size from grow method");
                m_size = nNewSize;
            }

            return nNewSize;
        }
    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr


