// autogenerated file with codegen.pl

#include <cppunit/simpleheader.hxx>

#include "o3tl/lazy_update.hxx"
#include "cow_wrapper_clients.hxx"
#include <math.h>

using namespace ::o3tl;


namespace o3tltests
{

class cow_wrapper_test : public CppUnit::TestFixture
{
public:
    template< class T > void test( T& rTestObj1, T& rTestObj2, T& rTestObj3 )
    {
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 is unique", 
                               rTestObj1.is_unique() );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2 is unique", 
                               rTestObj2.is_unique() );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3 is unique", 
                               rTestObj3.is_unique() );

        CPPUNIT_ASSERT_MESSAGE("rTestObj1 != rTestObj2", 
                               rTestObj1 != rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2 != rTestObj3", 
                               rTestObj2 != rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 != rTestObj3", 
                               rTestObj1 != rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 < rTestObj2", 
                               rTestObj1 < rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2 < rTestObj3", 
                               rTestObj2 < rTestObj3 );

        rTestObj2 = rTestObj1;
        rTestObj3 = rTestObj1;
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj2", 
                               rTestObj1 == rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj3", 
                               rTestObj1 == rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1.use_count() == 3", 
                               rTestObj1.use_count() == 3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.use_count() == 3", 
                               rTestObj2.use_count() == 3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.use_count() == 3", 
                               rTestObj3.use_count() == 3 );
        
        rTestObj2.makeUnique();
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj2", 
                               rTestObj1 == rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj3", 
                               rTestObj1 == rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1.use_count() == 2", 
                               rTestObj1.use_count() == 2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.use_count() == 1", 
                               rTestObj2.use_count() == 1 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.is_unique()", 
                               rTestObj2.is_unique() );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.use_count() == 2", 
                               rTestObj3.use_count() == 2 );

        rTestObj2.swap( rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj2", 
                               rTestObj1 == rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj3", 
                               rTestObj1 == rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1.use_count() == 2", 
                               rTestObj1.use_count() == 2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.use_count() == 2", 
                               rTestObj2.use_count() == 2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.use_count() == 1", 
                               rTestObj3.use_count() == 1 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.is_unique()", 
                               rTestObj3.is_unique() );
    }

    void testCowWrapper()
    {
        // setup
        cow_wrapper_client1 aTestObj1;
        cow_wrapper_client1 aTestObj2;
        cow_wrapper_client1 aTestObj3;
        
        cow_wrapper_client2 aTestObj4;
        cow_wrapper_client2 aTestObj5;
        cow_wrapper_client2 aTestObj6;

        cow_wrapper_client3 aTestObj7;
        cow_wrapper_client3 aTestObj8;
        cow_wrapper_client3 aTestObj9;

        {
            aTestObj1 = cow_wrapper_client1( 1 );
            aTestObj2.modify( 2 );
            aTestObj3.modify( 3 );
            
            aTestObj4 = cow_wrapper_client2( 4 );
            aTestObj5.modify( 5 );
            aTestObj6.modify( 6 );

            aTestObj7 = cow_wrapper_client3( 7 );
            aTestObj8.modify( 8 );
            aTestObj9.modify( 9 );
        }
        // all three temporaries are dead now

        // test
        test( aTestObj1, aTestObj2, aTestObj3 );
        test( aTestObj4, aTestObj5, aTestObj6 );
        test( aTestObj7, aTestObj8, aTestObj9 );
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(cow_wrapper_test);
    CPPUNIT_TEST(testCowWrapper);
    CPPUNIT_TEST_SUITE_END();
};

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(o3tltests::cow_wrapper_test, "cow_wrapper_test");

// -----------------------------------------------------------------------------

static int nInitialized = 0;

struct LazyTest
{
    LazyTest() :
        m_aStr()
    {}

    explicit LazyTest( double nVal ) :
        m_aStr( ::rtl::OUString::valueOf( nVal ) )
    {
        ++nInitialized;
    }

    ::rtl::OUString m_aStr;
};

double calcRoot( int const& val ) { return sqrt(double(val)); }

class lazy_update_test : public CppUnit::TestFixture
{
public:
    void testLazyUpdate()
    {
        typedef LazyUpdate<int, double, o3tl::LAZYUPDATE_DIRECT_TAG> BasicTest;

        BasicTest aTest1;
        BasicTest aTest2(10);

        CPPUNIT_ASSERT_MESSAGE("aTest1 is zero", 
                               *aTest1 == 0.0 );
        CPPUNIT_ASSERT_MESSAGE("aTest2 is 10", 
                               *aTest2 == 10.0 );

        *aTest1 = 20;
        *aTest2 = 30;

        CPPUNIT_ASSERT_MESSAGE("aTest1 is 20", 
                               aTest1.getOutValue() == 20.0 );
        CPPUNIT_ASSERT_MESSAGE("aTest2 is 30", 
                               *aTest2 == 30.0 );

        ///////////////////////////////////////////////////////////////////////////

        typedef LazyUpdate<int, LazyTest, o3tl::LAZYUPDATE_DIRECT_TAG> ComplexTest;

        ComplexTest aTest3;
        ComplexTest aTest4(42);

        CPPUNIT_ASSERT_MESSAGE("aTest3 is uninitialized", 
                               nInitialized == 0 );
        CPPUNIT_ASSERT_MESSAGE("aTest3 is '0.0'", 
                               aTest3.getOutValue().m_aStr.compareToAscii("0.0") );
        CPPUNIT_ASSERT_MESSAGE("aTest4 is '42.0'", 
                               aTest4.getOutValue().m_aStr.compareToAscii("42.0") );

        aTest3.setInValue(20);
        aTest4.setInValue(30);

        CPPUNIT_ASSERT_MESSAGE("aTest3 is initialized once", 
                               nInitialized == 2 );

        CPPUNIT_ASSERT_MESSAGE("aTest3 is '0.0'", 
                               aTest3.getOutValue().m_aStr.compareToAscii("0.0") );
        CPPUNIT_ASSERT_MESSAGE("aTest4 is '42.0'", 
                               aTest4.getOutValue().m_aStr.compareToAscii("42.0") );

        CPPUNIT_ASSERT_MESSAGE("aTest3 is initialized twice", 
                               nInitialized == 4 );

        ///////////////////////////////////////////////////////////////////////////

        typedef LazyUpdate<int, double, o3tl::LAZYUPDATE_FUNCTION_TAG> FunctionTest;

        FunctionTest aTest5( &calcRoot );
        FunctionTest aTest6( &calcRoot, 16 );

        CPPUNIT_ASSERT_MESSAGE("aTest5 is '0.0'", 
                               *aTest5 == 0.0);
        CPPUNIT_ASSERT_MESSAGE("aTest6 is '4.0'", 
                               fabs(aTest6.getOutValue()-4.0) < 0.0001);

        *aTest5 = 81;
        *aTest6 = 144;

        CPPUNIT_ASSERT_MESSAGE("aTest5 is '9.0'", 
                               fabs(aTest5.getOutValue()-9.0) < 0.0001);
        CPPUNIT_ASSERT_MESSAGE("aTest6 is '12.0'", 
                               fabs(aTest6.getOutValue()-12.0) < 0.0001);

        ///////////////////////////////////////////////////////////////////////////

        typedef LazyUpdate<int, double, o3tl::LAZYUPDATE_FUNCTOR_TAG> FunctorTest;

        boost::function1<double,int> aFunc(&calcRoot);
        FunctorTest aTest7( aFunc );
        FunctorTest aTest8( aFunc, 16 );

        CPPUNIT_ASSERT_MESSAGE("aTest7 is '0.0'", 
                               *aTest7 == 0.0);
        CPPUNIT_ASSERT_MESSAGE("aTest8 is '4.0'", 
                               fabs(aTest8.getOutValue()-4.0) < 0.0001);

        aTest7.setInValue(81);
        *aTest8 = 144;

        CPPUNIT_ASSERT_MESSAGE("aTest7 is '9.0'", 
                               fabs(aTest7.getOutValue()-9.0) < 0.0001);
        CPPUNIT_ASSERT_MESSAGE("aTest8 is '12.0'", 
                               fabs(aTest8.getOutValue()-12.0) < 0.0001);
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(lazy_update_test);
    CPPUNIT_TEST(testLazyUpdate);
    CPPUNIT_TEST_SUITE_END();
};

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(o3tltests::lazy_update_test, "lazy_update_test");

} // namespace o3tltests


// -----------------------------------------------------------------------------

// this macro creates an empty function, which will called by the RegisterAllFunctions()
// to let the user the possibility to also register some functions by hand.
void RegisterAdditionalFunctions(FktRegFuncPtr )
{
}
// NOADDITIONAL;

