/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: boolean.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:35:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/boolean.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tplutiln.hxx>


namespace udm
{

Data::accessor_type
Boolean::inq_Type() const
{
 	return t_Bool;
}

Data::description
Boolean::inq_TypeDescription() const
{
 	return Data::description("b");
}

Boolean &
Boolean::access_Bool()
{
 	return *this;
}





//*********************       Boolean_Null      *******************//

class Boolean_Null : public Boolean
{
  public:
    virtual             ~Boolean_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    // Interface Boolean:
    virtual value_type  inq_Value() const;
};

Boolean_Null::~Boolean_Null()
{
}

void                Boolean_Null::do_Dispose() { }
void                Boolean_Null::do_BinWrite( csv::bostream & ) const    {}


Boolean::value_type
Boolean_Null::inq_Value() const
{
 	return false;
}


template <>
Boolean &
get_null<Boolean>( csv::Type2Type<Boolean> )
{
    static Boolean * pNull_ = new Boolean_Null;
    return *pNull_;
}


}   // namespace udm

namespace
{
//  compile-time check of sizeof(bool) == 1:
char aCheck[ csv::TypeSizeCheck<bool,1>::result ];
}

