/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.ISCII91;

public class ByteToCharISCII91
extends ByteToCharConverter {
    private static final char[] directMapTable = ISCII91.getDirectMapTable();
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';
    private static final char ZWNJ_CHAR = '\u200c';
    private static final char ZWJ_CHAR = '\u200d';
    private static final char INVALID_CHAR = '\uffff';
    private char contextChar = (char)65535;
    private boolean needFlushing = false;

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = n3;
        this.byteOff = n;
        block17: while (this.byteOff < n2) {
            int n5;
            if (this.charOff >= n4) {
                throw new ConversionBufferFullException();
            }
            n5 = (n5 = byArray[this.byteOff++]) < 0 ? n5 + 255 : n5;
            char c = directMapTable[n5];
            if (this.contextChar == '\ufffd') {
                cArray[this.charOff++] = 65533;
                this.contextChar = (char)65535;
                this.needFlushing = false;
                continue;
            }
            block0 : switch (c) {
                case '\u0901': 
                case '\u0907': 
                case '\u0908': 
                case '\u090b': 
                case '\u093f': 
                case '\u0940': 
                case '\u0943': 
                case '\u0964': {
                    if (this.needFlushing) {
                        cArray[this.charOff++] = this.contextChar;
                        this.contextChar = c;
                        continue block17;
                    }
                    this.contextChar = c;
                    this.needFlushing = true;
                    continue block17;
                }
                case '\u093c': {
                    switch (this.contextChar) {
                        case '\u0901': {
                            cArray[this.charOff] = 2384;
                            break block0;
                        }
                        case '\u0907': {
                            cArray[this.charOff] = 2316;
                            break block0;
                        }
                        case '\u0908': {
                            cArray[this.charOff] = 2401;
                            break block0;
                        }
                        case '\u090b': {
                            cArray[this.charOff] = 2400;
                            break block0;
                        }
                        case '\u093f': {
                            cArray[this.charOff] = 2402;
                            break block0;
                        }
                        case '\u0940': {
                            cArray[this.charOff] = 2403;
                            break block0;
                        }
                        case '\u0943': {
                            cArray[this.charOff] = 2372;
                            break block0;
                        }
                        case '\u0964': {
                            cArray[this.charOff] = 2365;
                            break block0;
                        }
                        case '\u094d': {
                            if (this.needFlushing) {
                                cArray[this.charOff++] = this.contextChar;
                                this.contextChar = c;
                                continue block17;
                            }
                            cArray[this.charOff] = 8205;
                            break block0;
                        }
                    }
                    if (this.needFlushing) {
                        cArray[this.charOff++] = this.contextChar;
                        this.contextChar = c;
                        continue block17;
                    }
                    cArray[this.charOff] = 2364;
                    break;
                }
                case '\u094d': {
                    if (this.needFlushing) {
                        cArray[this.charOff++] = this.contextChar;
                        this.contextChar = c;
                        continue block17;
                    }
                    if (this.contextChar == '\u094d') {
                        cArray[this.charOff] = 8204;
                        break;
                    }
                    cArray[this.charOff] = 2381;
                    break;
                }
                case '\uffff': {
                    if (this.needFlushing) {
                        cArray[this.charOff++] = this.contextChar;
                        this.contextChar = c;
                        continue block17;
                    }
                    if (this.subMode) {
                        cArray[this.charOff] = this.subChars[0];
                        break;
                    }
                    this.contextChar = (char)65535;
                    throw new UnknownCharacterException();
                }
                default: {
                    if (this.needFlushing) {
                        cArray[this.charOff++] = this.contextChar;
                        this.contextChar = c;
                        continue block17;
                    }
                    cArray[this.charOff] = c;
                }
            }
            this.contextChar = c;
            this.needFlushing = false;
            ++this.charOff;
        }
        return this.charOff - n3;
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        int n3 = 0;
        if (this.needFlushing) {
            cArray[n] = this.contextChar;
            n3 = 1;
        }
        this.contextChar = (char)65535;
        this.needFlushing = false;
        this.charOff = 0;
        this.byteOff = 0;
        return n3;
    }

    public String getCharacterEncoding() {
        return "ISCII91";
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }
}

