/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.geom.AffineTransform;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.BufferedContext;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

class OGLContext
extends BufferedContext {
    static final int NO_CONTEXT_FLAGS = 0;
    static final int SRC_IS_OPAQUE = 1;
    static final int CAPS_EMPTY = 0;
    static final int CAPS_DOUBLEBUFFERED = 1;
    static final int CAPS_STORED_ALPHA = 2;
    static final int CAPS_EXT_MULTITEXTURE = 4;
    static final int CAPS_EXT_TEXNONPOW2 = 8;
    static final int CAPS_EXT_FBOBJECT = 16;
    static final int CAPS_EXT_LCD_SHADER = 32;
    static final int CAPS_EXT_TEXRECT = 64;
    static final int CAPS_EXT_RENDER_TEXRECT = 128;

    OGLContext(RenderQueue renderQueue) {
        super(renderQueue);
    }

    static void validateContext(OGLSurfaceData oGLSurfaceData, OGLSurfaceData oGLSurfaceData2, Region region, Composite composite, AffineTransform affineTransform, int n, int n2) {
        OGLContext oGLContext = oGLSurfaceData2.getContext();
        oGLContext.validate(oGLSurfaceData, oGLSurfaceData2, region, composite, affineTransform, n, n2);
    }

    static void validateContext(OGLSurfaceData oGLSurfaceData) {
        OGLContext.validateContext(oGLSurfaceData, oGLSurfaceData, null, null, null, 0, 0);
    }

    static void setScratchSurface(OGLGraphicsConfig oGLGraphicsConfig) {
        OGLContext.setScratchSurface(oGLGraphicsConfig.getNativeConfigInfo());
    }

    static void setScratchSurface(long l) {
        currentContext = null;
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        RenderBuffer renderBuffer = oGLRenderQueue.getBuffer();
        oGLRenderQueue.ensureCapacityAndAlignment(12, 4);
        renderBuffer.putInt(71);
        renderBuffer.putLong(l);
    }

    static void invalidateCurrentContext() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.ensureCapacity(4);
        oGLRenderQueue.getBuffer().putInt(75);
        oGLRenderQueue.flushNow();
        if (currentContext != null) {
            currentContext.invalidateSurfaces();
            currentContext = null;
        }
    }

    static int getExtraAlphaPixel(Composite composite) {
        try {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            float f = alphaComposite.getAlpha();
            if (f != 1.0f) {
                int n = (int)(f * 255.0f + 0.5f);
                return n << 24 | n << 16 | n << 8 | n << 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }
}

