/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.xml.internal.ws.api.pipe.Fiber;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Engine {
    private volatile Executor threadPool;
    public final String id;

    public Engine(String string, Executor executor) {
        this(string);
        this.threadPool = executor;
    }

    public Engine(String string) {
        this.id = string;
    }

    public void setExecutor(Executor executor) {
        this.threadPool = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnable(Fiber fiber) {
        if (this.threadPool == null) {
            Engine engine = this;
            synchronized (engine) {
                this.threadPool = Executors.newFixedThreadPool(5, new DaemonThreadFactory());
            }
        }
        this.threadPool.execute(fiber);
    }

    public Fiber createFiber() {
        return new Fiber(this);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "JAXWS-Engine-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(Boolean.TRUE);
            return thread;
        }
    }
}

