/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: OfficeConnection.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:02:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.comp.beans;

import java.awt.Container;
import java.net.MalformedURLException;

import com.sun.star.lang.XComponent;
import com.sun.star.uno.XComponentContext;

/**
 * This abstract class reprecents a connection to the office 
 * application.

    @deprecated
 */
public interface OfficeConnection
	extends XComponent
{
	/**
	 * Sets a connection URL.
	 *
	 * @param url This is UNO URL which describes the type of a connection.
	 */
	void setUnoUrl(String url)
		throws java.net.MalformedURLException;

	/**
	 * Sets an AWT container catory.
	 *
	 * @param containerFactory This is a application provided AWT container 
	 *	factory.
	 */
	void setContainerFactory(ContainerFactory containerFactory);

	/**
	 * Retrives the UNO component context.
	 * Establishes a connection if necessary and initialises the  
	 * UNO service manager if it has not already been initialised.
	 *
	 * @return The office UNO component context.
	 */
	XComponentContext getComponentContext();

	/**
	 * Creates an office window.
	 * The window is either a sub-class of java.awt.Canvas (local) or 
	 * java.awt.Container (RVP). 
	 * 
	 * This method does not add add the office window to its container.
	 *
	 * @param container This is an AWT container.
	 * @return The office window instance.
	 */
	OfficeWindow createOfficeWindow(Container container);
}
