/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: OConnection.hxx,v $
 *
 *  $Revision: 1.22.142.1 $
 *
 *  last change: $Author: kz $ $Date: 2008/01/18 15:09:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_ODBC_OCONNECTION_HXX_
#define _CONNECTIVITY_ODBC_OCONNECTION_HXX_

#ifndef _COM_SUN_STAR_SDBC_SQLWARNING_HPP_
#include <com/sun/star/sdbc/SQLWarning.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _CONNECTIVITY_OFUNCTIONDEFS_HXX_
#include "odbc/OFunctiondefs.hxx"
#endif
#ifndef _CONNECTIVITY_OSUBCOMPONENT_HXX_
#include "OSubComponent.hxx"
#endif
#ifndef _CONNECTIVITY_COMMONTOOLS_HXX_
#include "connectivity/CommonTools.hxx"
#endif
#ifndef CONNECTIVITY_CONNECTION_HXX
#include "TConnection.hxx"
#endif
#ifndef _CONNECTIVITY_OTYPEINFO_HXX_
#include "OTypeInfo.hxx"
#endif
#ifndef _CPPUHELPER_WEAKREF_HXX_
#include <cppuhelper/weakref.hxx>
#endif
#ifndef _CONNECTIVITY_AUTOKEYRETRIEVINGBASE_HXX_
#include "AutoRetrievingBase.hxx"
#endif
#ifndef _OSL_MODULE_H_
#include <osl/module.h>
#endif


#include <map>

namespace connectivity
{
	namespace odbc
	{

		class OStatement_Base;
		class ODBCDriver;
		class ODatabaseMetaData;

		typedef connectivity::OMetaConnection OConnection_BASE;
		typedef ::std::vector< ::connectivity::OTypeInfo>	TTypeInfoVector;

		class OConnection : public OConnection_BASE,
							public connectivity::OSubComponent<OConnection, OConnection_BASE>,
							public OAutoRetrievingBase
		{
			friend class connectivity::OSubComponent<OConnection, OConnection_BASE>;

		protected:
			//====================================================================
			// Data attributes
			//====================================================================
			::std::map< SQLHANDLE,OConnection*>	m_aConnections;	// holds all connectionas which are need for serveral statements
			TTypeInfoVector						m_aTypeInfo;	//	vector containing an entry
														//  for each row returned by
														//  DatabaseMetaData.getTypeInfo.
			

            ::com::sun::star::sdbc::SQLWarning  m_aLastWarning; //      Last SQLWarning generated by
														//  an operation
			::rtl::OUString	m_sUser;		// the user name
			ODBCDriver*		m_pDriver;		//	Pointer to the owning
											//  driver object
							
			SQLHANDLE		m_aConnectionHandle;
			SQLHANDLE		m_pDriverHandleCopy;	// performance reason
			sal_Int32		m_nStatementCount;
			sal_Bool		m_bClosed;
			sal_Bool		m_bUseCatalog;	// should we use the catalog on filebased databases
			sal_Bool		m_bUseOldDateFormat;
			sal_Bool		m_bParameterSubstitution;
			sal_Bool		m_bIgnoreDriverPrivileges;
            sal_Bool        m_bPreventGetVersionColumns;    // #i60273#


			SQLRETURN		OpenConnection(const ::rtl::OUString& aConnectStr,sal_Int32 nTimeOut, sal_Bool bSilent);

            void            buildTypeInfo() throw( ::com::sun::star::sdbc::SQLException);

			virtual OConnection*	cloneConnection(); // creates a new connection
			
		public:
			oslGenericFunction  getOdbcFunction(sal_Int32 _nIndex)  const;
            virtual SQLRETURN       Construct( const ::rtl::OUString& url,const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& info) throw(::com::sun::star::sdbc::SQLException);

			OConnection(const SQLHANDLE _pDriverHandle,ODBCDriver*	_pDriver);
			//	OConnection(const SQLHANDLE _pConnectionHandle);
			virtual ~OConnection();

            void closeAllStatements () throw( ::com::sun::star::sdbc::SQLException);

			// OComponentHelper
			virtual void SAL_CALL disposing(void);
			// XInterface
			virtual void SAL_CALL release() throw();

			// XServiceInfo
			DECLARE_SERVICE_INFO();
			// XConnection
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XStatement > SAL_CALL createStatement(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareStatement( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareCall( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::rtl::OUString SAL_CALL nativeSQL( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setAutoCommit( sal_Bool autoCommit ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL getAutoCommit(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL commit(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL rollback(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL isClosed(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData > SAL_CALL getMetaData(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setReadOnly( sal_Bool readOnly ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL isReadOnly(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setCatalog( const ::rtl::OUString& catalog ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::rtl::OUString SAL_CALL getCatalog(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setTransactionIsolation( sal_Int32 level ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Int32 SAL_CALL getTransactionIsolation(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > SAL_CALL getTypeMap(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setTypeMap( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& typeMap ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			// XCloseable
			virtual void SAL_CALL close(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			// XWarningsSupplier
			virtual ::com::sun::star::uno::Any SAL_CALL getWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL clearWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			//
			SQLHANDLE		getConnection() { return m_aConnectionHandle; }
			
			// should we use the catalog on filebased databases
			inline sal_Bool		isCatalogUsed()						const { return m_bUseCatalog; }
			inline sal_Bool		isParameterSubstitutionEnabled()	const { return m_bParameterSubstitution; }
			inline sal_Bool		isIgnoreDriverPrivilegesEnabled()	const { return m_bIgnoreDriverPrivileges; }
            inline sal_Bool     preventGetVersionColumns()          const { return m_bPreventGetVersionColumns; }
			inline sal_Bool		useOldDateFormat()					const { return m_bUseOldDateFormat; }
			inline SQLHANDLE		getDriverHandle()				const { return m_pDriverHandleCopy;}
			inline ODBCDriver*		getDriver()						const { return m_pDriver;}
			inline ::rtl::OUString getUserName()					const { return m_sUser; }

			SQLHANDLE		createStatementHandle();
			// close and free the handle and set it to SQL_NULLHANDLE
			void			freeStatementHandle(SQLHANDLE& _pHandle);
		};
	}
}
#endif // _CONNECTIVITY_ODBC_OCONNECTION_HXX_

