/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: doc.cxx,v $
 *
 *  $Revision: 1.60 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/27 08:32:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"
#ifndef _DOC_HXX
#include <doc.hxx>
#endif

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#include <tools/shl.hxx>
#include <tools/globname.hxx>

#include <com/sun/star/i18n/WordType.hdl>
#include <com/sun/star/i18n/ForbiddenCharacters.hdl>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/beans/NamedValue.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _SFXITEMITER_HXX
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFXDOCINF_HXX //autogen
#include <sfx2/docinf.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _SVX_KEEPITEM_HXX //autogen
#include <svx/keepitem.hxx>
#endif
#ifndef _SVX_CSCOITEM_HXX //autogen
#include <svx/cscoitem.hxx>
#endif
#ifndef _SVX_BRKITEM_HXX //autogen
#include <svx/brkitem.hxx>
#endif
#ifndef _SVXLINKMGR_HXX
#include <svx/linkmgr.hxx>
#endif
#ifndef _FORBIDDENCHARACTERSTABLE_HXX
#include <svx/forbiddencharacterstable.hxx>
#endif
#ifndef _SVDMODEL_HXX
#include <svx/svdmodel.hxx>
#endif
#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif
#ifndef _SWMODULE_HXX //autogen
#include <swmodule.hxx>
#endif
#ifndef _FMTPDSC_HXX //autogen
#include <fmtpdsc.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FMTRFMRK_HXX //autogen
#include <fmtrfmrk.hxx>
#endif
#ifndef _FMTINFMT_HXX //autogen
#include <fmtinfmt.hxx>
#endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif
#ifndef _TXTFLD_HXX //autogen
#include <txtfld.hxx>
#endif
#ifndef _DBFLD_HXX
#include <dbfld.hxx>
#endif
#ifndef _TXTINET_HXX //autogen
#include <txtinet.hxx>
#endif
#ifndef _TXTRFMRK_HXX //autogen
#include <txtrfmrk.hxx>
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif
#ifndef _LINKENUM_HXX
#include <linkenum.hxx>
#endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
#ifndef _PAGEFRM_HXX
#include <pagefrm.hxx>
#endif
#ifndef _ROOTFRM_HXX
#include <rootfrm.hxx>
#endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx> //DTor
#endif
#ifndef _BREAKIT_HXX
#include <breakit.hxx>
#endif
#ifndef _NDOLE_HXX
#include <ndole.hxx>
#endif
#ifndef _NDGRF_HXX
#include <ndgrf.hxx>
#endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>			// Undo-Attr
#endif
#ifndef _BOOKMRK_HXX
#include <bookmrk.hxx>			// fuer die Bookmarks
#endif
#ifndef _DOCTXM_HXX
#include <doctxm.hxx>			// fuer die Verzeichnisse
#endif
#ifndef _GRFATR_HXX
#include <grfatr.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>			// PoolVorlagen-Id's
#endif
#ifndef _MVSAVE_HXX
#include <mvsave.hxx>			// fuer Server-Funktionalitaet
#endif
#ifndef _WRONG_HXX
#include <wrong.hxx>			// fuer OnlineSpell-Invalidierung
#endif
#ifndef _SCRIPTINFO_HXX
#include <scriptinfo.hxx>
#endif
#ifndef _ACORRECT_HXX
#include <acorrect.hxx>			// Autokorrektur
#endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>	   		// Statusanzeige
#endif
#ifndef _DOCSTAT_HXX
#include <docstat.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
#ifndef _FLDUPDE_HXX
#include <fldupde.hxx>
#endif
#ifndef _SWBASLNK_HXX
#include <swbaslnk.hxx>
#endif
#ifndef _SW_PRINTDATA_HXX
#include <printdata.hxx>
#endif
#ifndef _CMDID_H
#include <cmdid.h>              // fuer den dflt - Printer in SetJob
#endif
#ifndef _STATSTR_HRC
#include <statstr.hrc>      	// StatLine-String
#endif
#include <comcore.hrc>
#include <SwUndoTOXChange.hxx>
#include <SwUndoFmt.hxx>
#include <unocrsr.hxx>
#include <docsh.hxx>
#include <vector>

#include <osl/diagnose.h>
#include <osl/interlck.h>

/* @@@MAINTAINABILITY-HORROR@@@
   Probably unwanted dependency on SwDocShell
*/
// --> OD 2005-08-29 #TESTING#
#ifndef _LAYOUTER_HXX
#include <layouter.hxx>
#endif
// <--

using namespace ::com::sun::star;

// Seiten-Deskriptoren
SV_IMPL_PTRARR(SwPageDescs,SwPageDescPtr);
// Verzeichnisse
SV_IMPL_PTRARR( SwTOXTypes, SwTOXTypePtr )
// FeldTypen
SV_IMPL_PTRARR( SwFldTypes, SwFldTypePtr)

/** IInterface
*/
sal_Int32 SwDoc::acquire()
{
    OSL_ASSERT(mReferenceCount >= 0 && "Negative reference count detected! This is a sign for unbalanced acquire/release calls.");
    return osl_incrementInterlockedCount(&mReferenceCount);
}

sal_Int32 SwDoc::release()
{
    OSL_PRECOND(mReferenceCount >= 1, "Object is already released! Releasing it again leads to a negative reference count.");
    return osl_decrementInterlockedCount(&mReferenceCount);
}

sal_Int32 SwDoc::getReferenceCount() const
{
    OSL_ASSERT(mReferenceCount >= 0 && "Negative reference count detected! This is a sign for unbalanced acquire/release calls.");
    return mReferenceCount;
}

/** IDocumentSettingAccess
*/
bool SwDoc::get(/*[in]*/ DocumentSettingId id) const
{
    switch (id)
    {
        // COMPATIBILITY FLAGS START
        case PARA_SPACE_MAX: return mbParaSpaceMax; //(n8Dummy1 & DUMMY_PARASPACEMAX);
        case PARA_SPACE_MAX_AT_PAGES: return mbParaSpaceMaxAtPages; //(n8Dummy1 & DUMMY_PARASPACEMAX_AT_PAGES);
        case TAB_COMPAT: return mbTabCompat; //(n8Dummy1 & DUMMY_TAB_COMPAT);
        case ADD_FLY_OFFSETS: return mbAddFlyOffsets; //(n8Dummy2 & DUMMY_ADD_FLY_OFFSETS);
        case ADD_EXT_LEADING: return mbAddExternalLeading; //(n8Dummy2 & DUMMY_ADD_EXTERNAL_LEADING);
        case USE_VIRTUAL_DEVICE: return mbUseVirtualDevice; //(n8Dummy1 & DUMMY_USE_VIRTUAL_DEVICE);
        case USE_HIRES_VIRTUAL_DEVICE: return mbUseHiResolutionVirtualDevice; //(n8Dummy2 & DUMMY_USE_HIRES_VIR_DEV);
        case OLD_NUMBERING: return mbOldNumbering;
        case OLD_LINE_SPACING: return mbOldLineSpacing;
        case ADD_PARA_SPACING_TO_TABLE_CELLS: return mbAddParaSpacingToTableCells;
        case USE_FORMER_OBJECT_POS: return mbUseFormerObjectPos;
        case USE_FORMER_TEXT_WRAPPING: return mbUseFormerTextWrapping;
        case CONSIDER_WRAP_ON_OBJECT_POSITION: return mbConsiderWrapOnObjPos;
        case DO_NOT_JUSTIFY_LINES_WITH_MANUAL_BREAK: return mbDoNotJustifyLinesWithManualBreak;
        case IGNORE_FIRST_LINE_INDENT_IN_NUMBERING: return mbIgnoreFirstLineIndentInNumbering;
        case OUTLINE_LEVEL_YIELDS_OUTLINE_RULE: return mbOutlineLevelYieldsOutlineRule;
	    case TABLE_ROW_KEEP: return mbTableRowKeep;
	    case IGNORE_TABS_AND_BLANKS_FOR_LINE_CALCULATION: return mbIgnoreTabsAndBlanksForLineCalculation;
	    case DO_NOT_CAPTURE_DRAW_OBJS_ON_PAGE: return mbDoNotCaptureDrawObjsOnPage;
        // --> OD 2006-08-25 #i68949#
        case CLIP_AS_CHARACTER_ANCHORED_WRITER_FLY_FRAME: return mbClipAsCharacterAnchoredWriterFlyFrames;
        // <--
        case UNIX_FORCE_ZERO_EXT_LEADING: return mbUnixForceZeroExtLeading;
        case USE_OLD_PRINTER_METRICS: return mbOldPrinterMetrics;
         // COMPATIBILITY FLAGS END

        case BROWSE_MODE: return mbBrowseMode;
        case HTML_MODE: return mbHTMLMode;
        case GLOBAL_DOCUMENT: return mbIsGlobalDoc;
        case GLOBAL_DOCUMENT_SAVE_LINKS: return mbGlblDocSaveLinks;
        case LABEL_DOCUMENT: return mbIsLabelDoc;
        case PURGE_OLE: return mbPurgeOLE;
        case KERN_ASIAN_PUNCTUATION: return mbKernAsianPunctuation;
        case DO_NOT_RESET_PARA_ATTRS_FOR_NUM_FONT: return mbDoNotResetParaAttrsForNumFont;
        default:
            ASSERT(false, "Invalid setting id");
    }
    return false;
}

void SwDoc::set(/*[in]*/ DocumentSettingId id, /*[in]*/ bool value)
{
    switch (id)
    {
        // COMPATIBILITY FLAGS START
        case PARA_SPACE_MAX:
            mbParaSpaceMax = value;
            break;
        case PARA_SPACE_MAX_AT_PAGES:
            mbParaSpaceMaxAtPages = value;
            break;
        case TAB_COMPAT:
            mbTabCompat = value;
            break;
        case ADD_FLY_OFFSETS:
            mbAddFlyOffsets = value;
            break;
        case ADD_EXT_LEADING:
            mbAddExternalLeading = value;
            break;
        case USE_VIRTUAL_DEVICE:
            mbUseVirtualDevice = value;
            break;
        case USE_HIRES_VIRTUAL_DEVICE:
            mbUseHiResolutionVirtualDevice = value;
            break;
        case OLD_NUMBERING:
            if (mbOldNumbering != value)
            {
                mbOldNumbering = value;

                const SwNumRuleTbl& rNmTbl = GetNumRuleTbl();
                for( USHORT n = 0; n < rNmTbl.Count(); ++n )
                    rNmTbl[n]->SetInvalidRule(TRUE);

                UpdateNumRule();

                if (pOutlineRule)
                {
                    pOutlineRule->Validate();
                    // --> OD 2005-10-21 - counting of phantoms depends on <IsOldNumbering()>
                    pOutlineRule->SetCountPhantoms( !mbOldNumbering );
                    // <--
                }
            }
            break;
        case OLD_LINE_SPACING:
            mbOldLineSpacing = value;
            break;
        case ADD_PARA_SPACING_TO_TABLE_CELLS:
            mbAddParaSpacingToTableCells = value;
            break;
        case USE_FORMER_OBJECT_POS:
            mbUseFormerObjectPos = value;
            break;
        case USE_FORMER_TEXT_WRAPPING:
            mbUseFormerTextWrapping = value;
            break;
        case CONSIDER_WRAP_ON_OBJECT_POSITION:
            mbConsiderWrapOnObjPos = value;
            break;
        case DO_NOT_JUSTIFY_LINES_WITH_MANUAL_BREAK:
            mbDoNotJustifyLinesWithManualBreak = value;
            break;
        case IGNORE_FIRST_LINE_INDENT_IN_NUMBERING:
            mbIgnoreFirstLineIndentInNumbering = value;
            break;

        case OUTLINE_LEVEL_YIELDS_OUTLINE_RULE:
            mbOutlineLevelYieldsOutlineRule = value;
            break;

	    case TABLE_ROW_KEEP:
	        mbTableRowKeep = value;
	        break;

	    case IGNORE_TABS_AND_BLANKS_FOR_LINE_CALCULATION:
		    mbIgnoreTabsAndBlanksForLineCalculation = value;
			break;

	    case DO_NOT_CAPTURE_DRAW_OBJS_ON_PAGE:
		    mbDoNotCaptureDrawObjsOnPage = value;
			break;

        // --> OD 2006-08-25 #i68949#
        case CLIP_AS_CHARACTER_ANCHORED_WRITER_FLY_FRAME:
            mbClipAsCharacterAnchoredWriterFlyFrames = value;
            break;
        // <--
        case UNIX_FORCE_ZERO_EXT_LEADING:
            mbUnixForceZeroExtLeading = value;
            break;

        case USE_OLD_PRINTER_METRICS:            
            mbOldPrinterMetrics = value;
            break;

         // COMPATIBILITY FLAGS END

        case BROWSE_MODE:
            mbBrowseMode = value;
            break;
        case HTML_MODE:
            mbHTMLMode = value;
            break;
        case GLOBAL_DOCUMENT:
            mbIsGlobalDoc = value;
            break;
        case GLOBAL_DOCUMENT_SAVE_LINKS:
            mbGlblDocSaveLinks = value;
            break;
        case LABEL_DOCUMENT:
            mbIsLabelDoc = value;
            break;
        case PURGE_OLE:
            mbPurgeOLE = value;
            break;
        case KERN_ASIAN_PUNCTUATION:
            mbKernAsianPunctuation = value;
            break;
        case DO_NOT_RESET_PARA_ATTRS_FOR_NUM_FONT:
            mbDoNotResetParaAttrsForNumFont = value;
            break;
        default:
            ASSERT(false, "Invalid setting id");
    }
}

const i18n::ForbiddenCharacters*
    SwDoc::getForbiddenCharacters(/*[in]*/ USHORT nLang, /*[in]*/ bool bLocaleData ) const
{
    const i18n::ForbiddenCharacters* pRet = 0;
    if( xForbiddenCharsTable.isValid() )
        pRet = xForbiddenCharsTable->GetForbiddenCharacters( nLang, FALSE );
    if( bLocaleData && !pRet && pBreakIt )
        pRet = &pBreakIt->GetForbidden( (LanguageType)nLang );
    return pRet;
}

void SwDoc::setForbiddenCharacters(/*[in]*/ USHORT nLang,
                                   /*[in]*/ const i18n::ForbiddenCharacters& rFChars )
{
    if( !xForbiddenCharsTable.isValid() )
    {
        uno::Reference<
            lang::XMultiServiceFactory > xMSF =
                                    ::comphelper::getProcessServiceFactory();
        xForbiddenCharsTable = new SvxForbiddenCharactersTable( xMSF );
    }
    xForbiddenCharsTable->SetForbiddenCharacters( nLang, rFChars );
    if( pDrawModel )
    {
        pDrawModel->SetForbiddenCharsTable( xForbiddenCharsTable );
        if( !mbInReading )
            pDrawModel->ReformatAllTextObjects();
    }

    if( pLayout && !mbInReading )
    {
        pLayout->StartAllAction();
        pLayout->InvalidateAllCntnt();
        pLayout->EndAllAction();
    }
    SetModified();
}

vos::ORef<SvxForbiddenCharactersTable>& SwDoc::getForbiddenCharacterTable()
{
    if( !xForbiddenCharsTable.isValid() )
    {
        uno::Reference<
            lang::XMultiServiceFactory > xMSF =
                                    ::comphelper::getProcessServiceFactory();
        xForbiddenCharsTable = new SvxForbiddenCharactersTable( xMSF );
    }
    return xForbiddenCharsTable;
}

const vos::ORef<SvxForbiddenCharactersTable>& SwDoc::getForbiddenCharacterTable() const
{
    return xForbiddenCharsTable;
}

sal_uInt16 SwDoc::getLinkUpdateMode( /*[in]*/bool bGlobalSettings ) const
{
    sal_uInt16 nRet = nLinkUpdMode;
    if( bGlobalSettings && GLOBALSETTING == nRet )
        nRet = SW_MOD()->GetLinkUpdMode(get(IDocumentSettingAccess::HTML_MODE));
    return nRet;
}

void SwDoc::setLinkUpdateMode( /*[in]*/sal_uInt16 eMode )
{
    nLinkUpdMode = eMode;
}

SwFldUpdateFlags SwDoc::getFieldUpdateFlags( /*[in]*/bool bGlobalSettings ) const
{
    SwFldUpdateFlags eRet = eFldUpdMode;
    if( bGlobalSettings && AUTOUPD_GLOBALSETTING == eRet )
        eRet = SW_MOD()->GetFldUpdateFlags(get(IDocumentSettingAccess::HTML_MODE));
    return eRet;
}

void SwDoc::setFieldUpdateFlags(/*[in]*/SwFldUpdateFlags eMode )
{
    eFldUpdMode = eMode;
}

SwCharCompressType SwDoc::getCharacterCompressionType() const
{
    return eChrCmprType;
}

void SwDoc::setCharacterCompressionType( /*[in]*/SwCharCompressType n )
{
    if( eChrCmprType != n )
    {
        eChrCmprType = n;
        if( pDrawModel )
        {
            pDrawModel->SetCharCompressType( static_cast<UINT16>(n) );
            if( !mbInReading )
                pDrawModel->ReformatAllTextObjects();
        }

        if( pLayout && !mbInReading )
        {
            pLayout->StartAllAction();
            pLayout->InvalidateAllCntnt();
            pLayout->EndAllAction();
        }
        SetModified();
    }
}

/** IDocumentDeviceAccess
*/
SfxPrinter* SwDoc::getPrinter(/*[in]*/ bool bCreate ) const
{
    SfxPrinter* pRet = 0;
    if ( !bCreate || pPrt )
        pRet = pPrt;
    else
        pRet = &CreatePrinter_();

    return pRet;
}

void SwDoc::setPrinter(/*[in]*/ SfxPrinter *pP,/*[in]*/ bool bDeleteOld,/*[in]*/ bool bCallPrtDataChanged )
{
    if ( pP != pPrt )
    {
        if ( bDeleteOld )
            delete pPrt;
        pPrt = pP;
    }
    
    if ( bCallPrtDataChanged &&
         // --> FME 2005-01-21 #i41075# Do not call PrtDataChanged() if we do not
         // use the printer for formatting:
         !get(IDocumentSettingAccess::USE_VIRTUAL_DEVICE) )
        // <--
        PrtDataChanged();
}

VirtualDevice* SwDoc::getVirtualDevice(/*[in]*/ bool bCreate ) const
{
    VirtualDevice* pRet = 0;
    if ( !bCreate || pVirDev )
        pRet = pVirDev;
    else
        pRet = &CreateVirtualDevice_();

    return pRet;
}

void SwDoc::setVirtualDevice(/*[in]*/ VirtualDevice* pVd,/*[in]*/ bool bDeleteOld, /*[in]*/ bool )
{
    if ( pVirDev != pVd )
    {
        if ( bDeleteOld )
            delete pVirDev;
        pVirDev = pVd;
    }
}

OutputDevice* SwDoc::getReferenceDevice(/*[in]*/ bool bCreate ) const
{
    OutputDevice* pRet = 0;
    if ( !get(IDocumentSettingAccess::USE_VIRTUAL_DEVICE) )
    {
        pRet = getPrinter( bCreate );

        if ( bCreate && !pPrt->IsValid() )
        {
            pRet = getVirtualDevice( sal_True );
        }
    }
    else
    {
        pRet = getVirtualDevice( bCreate );
    }

    return pRet;
}

void SwDoc::setReferenceDeviceType(/*[in]*/ bool bNewVirtual,/*[in]*/ bool bNewHiRes )
{
    if ( get(IDocumentSettingAccess::USE_VIRTUAL_DEVICE) != bNewVirtual ||
         get(IDocumentSettingAccess::USE_HIRES_VIRTUAL_DEVICE) != bNewHiRes )
    {
        if ( bNewVirtual )
        {
            VirtualDevice* pMyVirDev = getVirtualDevice( true );
            if ( !bNewHiRes )
                pMyVirDev->SetReferenceDevice( VirtualDevice::REFDEV_MODE06 );
            else
                pMyVirDev->SetReferenceDevice( VirtualDevice::REFDEV_MODE_MSO1 );
        }
        else
        {
            // --> FME 2005-01-21 #i41075#
            // We have to take care that a printer exists before calling
            // PrtDataChanged() in order to prevent that PrtDataChanged()
            // triggers this funny situation:
            // getReferenceDevice()->getPrinter()->CreatePrinter_()
            // ->setPrinter()-> PrtDataChanged()
            getPrinter( true );
            // <--
        }

        set(IDocumentSettingAccess::USE_VIRTUAL_DEVICE, bNewVirtual );
        set(IDocumentSettingAccess::USE_HIRES_VIRTUAL_DEVICE, bNewHiRes );
        PrtDataChanged();
        SetModified();
    }
}

const JobSetup* SwDoc::getJobsetup() const
{
    return pPrt ? &pPrt->GetJobSetup() : 0;
}

void SwDoc::setJobsetup(/*[in]*/ const JobSetup &rJobSetup )
{
    BOOL bCheckPageDescs = 0 == pPrt;
    BOOL bDataChanged = FALSE;

    if ( pPrt )
    {
        if ( pPrt->GetName() == rJobSetup.GetPrinterName() )
        {
            if ( pPrt->GetJobSetup() != rJobSetup )
            {
                pPrt->SetJobSetup( rJobSetup );
                bDataChanged = TRUE;
            }
        }
        else
            delete pPrt, pPrt = 0;
    }

    if( !pPrt )
    {
        //Das ItemSet wird vom Sfx geloescht!
        SfxItemSet *pSet = new SfxItemSet( aAttrPool,
                        FN_PARAM_ADDPRINTER, FN_PARAM_ADDPRINTER,
                        SID_HTML_MODE,  SID_HTML_MODE,
                        SID_PRINTER_NOTFOUND_WARN, SID_PRINTER_NOTFOUND_WARN,
                        SID_PRINTER_CHANGESTODOC, SID_PRINTER_CHANGESTODOC,
                        0 );
        SfxPrinter *p = new SfxPrinter( pSet, rJobSetup );
        if ( bCheckPageDescs )
            setPrinter( p, true, true );
        else
        {
            pPrt = p;
            bDataChanged = TRUE;
        }
    }
    if ( bDataChanged && !get(IDocumentSettingAccess::USE_VIRTUAL_DEVICE) )
        PrtDataChanged();
}

SwPrintData* SwDoc::getPrintData() const
{
    return pPrtData;
}

void SwDoc::setPrintData(/*[in]*/ const SwPrintData& rPrtData )
{
    if(!pPrtData)
        pPrtData = new SwPrintData;
    *pPrtData = rPrtData;
}

/** Implementations the next Interface here
*/

/*
 * Dokumenteditieren (Doc-SS) zum Fuellen des Dokuments
 * durch den RTF Parser und fuer die EditShell.
 */
void SwDoc::ChgDBData(const SwDBData& rNewData)
{
	if( rNewData != aDBData )
	{
		aDBData = rNewData;
		SetModified();
	}
	GetSysFldType(RES_DBNAMEFLD)->UpdateFlds();
}

bool SwDoc::SplitNode( const SwPosition &rPos, bool bChkTableStart )
{
	SwCntntNode *pNode = rPos.nNode.GetNode().GetCntntNode();
	if(0 == pNode)
		return FALSE;

	{
		// Bug 26675:	DataChanged vorm loeschen verschicken, dann bekommt
		//			man noch mit, welche Objecte sich im Bereich befinden.
		//			Danach koennen sie vor/hinter der Position befinden.
		SwDataChanged aTmp( this, rPos, 0 );
	}

	SwUndoSplitNode* pUndo = 0;
	if ( DoesUndo() )
	{
		ClearRedo();
		// einfuegen vom Undo-Object, z.Z. nur beim TextNode
		if( pNode->IsTxtNode() )
			AppendUndo( pUndo = new SwUndoSplitNode( this, rPos, bChkTableStart  ));
	}

	//JP 28.01.97: Sonderfall fuer SplitNode am Tabellenanfang:
	//				steht die am Doc/Fly/Footer/..-Anfang oder direkt
	//				hinter einer Tabelle, dann fuege davor
	//				einen Absatz ein
	if( bChkTableStart && !rPos.nContent.GetIndex() && pNode->IsTxtNode() )
	{
		ULONG nPrevPos = rPos.nNode.GetIndex() - 1;
		const SwTableNode* pTblNd;
		const SwNode* pNd = GetNodes()[ nPrevPos ];
		if( pNd->IsStartNode() &&
			SwTableBoxStartNode == ((SwStartNode*)pNd)->GetStartNodeType() &&
			0 != ( pTblNd = GetNodes()[ --nPrevPos ]->GetTableNode() ) &&
			((( pNd = GetNodes()[ --nPrevPos ])->IsStartNode() &&
			   SwTableBoxStartNode != ((SwStartNode*)pNd)->GetStartNodeType() )
               || ( pNd->IsEndNode() && pNd->StartOfSectionNode()->IsTableNode() )
			   || pNd->IsCntntNode() ))
		{
			if( pNd->IsCntntNode() )
			{
				//JP 30.04.99 Bug 65660:
				// ausserhalb des normalen BodyBereiches gibt es keine
				// Seitenumbrueche, also ist das hier kein gueltige
				// Bedingung fuers einfuegen eines Absatzes
				if( nPrevPos < GetNodes().GetEndOfExtras().GetIndex() )
					pNd = 0;
				else
				{
					// Dann nur, wenn die Tabelle Umbrueche traegt!
					const SwFrmFmt* pFrmFmt = pTblNd->GetTable().GetFrmFmt();
					if( SFX_ITEM_SET != pFrmFmt->GetItemState(RES_PAGEDESC, FALSE) &&
						SFX_ITEM_SET != pFrmFmt->GetItemState( RES_BREAK, FALSE ) )
						pNd = 0;
				}
			}

			if( pNd )
			{
				SwTxtNode* pTxtNd = GetNodes().MakeTxtNode(
										SwNodeIndex( *pTblNd ),
										GetTxtCollFromPool( RES_POOLCOLL_TEXT ));
				if( pTxtNd )
				{
					((SwPosition&)rPos).nNode = pTblNd->GetIndex()-1;
					((SwPosition&)rPos).nContent.Assign( pTxtNd, 0 );

					// nur im BodyBereich den SeitenUmbruch/-Vorlage umhaengem
					if( nPrevPos > GetNodes().GetEndOfExtras().GetIndex() )
					{
						SwFrmFmt* pFrmFmt = pTblNd->GetTable().GetFrmFmt();
						const SfxPoolItem *pItem;
						if( SFX_ITEM_SET == pFrmFmt->GetItemState( RES_PAGEDESC,
							FALSE, &pItem ) )
						{
							pTxtNd->SwCntntNode::SetAttr( *pItem );
							pFrmFmt->ResetAttr( RES_PAGEDESC );
						}
						if( SFX_ITEM_SET == pFrmFmt->GetItemState( RES_BREAK,
							FALSE, &pItem ) )
						{
							pTxtNd->SwCntntNode::SetAttr( *pItem );
							pFrmFmt->ResetAttr( RES_BREAK );
						}
					}

					if( pUndo )
						pUndo->SetTblFlag();
					SetModified();
					return TRUE;
				}
			}
		}
	}

	SvULongs aBkmkArr( 15, 15 );
	_SaveCntntIdx( this, rPos.nNode.GetIndex(), rPos.nContent.GetIndex(),
					aBkmkArr, SAVEFLY_SPLIT );
	if( 0 != ( pNode = pNode->SplitNode( rPos ) ))
	{
		// verschiebe noch alle Bookmarks/TOXMarks/FlyAtCnt
		if( aBkmkArr.Count() )
			_RestoreCntntIdx( this, aBkmkArr, rPos.nNode.GetIndex()-1, 0, TRUE );

		if( IsRedlineOn() || (!IsIgnoreRedline() && pRedlineTbl->Count() ))
		{
			SwPaM aPam( rPos );
			aPam.SetMark();
			aPam.Move( fnMoveBackward );
			if( IsRedlineOn() )
				AppendRedline( new SwRedline( nsRedlineType_t::REDLINE_INSERT, aPam ), true);
			else
				SplitRedline( aPam );
		}
	}

	SetModified();
	return TRUE;
}

bool SwDoc::AppendTxtNode( SwPosition& rPos )
{
	/*
	 * Neuen Node vor EndOfContent erzeugen.
	 */
	SwTxtNode *pCurNode = GetNodes()[ rPos.nNode ]->GetTxtNode();
	if( !pCurNode )
	{
		// dann kann ja einer angelegt werden!
		SwNodeIndex aIdx( rPos.nNode, 1 );
		pCurNode = GetNodes().MakeTxtNode( aIdx,
						GetTxtCollFromPool( RES_POOLCOLL_STANDARD ));
	}
	else
		pCurNode = (SwTxtNode*)pCurNode->AppendNode( rPos );

	rPos.nNode++;
	rPos.nContent.Assign( pCurNode, 0 );

	if( DoesUndo() )
	{
		ClearRedo();
		AppendUndo( new SwUndoInsert( rPos.nNode ));
	}

	if( IsRedlineOn() || (!IsIgnoreRedline() && pRedlineTbl->Count() ))
	{
		SwPaM aPam( rPos );
		aPam.SetMark();
		aPam.Move( fnMoveBackward );
		if( IsRedlineOn() )
			AppendRedline( new SwRedline( nsRedlineType_t::REDLINE_INSERT, aPam ), true);
		else
			SplitRedline( aPam );
	}

	SetModified();
	return TRUE;
}

bool SwDoc::Insert( const SwPaM &rRg, const String &rStr, bool bHintExpand )
{
	if( DoesUndo() )
		ClearRedo();

	const SwPosition* pPos = rRg.GetPoint();

	if( pACEWord )					// Aufnahme in die Autokorrektur
	{
		if( 1 == rStr.Len() && pACEWord->IsDeleted() )
			pACEWord->CheckChar( *pPos, rStr.GetChar( 0 ) );
		delete pACEWord, pACEWord = 0;
	}

	SwTxtNode *pNode = pPos->nNode.GetNode().GetTxtNode();
	if(!pNode)
		return FALSE;

	const USHORT nInsMode = bHintExpand ? INS_EMPTYEXPAND
									 : INS_NOHINTEXPAND;
	SwDataChanged aTmp( rRg, 0 );

	if( !DoesUndo() || !DoesGroupUndo() )
	{
		pNode->Insert( rStr, pPos->nContent, nInsMode );

		if( DoesUndo() )
			AppendUndo( new SwUndoInsert( pPos->nNode,
									pPos->nContent.GetIndex(), rStr.Len() ));
	}
	else
	{			// ist Undo und Gruppierung eingeschaltet, ist alles anders !
		USHORT nUndoSize = pUndos->Count();
		xub_StrLen nInsPos = pPos->nContent.GetIndex();
		SwUndoInsert * pUndo = NULL; // #111827#
		CharClass& rCC = GetAppCharClass();

        // -> #111827#
        bool bNewUndo = false;
		if( 0 == nUndoSize)
            bNewUndo = true;
        else
        {
            pUndo = (SwUndoInsert*)(*pUndos)[ --nUndoSize ];

            switch (pUndo->GetId())
            {
            case UNDO_INSERT:
            case UNDO_TYPING:
                bNewUndo = !pUndo->CanGrouping( *pPos );

                break;

            default:
                bNewUndo = true;
            }
        }
        // <- #111827#

        if (bNewUndo)
		{
			pUndo = new SwUndoInsert( pPos->nNode, nInsPos, 0,
							!rCC.isLetterNumeric( rStr, 0 ) );
			AppendUndo( pUndo );
		}

		pNode->Insert( rStr, pPos->nContent, nInsMode );

		for( xub_StrLen i = 0; i < rStr.Len(); ++i )
		{
			nInsPos++;
			// wenn CanGrouping() TRUE returnt, ist schon alles erledigt
			if( !pUndo->CanGrouping( rStr.GetChar( i ) ))
			{
				pUndo = new SwUndoInsert( pPos->nNode, nInsPos,  1,
							!rCC.isLetterNumeric( rStr, i ) );
				AppendUndo( pUndo );
			}
		}
	}

	if( IsRedlineOn() || (!IsIgnoreRedline() && pRedlineTbl->Count() ))
	{
		SwPaM aPam( pPos->nNode, aTmp.GetCntnt(),
					pPos->nNode, pPos->nContent.GetIndex());
		if( IsRedlineOn() )
			AppendRedline( new SwRedline( nsRedlineType_t::REDLINE_INSERT, aPam ), true);
		else
			SplitRedline( aPam );
	}

	SetModified();
	return TRUE;
}

SwFlyFrmFmt* SwDoc::_InsNoTxtNode( const SwPosition& rPos, SwNoTxtNode* pNode,
									const SfxItemSet* pFlyAttrSet,
									const SfxItemSet* pGrfAttrSet,
									SwFrmFmt* pFrmFmt)
{
	SwFlyFrmFmt *pFmt = 0;
	if( pNode )
	{
		pFmt = _MakeFlySection( rPos, *pNode, FLY_AT_CNTNT,
								pFlyAttrSet, pFrmFmt );
		if( pGrfAttrSet )
			pNode->SetAttr( *pGrfAttrSet );
	}
	return pFmt;
}

SwFlyFrmFmt* SwDoc::Insert( const SwPaM &rRg,
							const String& rGrfName,
							const String& rFltName,
							const Graphic* pGraphic,
							const SfxItemSet* pFlyAttrSet,
							const SfxItemSet* pGrfAttrSet,
							SwFrmFmt* pFrmFmt )
{
	if( !pFrmFmt )
		pFrmFmt = GetFrmFmtFromPool( RES_POOLFRM_GRAPHIC );
	return _InsNoTxtNode( *rRg.GetPoint(), GetNodes().MakeGrfNode(
							SwNodeIndex( GetNodes().GetEndOfAutotext() ),
							rGrfName, rFltName, pGraphic,
							pDfltGrfFmtColl ),
							pFlyAttrSet, pGrfAttrSet, pFrmFmt );
}
SwFlyFrmFmt* SwDoc::Insert( const SwPaM &rRg, const GraphicObject& rGrfObj,
							const SfxItemSet* pFlyAttrSet,
							const SfxItemSet* pGrfAttrSet,
							SwFrmFmt* pFrmFmt )
{
	if( !pFrmFmt )
		pFrmFmt = GetFrmFmtFromPool( RES_POOLFRM_GRAPHIC );
	return _InsNoTxtNode( *rRg.GetPoint(), GetNodes().MakeGrfNode(
							SwNodeIndex( GetNodes().GetEndOfAutotext() ),
							rGrfObj, pDfltGrfFmtColl ),
							pFlyAttrSet, pGrfAttrSet, pFrmFmt );
}

SwFlyFrmFmt* SwDoc::Insert(const SwPaM &rRg, const svt::EmbeddedObjectRef& xObj,
						const SfxItemSet* pFlyAttrSet,
						const SfxItemSet* pGrfAttrSet,
						SwFrmFmt* pFrmFmt )
{
	if( !pFrmFmt )
	{
		USHORT nId = RES_POOLFRM_OLE;
        SvGlobalName aClassName( xObj->getClassID() );
        if (SotExchange::IsMath(aClassName))
            nId = RES_POOLFRM_FORMEL;

		pFrmFmt = GetFrmFmtFromPool( nId );
	}
	return _InsNoTxtNode( *rRg.GetPoint(), GetNodes().MakeOLENode(
							SwNodeIndex( GetNodes().GetEndOfAutotext() ),
                            xObj,
							pDfltGrfFmtColl ),
							pFlyAttrSet, pGrfAttrSet,
							pFrmFmt );
}

SwFlyFrmFmt* SwDoc::InsertOLE(const SwPaM &rRg, const String& rObjName,
						sal_Int64 nAspect,
						const SfxItemSet* pFlyAttrSet,
						const SfxItemSet* pGrfAttrSet,
						SwFrmFmt* pFrmFmt )
{
	if( !pFrmFmt )
		pFrmFmt = GetFrmFmtFromPool( RES_POOLFRM_OLE );

	return _InsNoTxtNode( *rRg.GetPoint(),
							GetNodes().MakeOLENode(
								SwNodeIndex( GetNodes().GetEndOfAutotext() ),
								rObjName,
								nAspect,
								pDfltGrfFmtColl,
								0 ),
							pFlyAttrSet, pGrfAttrSet,
							pFrmFmt );
}

/*************************************************************************
|*				  SwDoc::GetFldType()
|*	  Beschreibung: liefert den am Doc eingerichteten Feldtypen zurueck
*************************************************************************/

SwFieldType *SwDoc::GetSysFldType( const USHORT eWhich ) const
{
	for( USHORT i = 0; i < INIT_FLDTYPES; ++i )
		if( eWhich == (*pFldTypes)[i]->Which() )
			return (*pFldTypes)[i];
	return 0;
}
/*************************************************************************
 *			   void SetDocStat( const SwDocStat& rStat );
 *************************************************************************/

void SwDoc::SetDocStat( const SwDocStat& rStat )
{
	*pDocStat = rStat;
}

const SwDocStat& SwDoc::GetDocStat() const
{
	return *pDocStat;
}

sal_uInt16 SwDoc::GetPageCount() const
{
    return GetRootFrm() ? GetRootFrm()->GetPageNum() : 0;
}

const Size SwDoc::GetPageSize( sal_uInt16 nPageNum, bool bSkipEmptyPages ) const
{
    Size aSize;
    if( GetRootFrm() && nPageNum )
    {
        const SwPageFrm* pPage = static_cast<const SwPageFrm*>
                                 (GetRootFrm()->Lower());

        while( --nPageNum && pPage->GetNext() )
            pPage = static_cast<const SwPageFrm*>( pPage->GetNext() );

        if( !bSkipEmptyPages && pPage->IsEmptyPage() && pPage->GetNext() )
            pPage = static_cast<const SwPageFrm*>( pPage->GetNext() );

        aSize = pPage->Frm().SSize();
    }
    return aSize;
}


/*************************************************************************
 *			  void UpdateDocStat( const SwDocStat& rStat );
 *************************************************************************/

void SwDoc::UpdateDocStat( SwDocStat& rStat )
{
	if( rStat.bModified )
	{
		rStat.Reset();
		rStat.nPara = 0;        // Default ist auf 1 !!
		SwNode* pNd;

        for( ULONG i = GetNodes().Count(); i; )
        {
            switch( ( pNd = GetNodes()[ --i ])->GetNodeType() )
			{
            case ND_TEXTNODE:
                ((SwTxtNode*)pNd)->CountWords( rStat, 0, ((SwTxtNode*)pNd)->GetTxt().Len() );
                break;
			case ND_TABLENODE:		++rStat.nTbl;	break;
			case ND_GRFNODE:		++rStat.nGrf;	break;
			case ND_OLENODE:		++rStat.nOLE;	break;
			case ND_SECTIONNODE:	break;
			}
        }

		rStat.nPage 	= GetRootFrm() ? GetRootFrm()->GetPageNum() : 0;
		rStat.bModified = FALSE;
		SetDocStat( rStat );

		com::sun::star::uno::Sequence < com::sun::star::beans::NamedValue > aStat( rStat.nPage ? 7 : 6);
		sal_Int32 n=0;
		aStat[n].Name = ::rtl::OUString::createFromAscii("TableCount");
		aStat[n++].Value <<= (sal_Int32)rStat.nTbl;
		aStat[n].Name = ::rtl::OUString::createFromAscii("ImageCount");
		aStat[n++].Value <<= (sal_Int32)rStat.nGrf;
		aStat[n].Name = ::rtl::OUString::createFromAscii("ObjectCount");
		aStat[n++].Value <<= (sal_Int32)rStat.nOLE;
		if ( rStat.nPage )
		{
			aStat[n].Name = ::rtl::OUString::createFromAscii("PageCount");
			aStat[n++].Value <<= (sal_Int32)rStat.nPage;
		}
		aStat[n].Name = ::rtl::OUString::createFromAscii("ParagraphCount");
		aStat[n++].Value <<= (sal_Int32)rStat.nPara;
		aStat[n].Name = ::rtl::OUString::createFromAscii("WordCount");
		aStat[n++].Value <<= (sal_Int32)rStat.nWord;
		aStat[n].Name = ::rtl::OUString::createFromAscii("CharacterCount");
		aStat[n++].Value <<= (sal_Int32)rStat.nChar;

		// For e.g. autotext documents there is no pSwgInfo (#i79945)
		if( pSwgInfo )
		{
			com::sun::star::uno::Reference < com::sun::star::beans::XPropertySet > xSet( pSwgInfo->GetInfo(), com::sun::star::uno::UNO_QUERY );
			if ( xSet.is() )
				xSet->setPropertyValue( ::rtl::OUString::createFromAscii("DocumentStatistic"), com::sun::star::uno::makeAny( aStat ) );
		}

		// event. Stat. Felder Updaten
		SwFieldType *pType = GetSysFldType(RES_DOCSTATFLD);
		pType->UpdateFlds();
	}
}


// Dokument - Info

void SwDoc::DocInfoChgd( const SfxDocumentInfo& rInfo )
{
	DBG_ASSERT( pSwgInfo && rInfo.GetInfo() == pSwgInfo->GetInfo(), "DocInfo chaos!" );
	(void) rInfo;

	GetSysFldType( RES_DOCINFOFLD )->UpdateFlds();
	GetSysFldType( RES_TEMPLNAMEFLD )->UpdateFlds();
	SetModified();
}

	// returne zum Namen die im Doc gesetzte Referenz
const SwFmtRefMark* SwDoc::GetRefMark( const String& rName ) const
{
	const SfxPoolItem* pItem;
	USHORT nMaxItems = GetAttrPool().GetItemCount( RES_TXTATR_REFMARK );
	for( USHORT n = 0; n < nMaxItems; ++n )
	{
		if( 0 == (pItem = GetAttrPool().GetItem( RES_TXTATR_REFMARK, n ) ))
			continue;

		const SwFmtRefMark* pFmtRef = (SwFmtRefMark*)pItem;
		const SwTxtRefMark* pTxtRef = pFmtRef->GetTxtRefMark();
		if( pTxtRef && &pTxtRef->GetTxtNode().GetNodes() == &GetNodes() &&
			rName.Equals( pFmtRef->GetRefName() ) )
			return pFmtRef;
	}
	return 0;
}

	// returne die RefMark per Index - fuer Uno
const SwFmtRefMark* SwDoc::GetRefMark( USHORT nIndex ) const
{
	const SfxPoolItem* pItem;
	const SwTxtRefMark* pTxtRef;
	const SwFmtRefMark* pRet = 0;

	USHORT nMaxItems = GetAttrPool().GetItemCount( RES_TXTATR_REFMARK );
	USHORT nCount = 0;
	for( USHORT n = 0; n < nMaxItems; ++n )
		if( 0 != (pItem = GetAttrPool().GetItem( RES_TXTATR_REFMARK, n )) &&
			0 != (pTxtRef = ((SwFmtRefMark*)pItem)->GetTxtRefMark()) &&
			&pTxtRef->GetTxtNode().GetNodes() == &GetNodes() )
		{
			if(nCount == nIndex)
			{
				pRet = (SwFmtRefMark*)pItem;
				break;
			}
			nCount++;
		}
   return pRet;
}

	// returne die Namen aller im Doc gesetzten Referenzen
	//JP 24.06.96: Ist der ArrayPointer 0 dann returne nur, ob im Doc. eine
	//				RefMark gesetzt ist
	// OS 25.06.96: ab jetzt wird immer die Anzahl der Referenzen returnt
USHORT SwDoc::GetRefMarks( SvStringsDtor* pNames ) const
{
	const SfxPoolItem* pItem;
	const SwTxtRefMark* pTxtRef;

	USHORT nMaxItems = GetAttrPool().GetItemCount( RES_TXTATR_REFMARK );
	USHORT nCount = 0;
	for( USHORT n = 0; n < nMaxItems; ++n )
		if( 0 != (pItem = GetAttrPool().GetItem( RES_TXTATR_REFMARK, n )) &&
			0 != (pTxtRef = ((SwFmtRefMark*)pItem)->GetTxtRefMark()) &&
			&pTxtRef->GetTxtNode().GetNodes() == &GetNodes() )
		{
			if( pNames )
			{
				String* pTmp = new String( ((SwFmtRefMark*)pItem)->GetRefName() );
				pNames->Insert( pTmp, nCount );
			}
			nCount ++;
		}

	return nCount;
}

bool SwDoc::IsLoaded() const
{
	return mbLoaded;
}

bool SwDoc::IsUpdateExpFld() const
{
	return mbUpdateExpFld;
}

bool SwDoc::IsNewDoc() const
{
	return mbNewDoc;
}

bool SwDoc::IsPageNums() const
{
  return mbPageNums;
}

void SwDoc::SetPageNums(bool b)
{
	mbPageNums = b;
}

void SwDoc::SetNewDoc(bool b)
{
	mbNewDoc = b;
}

void SwDoc::SetUpdateExpFldStat(bool b)
{
	mbUpdateExpFld = b;
}

void SwDoc::SetLoaded(bool b)
{
	mbLoaded = b;
}

bool SwDoc::IsModified() const
{
	return mbModified;
}

void SwDoc::SetModified()
{
    // --> OD 2005-08-29 #125370#
    SwLayouter::ClearMovedFwdFrms( *this );
    SwLayouter::ClearObjsTmpConsiderWrapInfluence( *this );
    SwLayouter::ClearFrmsNotToWrap( *this );
    // <--
    // --> OD 2006-05-10 #i65250#
    SwLayouter::ClearMoveBwdLayoutInfo( *this );
    // <--
	// dem Link wird der Status returnt, wie die Flags waren und werden
	// 	Bit 0:	-> alter Zustand
	//	Bit 1: 	-> neuer Zustand
	long nCall = mbModified ? 3 : 2;
	mbModified = TRUE;
	pDocStat->bModified = TRUE;
	if( aOle2Link.IsSet() )
	{
		mbInCallModified = TRUE;
		aOle2Link.Call( (void*)nCall );
		mbInCallModified = FALSE;
	}

	if( pACEWord && !pACEWord->IsDeleted() )
		delete pACEWord, pACEWord = 0;
}

void SwDoc::ResetModified()
{
	// dem Link wird der Status returnt, wie die Flags waren und werden
	// 	Bit 0:	-> alter Zustand
	//	Bit 1: 	-> neuer Zustand
    long nCall = mbModified ? 1 : 0;
	mbModified = FALSE;
    // If there is already a document statistic, we assume that
    // it is correct. In this case we reset the modified flag.
    if ( 0 != pDocStat->nChar )
        pDocStat->bModified = FALSE;
    nUndoSavePos = nUndoPos;
	if( nCall && aOle2Link.IsSet() )
	{
		mbInCallModified = TRUE;
		aOle2Link.Call( (void*)nCall );
		mbInCallModified = FALSE;
	}
}


void SwDoc::ReRead( SwPaM& rPam, const String& rGrfName,
					const String& rFltName, const Graphic* pGraphic,
					const GraphicObject* pGrafObj )
{
	SwGrfNode *pGrfNd;
	if( ( !rPam.HasMark()
		 || rPam.GetPoint()->nNode.GetIndex() == rPam.GetMark()->nNode.GetIndex() )
		 && 0 != ( pGrfNd = rPam.GetPoint()->nNode.GetNode().GetGrfNode() ) )
	{
		if( DoesUndo() )
		{
			ClearRedo();
			AppendUndo( new SwUndoReRead( rPam, *pGrfNd ) );
		}

		// Weil nicht bekannt ist, ob sich die Grafik spiegeln laesst,
		// immer das SpiegelungsAttribut zuruecksetzen
        if( RES_MIRROR_GRAPH_DONT != pGrfNd->GetSwAttrSet().
												GetMirrorGrf().GetValue() )
			pGrfNd->SetAttr( SwMirrorGrf() );

		pGrfNd->ReRead( rGrfName, rFltName, pGraphic, pGrafObj, TRUE );
		SetModified();
	}
}

BOOL lcl_SpellAgain( const SwNodePtr& rpNd, void* pArgs )
{
	SwTxtNode *pTxtNode = (SwTxtNode*)rpNd->GetTxtNode();
	BOOL bOnlyWrong = *(BOOL*)pArgs;
	if( pTxtNode )
	{
		if( bOnlyWrong )
		{
			if( pTxtNode->GetWrong() &&
				pTxtNode->GetWrong()->InvalidateWrong() )
                pTxtNode->SetWrongDirty( true );
		}
		else
		{
            pTxtNode->SetWrongDirty( true );
			if( pTxtNode->GetWrong() )
				pTxtNode->GetWrong()->SetInvalid( 0, STRING_LEN );
		}
	}
	return TRUE;
}

BOOL lcl_CheckSmartTagsAgain( const SwNodePtr& rpNd, void*  )
{
	SwTxtNode *pTxtNode = (SwTxtNode*)rpNd->GetTxtNode();
//	BOOL bOnlyWrong = *(BOOL*)pArgs;
	if( pTxtNode )
	{
        pTxtNode->SetSmartTagDirty( true );
        if( pTxtNode->GetSmartTags() )
        {
//            if ( bOnlyWrong ) // only some smart tag types have been enabled or disabled
//				pTxtNode->GetSmartTags()->SetInvalid( 0, STRING_LEN );
//            else // smart tags all have been enabled or disabled
				pTxtNode->SetSmartTags( NULL );
        }
	}
	return TRUE;
}


/*************************************************************************
 * 		SwDoc::SpellItAgainSam( BOOL bInvalid, BOOL bOnlyWrong )
 *
 * stoesst das Spelling im Idle-Handler wieder an.
 * Wird bInvalid als TRUE uebergeben, so werden zusaetzlich die WrongListen
 * an allen Nodes invalidiert und auf allen Seiten das SpellInvalid-Flag
 * gesetzt.
 * Mit bOnlyWrong kann man dann steuern, ob nur die Bereiche mit falschen
 * Woertern oder die kompletten Bereiche neu ueberprueft werden muessen.
 ************************************************************************/

void SwDoc::SpellItAgainSam( BOOL bInvalid, BOOL bOnlyWrong, BOOL bSmartTags )
{
	ASSERT( GetRootFrm(), "SpellAgain: Where's my RootFrm?" );
	if( bInvalid )
	{
		SwPageFrm *pPage = (SwPageFrm*)GetRootFrm()->Lower();
		while ( pPage )
		{
			if ( bSmartTags )
                pPage->InvalidateSmartTags();

            pPage->InvalidateSpelling();
			pPage = (SwPageFrm*)pPage->GetNext();
		}

    	if ( bSmartTags )
            GetNodes().ForEach( lcl_CheckSmartTagsAgain, &bOnlyWrong );

        GetNodes().ForEach( lcl_SpellAgain, &bOnlyWrong );
	}

	GetRootFrm()->SetIdleFlags();
}

void SwDoc::InvalidateAutoCompleteFlag()
{
	if( GetRootFrm() )
	{
		SwPageFrm *pPage = (SwPageFrm*)GetRootFrm()->Lower();
		while ( pPage )
		{
			pPage->InvalidateAutoCompleteWords();
			pPage = (SwPageFrm*)pPage->GetNext();
		}
		for( ULONG nNd = 1, nCnt = GetNodes().Count(); nNd < nCnt; ++nNd )
        {
            SwTxtNode* pTxtNode = GetNodes()[ nNd ]->GetTxtNode();
            if ( pTxtNode ) pTxtNode->SetAutoCompleteWordDirty( true );
        }
		GetRootFrm()->SetIdleFlags();
	}
}

const SwFmtINetFmt* SwDoc::FindINetAttr( const String& rName ) const
{
	const SwFmtINetFmt* pItem;
	const SwTxtINetFmt* pTxtAttr;
	const SwTxtNode* pTxtNd;
	USHORT n, nMaxItems = GetAttrPool().GetItemCount( RES_TXTATR_INETFMT );
	for( n = 0; n < nMaxItems; ++n )
		if( 0 != (pItem = (SwFmtINetFmt*)GetAttrPool().GetItem(
			RES_TXTATR_INETFMT, n ) ) &&
			pItem->GetName().Equals( rName ) &&
			0 != ( pTxtAttr = pItem->GetTxtINetFmt()) &&
			0 != ( pTxtNd = pTxtAttr->GetpTxtNode() ) &&
			&pTxtNd->GetNodes() == &GetNodes() )
		{
			return pItem;
		}

	return 0;
}

void SwDoc::Summary( SwDoc* pExtDoc, BYTE nLevel, BYTE nPara, BOOL bImpress )
{
	const SwOutlineNodes& rOutNds = GetNodes().GetOutLineNds();
	if( pExtDoc && rOutNds.Count() )
	{
		USHORT i;
		::StartProgress( STR_STATSTR_SUMMARY, 0, rOutNds.Count(), GetDocShell() );
		SwNodeIndex aEndOfDoc( pExtDoc->GetNodes().GetEndOfContent(), -1 );
		for( i = 0; i < rOutNds.Count(); ++i )
		{
			::SetProgressState( i, GetDocShell() );
			ULONG nIndex = rOutNds[ i ]->GetIndex();
			BYTE nLvl = ((SwTxtNode*)GetNodes()[ nIndex ])->GetTxtColl()
						 ->GetOutlineLevel();
			if( nLvl > nLevel )
				continue;
			USHORT nEndOfs = 1;
			BYTE nWish = nPara;
			ULONG nNextOutNd = i + 1 < rOutNds.Count() ?
				rOutNds[ i + 1 ]->GetIndex() : GetNodes().Count();
			BOOL bKeep = FALSE;
			while( ( nWish || bKeep ) && nIndex + nEndOfs < nNextOutNd &&
				   GetNodes()[ nIndex + nEndOfs ]->IsTxtNode() )
			{
				SwTxtNode* pTxtNode = (SwTxtNode*)GetNodes()[ nIndex+nEndOfs ];
				if( pTxtNode->GetTxt().Len() && nWish )
					--nWish;
				bKeep = pTxtNode->GetSwAttrSet().GetKeep().GetValue();
				++nEndOfs;
			}

			SwNodeRange aRange( *rOutNds[ i ], 0, *rOutNds[ i ], nEndOfs );
			GetNodes()._Copy( aRange, aEndOfDoc );
		}
		const SwTxtFmtColls *pColl = pExtDoc->GetTxtFmtColls();
		for( i = 0; i < pColl->Count(); ++i )
			(*pColl)[ i ]->ResetAttr( RES_PAGEDESC, RES_BREAK );
		SwNodeIndex aIndx( pExtDoc->GetNodes().GetEndOfExtras() );
		++aEndOfDoc;
		while( aIndx < aEndOfDoc )
		{
			SwNode *pNode;
			BOOL bDelete = FALSE;
			if(	(pNode = &aIndx.GetNode())->IsTxtNode() )
			{
				SwTxtNode *pNd = (SwTxtNode*)pNode;
				if( pNd->HasSwAttrSet() )
					pNd->ResetAttr( RES_PAGEDESC, RES_BREAK );
				if( bImpress )
				{
					SwTxtFmtColl* pMyColl = pNd->GetTxtColl();
					USHORT nHeadLine = static_cast<USHORT>(pMyColl->GetOutlineLevel()==NO_NUMBERING ?
								RES_POOLCOLL_HEADLINE2 : RES_POOLCOLL_HEADLINE1);
					pMyColl = pExtDoc->GetTxtCollFromPool( nHeadLine );
					pNd->ChgFmtColl( pMyColl );
				}
				if( !pNd->Len() &&
					pNd->StartOfSectionIndex()+2 < pNd->EndOfSectionIndex() )
				{
					bDelete = TRUE;
					pExtDoc->GetNodes().Delete( aIndx );
				}
			}
			if( !bDelete )
				++aIndx;
		}
		::EndProgress( GetDocShell() );
	}
}

	// loesche den nicht sichtbaren Content aus dem Document, wie z.B.:
	// versteckte Bereiche, versteckte Absaetze
BOOL SwDoc::RemoveInvisibleContent()
{
	BOOL bRet = FALSE;
    StartUndo( UNDO_UI_DELETE_INVISIBLECNTNT, NULL );

	{
		SwTxtNode* pTxtNd;
		SwClientIter aIter( *GetSysFldType( RES_HIDDENPARAFLD ) );
		for( SwFmtFld* pFmtFld = (SwFmtFld*)aIter.First( TYPE( SwFmtFld ));
				pFmtFld; pFmtFld = (SwFmtFld*)aIter.Next() )
        {
			if( pFmtFld->GetTxtFld() &&
				0 != ( pTxtNd = (SwTxtNode*)pFmtFld->GetTxtFld()->GetpTxtNode() ) &&
                pTxtNd->GetpSwpHints() && pTxtNd->HasHiddenParaField() &&
				&pTxtNd->GetNodes() == &GetNodes() )
			{
				bRet = TRUE;
                SwPaM aPam( *pTxtNd, 0, *pTxtNd, pTxtNd->GetTxt().Len() );

                // Remove hidden paragraph or delete contents:
                // Delete contents if
                // 1. removing the paragraph would result in an empty section or
                // 2. if the paragraph is the last paragraph in the section and
                //    there is no paragraph in front of the paragraph:
                if ( ( 2 == pTxtNd->EndOfSectionIndex() - pTxtNd->StartOfSectionIndex() ) ||
                     ( 1 == pTxtNd->EndOfSectionIndex() - pTxtNd->GetIndex() &&
                       !GetNodes()[ pTxtNd->GetIndex() - 1 ]->GetTxtNode() ) )
                {
                    Delete( aPam );
                }
                else
                {
                    aPam.DeleteMark();
                    DelFullPara( aPam );
                }
            }
        }
	}

    //
    // Remove any hidden paragraph (hidden text attribute)
    //
    for( ULONG n = GetNodes().Count(); n; )
    {
        SwTxtNode* pTxtNd = GetNodes()[ --n ]->GetTxtNode();
        if ( pTxtNd )
        {
            bool bRemoved = false;
            SwPaM aPam( *pTxtNd, 0, *pTxtNd, pTxtNd->GetTxt().Len() );
            if ( pTxtNd->HasHiddenCharAttribute( true ) )
            {
                bRemoved = TRUE;
                bRet = TRUE;

                // Remove hidden paragraph or delete contents:
                // Delete contents if
                // 1. removing the paragraph would result in an empty section or
                // 2. if the paragraph is the last paragraph in the section and
                //    there is no paragraph in front of the paragraph:

                if ( ( 2 == pTxtNd->EndOfSectionIndex() - pTxtNd->StartOfSectionIndex() ) ||
                     ( 1 == pTxtNd->EndOfSectionIndex() - pTxtNd->GetIndex() &&
                       !GetNodes()[ pTxtNd->GetIndex() - 1 ]->GetTxtNode() ) )
                {
                    Delete( aPam );
                }
                else
                {
                    aPam.DeleteMark();
					DelFullPara( aPam );
				}
            }
            else if ( pTxtNd->HasHiddenCharAttribute( false ) )
            {
                bRemoved = TRUE;
                bRet = TRUE;
                SwScriptInfo::DeleteHiddenRanges( *pTxtNd );
            }

            // --> FME 2006-01-11 #120473#
            // Footnotes/Frames may have been removed, therefore we have
            // to reset n:
            if ( bRemoved )
                n = aPam.GetPoint()->nNode.GetIndex();
            // <--
        }
    }

	{
		// dann noch alle versteckten Bereiche loeschen/leeren
		SwSectionFmts aSectFmts;
		SwSectionFmts& rSectFmts = GetSections();
		USHORT n;

		for( n = rSectFmts.Count(); n; )
		{
			SwSectionFmt* pSectFmt = rSectFmts[ --n ];
		    // don't add sections in Undo/Redo
            if( !pSectFmt->IsInNodesArr())
                continue;
			SwSection* pSect = pSectFmt->GetSection();
			if( pSect->CalcHiddenFlag() )
			{
				SwSection* pParent = pSect, *pTmp;
				while( 0 != (pTmp = pParent->GetParent() ))
				{
					if( pTmp->IsHiddenFlag() )
						pSect = pTmp;
					pParent = pTmp;
				}

				if( USHRT_MAX == aSectFmts.GetPos( pSect->GetFmt() ) )
					aSectFmts.Insert( pSect->GetFmt(), 0 );
			}
			if( pSect->GetCondition().Len() )
			{
				SwSection aSect( pSect->GetType(), pSect->GetName() );
				aSect = *pSect;
				aSect.SetCondition( aEmptyStr );
				aSect.SetHidden( FALSE );
				ChgSection( n, aSect );
			}
		}

		if( 0 != ( n = aSectFmts.Count() ))
		{
			while( n )
			{
				SwSectionFmt* pSectFmt = aSectFmts[ --n ];
				SwSectionNode* pSectNd = pSectFmt->GetSectionNode();
				if( pSectNd )
				{
					bRet = TRUE;
					SwPaM aPam( *pSectNd );

                    if( pSectNd->StartOfSectionNode()->StartOfSectionIndex() ==
						pSectNd->GetIndex() - 1 &&
                        pSectNd->StartOfSectionNode()->EndOfSectionIndex() ==
						pSectNd->EndOfSectionIndex() + 1 )
					{
						// nur den Inhalt loeschen
						SwCntntNode* pCNd = GetNodes().GoNext(
												&aPam.GetPoint()->nNode );
						aPam.GetPoint()->nContent.Assign( pCNd, 0 );
						aPam.SetMark();
						aPam.GetPoint()->nNode = *pSectNd->EndOfSectionNode();
						pCNd = GetNodes().GoPrevious(
												&aPam.GetPoint()->nNode );
						aPam.GetPoint()->nContent.Assign( pCNd, pCNd->Len() );

						Delete( aPam );
					}
					else
					{
						// die gesamte Section loeschen
						aPam.SetMark();
						aPam.GetPoint()->nNode = *pSectNd->EndOfSectionNode();
						DelFullPara( aPam );
					}

				}
			}
			aSectFmts.Remove( 0, aSectFmts.Count() );
		}
	}

	if( bRet )
		SetModified();
    EndUndo( UNDO_UI_DELETE_INVISIBLECNTNT, NULL );
	return bRet;
}
/*-- 11.06.2004 08:34:04---------------------------------------------------

  -----------------------------------------------------------------------*/
BOOL SwDoc::ConvertFieldsToText()
{
    BOOL bRet = FALSE;
    StartUndo( UNDO_UI_REPLACE, NULL );

    const SwFldTypes* pMyFldTypes = GetFldTypes();
    sal_uInt16 nCount = pMyFldTypes->Count();
    //go backward, field types are removed
    for(sal_uInt16 nType = nCount;  nType > 0;  --nType)
    {
        const SwFieldType *pCurType = pMyFldTypes->GetObject(nType - 1);

        if ( RES_POSTITFLD == pCurType->Which() )
            continue;

        SwClientIter aIter( *(SwFieldType*)pCurType );
        const SwFmtFld* pCurFldFmt = (SwFmtFld*)aIter.First( TYPE( SwFmtFld ));
        ::std::vector<const SwFmtFld*> aFieldFmts;
        while (pCurFldFmt)
        {
            aFieldFmts.push_back(pCurFldFmt);
            pCurFldFmt = (SwFmtFld*)aIter.Next();
        }
        ::std::vector<const SwFmtFld*>::iterator aBegin = aFieldFmts.begin();
        ::std::vector<const SwFmtFld*>::iterator aEnd = aFieldFmts.end();
        while(aBegin != aEnd)
        {
            const SwTxtFld *pTxtFld = (*aBegin)->GetTxtFld();
            // skip fields that are currently not in the document
            // e.g. fields in undo or redo array

            BOOL bSkip = !pTxtFld ||
                         !pTxtFld->GetpTxtNode()->GetNodes().IsDocNodes();

            if (!bSkip)
            {
                BOOL bInHeaderFooter = IsInHeaderFooter(SwNodeIndex(*pTxtFld->GetpTxtNode()));
                const SwFmtFld& rFmtFld = pTxtFld->GetFld();
                const SwField*  pField = rFmtFld.GetFld();

                //#i55595# some fields have to be excluded in headers/footers
                USHORT nWhich = pField->GetTyp()->Which();
                if(!bInHeaderFooter ||
                        (nWhich != RES_PAGENUMBERFLD &&
                        nWhich != RES_CHAPTERFLD &&
                        nWhich != RES_GETEXPFLD&&
                        nWhich != RES_SETEXPFLD&&
                        nWhich != RES_INPUTFLD&&
                        nWhich != RES_REFPAGEGETFLD&&
                        nWhich != RES_REFPAGESETFLD))
                {
                    String sText = pField->GetCntnt();
                    //database fields should not convert their command into text
                    if( RES_DBFLD == pCurType->Which() && !static_cast<const SwDBField*>(pField)->IsInitialized())
                        sText.Erase();

                    //now remove the field and insert the string
                    SwPaM aPam(*pTxtFld->GetpTxtNode(), *pTxtFld->GetStart());
                    aPam.SetMark();
                    aPam.Move();
                    DeleteAndJoin(aPam);
                    Insert( aPam, sText, true );
                }
            }
            ++aBegin;
        }
    }

    if( bRet )
        SetModified();
    EndUndo( UNDO_UI_REPLACE, NULL );
    return bRet;

}

bool SwDoc::IsVisibleLinks() const
{
    return mbVisibleLinks;
}

void SwDoc::SetVisibleLinks(bool bFlag)
{
    mbVisibleLinks = bFlag;
}

SvxLinkManager& SwDoc::GetLinkManager()
{
    return *pLinkMgr;
}

const SvxLinkManager& SwDoc::GetLinkManager() const
{
    return *pLinkMgr;
}

void SwDoc::SetLinksUpdated(const bool bNewLinksUpdated)
{
    mbLinksUpdated = bNewLinksUpdated;
}

bool SwDoc::LinksUpdated() const
{
    return mbLinksUpdated;
}

	// embedded alle lokalen Links (Bereiche/Grafiken)
bool SwDoc::EmbedAllLinks()
{
	BOOL bRet = FALSE;
	SvxLinkManager& rLnkMgr = GetLinkManager();
    const ::sfx2::SvBaseLinks& rLnks = rLnkMgr.GetLinks();
	if( rLnks.Count() )
	{
		BOOL bDoesUndo = DoesUndo();
		DoUndo( FALSE );

		for( USHORT n = 0; n < rLnks.Count(); ++n )
		{
            ::sfx2::SvBaseLink* pLnk = &(*rLnks[ n ]);
			if( pLnk &&
				( OBJECT_CLIENT_GRF == pLnk->GetObjType() ||
				  OBJECT_CLIENT_FILE == pLnk->GetObjType() ) &&
				pLnk->ISA( SwBaseLink ) )
			{
                ::sfx2::SvBaseLinkRef xLink = pLnk;
				USHORT nCount = rLnks.Count();

				String sFName;
				rLnkMgr.GetDisplayNames( xLink, 0, &sFName, 0, 0 );

				INetURLObject aURL( sFName );
				if( INET_PROT_FILE == aURL.GetProtocol() ||
					INET_PROT_CID == aURL.GetProtocol() )
				{
					// dem Link sagen, das er aufgeloest wird!
					xLink->Closed();

					// falls einer vergessen hat sich auszutragen
					if( xLink.Is() )
						rLnkMgr.Remove( xLink );

					if( nCount != rLnks.Count() + 1 )
						n = 0;		// wieder von vorne anfangen, es wurden
									// mehrere Links entfernt
					bRet = TRUE;
				}
			}
		}

		DelAllUndoObj();
		DoUndo( bDoesUndo );
		SetModified();
	}
	return bRet;
}

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

BOOL SwDoc::IsInsTblFormatNum() const
{
	return SW_MOD()->IsInsTblFormatNum(get(IDocumentSettingAccess::HTML_MODE));
}

BOOL SwDoc::IsInsTblChangeNumFormat() const
{
	return SW_MOD()->IsInsTblChangeNumFormat(get(IDocumentSettingAccess::HTML_MODE));
}

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

BOOL SwDoc::IsInsTblAlignNum() const
{
	return SW_MOD()->IsInsTblAlignNum(get(IDocumentSettingAccess::HTML_MODE));
}

        // setze das InsertDB als Tabelle Undo auf:
void SwDoc::AppendUndoForInsertFromDB( const SwPaM& rPam, BOOL bIsTable )
{
	if( bIsTable )
	{
		const SwTableNode* pTblNd = rPam.GetPoint()->nNode.GetNode().FindTableNode();
		if( pTblNd )
		{
			SwUndoCpyTbl* pUndo = new SwUndoCpyTbl;
			pUndo->SetTableSttIdx( pTblNd->GetIndex() );
			AppendUndo( pUndo );
		}
	}
	else if( rPam.HasMark() )
	{
		SwUndoCpyDoc* pUndo = new SwUndoCpyDoc( rPam );
		pUndo->SetInsertRange( rPam, FALSE );
		AppendUndo( pUndo );
	}
}

void SwDoc::ChgTOX(SwTOXBase & rTOX, const SwTOXBase & rNew)
{
    if (DoesUndo())
    {
        DelAllUndoObj();

        SwUndo * pUndo = new SwUndoTOXChange(&rTOX, rNew);

        AppendUndo(pUndo);
    }

    rTOX = rNew;

    if (rTOX.ISA(SwTOXBaseSection))
    {
        static_cast<SwTOXBaseSection &>(rTOX).Update();
        static_cast<SwTOXBaseSection &>(rTOX).UpdatePageNum();
    }
}

// #111827#
String SwDoc::GetPaMDescr(const SwPaM & rPam) const
{
    String aResult;
    bool bOK = false;

    if (rPam.GetNode(TRUE) == rPam.GetNode(FALSE))
    {
        SwTxtNode * pTxtNode = rPam.GetNode(TRUE)->GetTxtNode();

        if (0 != pTxtNode)
        {
            xub_StrLen nStart = rPam.Start()->nContent.GetIndex();
            xub_StrLen nEnd = rPam.End()->nContent.GetIndex();

            aResult += String(SW_RES(STR_START_QUOTE));
            aResult += ShortenString(pTxtNode->GetTxt().
                                     Copy(nStart, nEnd - nStart),
                                     nUndoStringLength,
                                     String(SW_RES(STR_LDOTS)));
            aResult += String(SW_RES(STR_END_QUOTE));

            bOK = true;
        }
    }
    else if (0 != rPam.GetNode(TRUE))
    {
        if (0 != rPam.GetNode(FALSE))
            aResult += String(SW_RES(STR_PARAGRAPHS));

        bOK = true;
    }

    if (! bOK)
        aResult += String("??", RTL_TEXTENCODING_ASCII_US);

    return aResult;
}

// -> #111840#
SwField * SwDoc::GetField(const SwPosition & rPos)
{
    SwField * pResult = NULL;

    SwTxtFld * pAttr = rPos.nNode.GetNode().GetTxtNode()->
        GetTxtFld(rPos.nContent);

    if (pAttr)
        pResult = (SwField *) pAttr->GetFld().GetFld();

    return pResult;
}

SwTxtFld * SwDoc::GetTxtFld(const SwPosition & rPos)
{
	SwTxtNode *pNode = rPos.nNode.GetNode().GetTxtNode();
	if( pNode )
		return pNode->GetTxtFld( rPos.nContent );
	else
		return 0;
}
// <- #111840#

bool SwDoc::ContainsHiddenChars() const
{
    for( ULONG n = GetNodes().Count(); n; )
    {
        SwNode* pNd = GetNodes()[ --n ];
        if ( ND_TEXTNODE == pNd->GetNodeType() &&
             ((SwTxtNode*)pNd)->HasHiddenCharAttribute( false ) )
            return true;
    }

    return false;
}

SwUnoCrsr* SwDoc::CreateUnoCrsr( const SwPosition& rPos, BOOL bTblCrsr )
{
	SwUnoCrsr* pNew;
	if( bTblCrsr )
		pNew = new SwUnoTableCrsr( rPos );
	else
		pNew = new SwUnoCrsr( rPos );

	pUnoCrsrTbl->Insert( pNew, pUnoCrsrTbl->Count() );
	return pNew;
}

/* @@@MAINTAINABILITY-HORROR@@@
   Probably unwanted dependency on SwDocShell and SfxDocumentInfo
*/
void SwDoc::SetDocumentInfo( const SfxDocumentInfo& rInfo )
{
	if ( !pSwgInfo )
		pSwgInfo = new SfxDocumentInfo( rInfo );
	else
		(*pSwgInfo) = rInfo;
}

void SwDoc::ChkCondColls()
{
     for (USHORT n = 0; n < pTxtFmtCollTbl->Count(); n++)
     {
        SwTxtFmtColl *pColl = (*pTxtFmtCollTbl)[n];

        if (RES_CONDTXTFMTCOLL == pColl->Which())
        {
            SwClientIter aIter(*pColl);

            SwClient * pClient = aIter.First(TYPE(SwTxtNode));
            while (pClient)
            {
                SwTxtNode * pTxtNode = static_cast<SwTxtNode *>(pClient);

                pTxtNode->ChkCondColl();

                pClient = aIter.Next();
            }
        }
     }
}

