/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TokenMap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/04/11 10:49:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <iostream>
#include "TokenMap.hxx"
#include "gperfelements.hxx"
#include "gperfattributes.hxx"

namespace ooxml 
{
using namespace ::std;

rtl::OUString aEmptyStr;

TokenMap::Pointer_t TokenMap::pInstance;

TokenEnum_t TokenMap::getToken(TokenType_t nType, 
                               const rtl::OUString & rTokenString)
{
    TokenEnum_t nResult = OOXML_TOKENS_END;

    rtl::OString sTokenString = 
        OUStringToOString(rTokenString, RTL_TEXTENCODING_ASCII_US);

    switch (nType)
    {
    case TokenMap::ELEMENT:
        {
            struct tokenmap::elements::token * pToken =
                tokenmap::elements::Perfect_Hash::in_word_set
                (sTokenString, sTokenString.getLength());

            if (pToken != NULL)
                nResult = pToken->nToken;
            else
                clog << "Token not found:" 
                     << OUStringToOString
                    (rTokenString, RTL_TEXTENCODING_ASCII_US).getStr() << endl;
        }
        break;
    case TokenMap::ATTRIBUTE:
        {
            struct tokenmap::attributes::token * pToken =
                tokenmap::attributes::Perfect_Hash::in_word_set
                (sTokenString, sTokenString.getLength());

            if (pToken != NULL)
                nResult = pToken->nToken;
            else
                clog << "Token not found:" 
                     << OUStringToOString
                    (rTokenString, RTL_TEXTENCODING_ASCII_US).getStr() << endl;
        }
        break;
    default:
        break;
    }

    return nResult;
}

const rtl::OUString & 
TokenMap::getTokenString(TokenType_t nType, TokenEnum_t nToken)
{
    rtl::OUString & aResult = aEmptyStr;

    ReverseMap_t::iterator aIt;
    switch (nType)
    {
    case TokenMap::ELEMENT:
        aIt = mElementReverseMap.find(nToken);
        if (aIt != mElementReverseMap.end())
            aResult = aIt->second;
        break;
    case TokenMap::ATTRIBUTE:
        aIt = mAttributeReverseMap.find(nToken);
        if (aIt != mAttributeReverseMap.end())
            aResult = aIt->second;
        break;
    default:
        break;
    }
        
    return aResult;
}
}
