/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: slidvish.cxx,v $
 *
 *  $Revision: 1.61.32.1 $
 *
 *  last change: $Author: kz $ $Date: 2008/01/18 10:11:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"
#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#include "SlideViewShell.hxx"

#include "ViewShellImplementation.hxx"

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _ZOOMITEM_HXX
#include <svx/zoomitem.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SD_OPTSITEM_HXX
#include "optsitem.hxx"
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
#include <sfx2/topfrm.hxx>
#endif

#include <sfx2/objface.hxx>

#include "app.hrc"
#include "strings.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"

#include "drawdoc.hxx"
#include "DrawDocShell.hxx"
#ifndef SD_PRESENTATION_VIEW_SHELL_HXX
#include "PresentationViewShell.hxx"
#endif
#ifndef SD_WINDOW_HXX
#include "Window.hxx"
#endif
#ifndef SD_FU_POOR_HXX
#include "fupoor.hxx"
#endif
#ifndef SD_FU_ZOOM_HXX
#include "fuzoom.hxx"
#endif
#ifndef SD_FU_SCALE_HXX
#include "fuscale.hxx"
#endif
#ifndef SD_FU_SLIDE_SELECTION_HXX
#include "fuslsel.hxx"
#endif
#ifndef _SD_SLIDESHOW_HXX
#include "slideshow.hxx"
#endif
#ifndef SD_FU_SLIDE_HIDE_HXX
#include "fuslhide.hxx"
#endif
#ifndef SD_FU_SLIDE_SHOW_DLG_HXX
#include "fusldlg.hxx"
#endif
#include "sdpage.hxx"
#include "pres.hxx"
#ifndef SD_FRAME_VIEW
#include "FrameView.hxx"
#endif
#include "sdresid.hxx"
#include "sdattr.hxx"
#include "diactrl.hxx"
#include "zoomlist.hxx"
#ifndef SD_FU_EXPAND_PAGE_HXX
#include "fuexpand.hxx"
#endif
#ifndef SD_FU_SUMMARY_PAGE_HXX
#include "fusumry.hxx"
#endif
#ifndef SD_FU_CUSTOM_SHOW_DLG_HXX
#include "fucushow.hxx"
#endif
#include "sdxfer.hxx"
#ifndef SD_ACCESSIBILITY_ACCESSIBLE_SLIDE_VIEW_HXX
#include "AccessibleSlideView.hxx"
#endif
#ifndef SD_UNO_SLIDE_VIEW_HXX
#include "SdUnoSlideView.hxx"
#endif
#ifndef SD_VIEW_SHELL_BASE_HXX
#include "ViewShellBase.hxx"
#endif
#include "framework/FrameworkHelper.hxx"

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

// MBA: never declare "using namespace" for css and drafts::css in one file!
// always use subnamespace or directly declare the single types
using namespace ::com::sun::star::accessibility;

// Using the namespace sd here is necessary for compiling sdslots.hxx
// outside the namespace sd block that comes a few lines below.
using namespace sd;
#define SlideViewShell
#include "sdslots.hxx"

namespace sd {

SFX_DECL_TYPE(13);


#define MIN_ZOOM	       10       // Minimaler Zoomfaktor
#define MAX_ZOOM	       68	    // Maximaler Zoomfaktor


SFX_IMPL_INTERFACE(SlideViewShell, SfxShell, SdResId(STR_SLIDEVIEWSHELL))
{
    SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_APPLICATION | SFX_VISIBILITY_DESKTOP | SFX_VISIBILITY_STANDARD | SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_VIEWER | SFX_VISIBILITY_READONLYDOC,
            					SdResId(RID_DRAW_VIEWER_TOOLBOX) );
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
								SdResId(RID_SLIDE_TOOLBOX) );
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_SLIDE_OBJ_TOOLBOX) );
}


TYPEINIT1( SlideViewShell, ViewShell );

// --------------------
// - SlideViewShell -
// --------------------

void SlideViewShell::Construct(SdDrawDocument* pDoc)
{
    nCurFocusPage = SDRPAGE_NOTFOUND;
	pSlideView = new SlideView(pDoc, GetActiveWindow(), this);
	mpView = pSlideView; 		  // Pointer der Basisklasse ViewShell
    meShellType = ST_SLIDE;

	GetActiveWindow()->SetMinZoom( MIN_ZOOM );
	GetActiveWindow()->SetMaxZoom( MAX_ZOOM );

	ReadFrameViewData(mpFrameView);

	SetPool( &pDoc->GetPool() );

	SetUndoManager( pDoc->GetDocSh()->GetUndoManager() );

	SetZoom(100);

	USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
	USHORT nPagesPerRow = pSlideView->GetPagesPerRow();
	Size   aPageSize	= pSlideView->GetPageArea(0).GetSize();
	ULONG  nGapX		= pSlideView->GetPageGap();
	ULONG  nGapY		= nGapX;

	Size aViewSize(nPagesPerRow * aPageSize.Width() +
				   (nPagesPerRow + 1) * nGapX,
				   pSlideView->CalcPagePos(nNoOfPages-1).Y() +
				   aPageSize.Height() + nGapY);
	Point aWinPos (0, 0);
	Point aViewOrigin(0, 0);

	InitWindows(aViewOrigin, aViewSize, aWinPos);

	String aName( RTL_CONSTASCII_USTRINGPARAM( "SlideViewShell" ));
	SetName (aName);

	SetHelpId( SD_IF_SDSLIDEVIEWSHELL );
	GetActiveWindow()->SetHelpId( SD_IF_SDSLIDEVIEWSHELL );
	GetActiveWindow()->SetUniqueId( SD_IF_SDSLIDEVIEWSHELL );
}

//-----------------------------------------------------------------------------

SlideViewShell::SlideViewShell(
    SfxViewFrame* pFrame,
    ViewShellBase& rViewShellBase,
    ::Window* pParentWindow,
    FrameView* pFrameViewArgument)
    : ViewShell (pFrame, pParentWindow, rViewShellBase),
      bSetInitialZoomFactor(TRUE),
      bInitializeWinPos(TRUE)
{
	if (pFrameViewArgument != NULL)
		mpFrameView = pFrameViewArgument;
	else
        mpFrameView = new FrameView(GetDoc());

	mpFrameView->Connect();

	Construct(GetDoc());

	// Selektionsfunktion starten
	SfxRequest aReq(SID_OBJECT_SELECT, 0, GetDoc()->GetItemPool());
	FuPermanent(aReq);
}

// -----------------------------------------------------------------------------

SlideViewShell::SlideViewShell (
    SfxViewFrame* pFrame,
    ::Window* pParentWindow,
    const SlideViewShell& rShell)
    : ViewShell (pFrame, pParentWindow, rShell),
      bInitializeWinPos(TRUE)
{
	mpFrameView = new FrameView(GetDoc());
	mpFrameView->Connect();

	Construct(GetDoc());
}

// -----------------------------------------------------------------------------

SlideViewShell::~SlideViewShell()
{
	DisposeFunctions();

	SdPage* pTestPage	   = NULL;
	USHORT	nNoOfPages	   = GetDoc()->GetSdPageCount(PK_STANDARD);
	BOOL	bSelectedFound = FALSE;

	for (USHORT nPage = 0; nPage < nNoOfPages; nPage++)
	{
		pTestPage = GetDoc()->GetSdPage(nPage, PK_STANDARD);
		if (pTestPage->IsSelected())
		{
			if (bSelectedFound)
				GetDoc()->SetSelected(pTestPage, FALSE);
			else
				bSelectedFound = TRUE;
		}
	}
	if (!bSelectedFound && nNoOfPages > 0)
	{
		GetDoc()->SetSelected( (SdPage*)GetDoc()->GetSdPage(0, PK_STANDARD), TRUE);
	}

	delete pSlideView;

	mpFrameView->Disconnect();
}

// -----------------------------------------------------------------------------

Size SlideViewShell::GetOptimalSizePixel() const
{
	// erstmal das "optimale" SdWindow berechnen
	USHORT nNoOfPages	= GetDoc()->GetSdPageCount(PK_STANDARD);
	USHORT nPagesPerRow = Min(nNoOfPages, pSlideView->GetPagesPerRow());
	USHORT nRows		= nNoOfPages / nPagesPerRow;
	if (nNoOfPages % nPagesPerRow)
		nRows++;
	Size   aPageSize	= GetDoc()->GetSdPage(0, PK_STANDARD)->GetSize();
	long   nGap 		= pSlideView->GetPageGap();
	long   nWidth		= nPagesPerRow * aPageSize.Width() +
						   (nPagesPerRow + 1) * nGap;
	long   nHeight		= aPageSize.Height();

	// angestrebtes Hoehen-Seiten-Verhaeltnis ist 3 zu 4
	USHORT nVisibleRows = 1;
	while (nVisibleRows < nRows && (4 * nHeight < 3 * nWidth))
	{
		nVisibleRows++;
		nHeight += aPageSize.Height() + nGap;
	}

	Size aResult(nWidth, nHeight);
	aResult = GetActiveWindow()->LogicToPixel(aResult);

	// und jetzt jetzt das Standardgelumpe draufaddieren
	aResult.Width()  += mpVerticalScrollBar->GetSizePixel().Width();
	aResult.Height() += mpHorizontalScrollBar->GetSizePixel().Height();

	return aResult;
}

// -----------------------------------------------------------------------------

void SlideViewShell::Paint(const Rectangle& rRect, ::sd::Window* pWin)
{
	pSlideView->Paint(rRect, pWin);

	if ( GetDocSh()->GetDocShellFunction().is() )
	{
		GetDocSh()->GetDocShellFunction()->Paint(rRect, pWin);
	}

	if(HasCurrentFunction())
	{
		GetCurrentFunction()->Paint(rRect, pWin);
	}
}


void SlideViewShell::ArrangeGUIElements ()
{
    // Retrieve the current size (thickness) of the scroll bars.  That is
    // the width of the vertical and the height of the horizontal scroll
    // bar.
    int nScrollBarSize =
        GetParentWindow()->GetSettings().GetStyleSettings().GetScrollBarSize();
	maScrBarWH = Size (nScrollBarSize, nScrollBarSize);

    ViewShell::ArrangeGUIElements ();

	// initialen Zoomfaktor setzen?
	if (bSetInitialZoomFactor)
	{
		bSetInitialZoomFactor = FALSE;	// nie wieder !!!

		Size	aPageSize	 = pSlideView->GetPageArea(0).GetSize();
		USHORT	nNoOfPages	 = GetDoc()->GetSdPageCount(PK_STANDARD);
		USHORT	nPagesPerRow = Min(nNoOfPages, pSlideView->GetPagesPerRow());
		long	nGapX		 = pSlideView->GetPageGap();
		long	nMinWidth	 = nPagesPerRow * aPageSize.Width() +
							   (nPagesPerRow + 1) * nGapX;
		long	nMinHeight	 = pSlideView->CalcPagePos(0).Y() +
							   pSlideView->GetPageArea(0).GetHeight();

		long nZoomX = GetActiveWindow()->GetOutputSize().Width() * 100 / nMinWidth;
		long nZoomY = GetActiveWindow()->GetOutputSize().Height() * 100 / nMinHeight;

		SetZoom(Min(nZoomX, nZoomY));
		GetActiveWindow()->SetWinViewPos(Point(0,0));
		GetActiveWindow()->UpdateMapOrigin(FALSE);
	}

	// initiale WinPos setzen?
	if (bInitializeWinPos)
	{
		bInitializeWinPos = FALSE;		   // nie wieder

		USHORT nNoOfPages	= GetDoc()->GetSdPageCount(PK_STANDARD);
		USHORT nPagesPerRow = pSlideView->GetPagesPerRow();
		Size   aPageSize	= pSlideView->GetPageArea(0).GetSize();
		ULONG  nGapX		= pSlideView->GetPageGap();
		ULONG  nGapY		= nGapX;

		Size aViewSizeLogic(nPagesPerRow * aPageSize.Width() +
							(nPagesPerRow + 1) * nGapX,
							pSlideView->CalcPagePos(nNoOfPages-1).Y() +
							aPageSize.Height() + nGapY);
		Size aWinSize(GetActiveWindow()->GetOutputSize());
		Point aViewOrigin(0,0);
		Point aWinPos (0,0);

		// die WinPos so positionieren, dass die selektierte Seite auf
		// halber Hoehe  erscheint
		USHORT nSelected = mpFrameView->GetSelectedPage();

        // #96707# Beware, might be a masterpage number and invalid for normal pages
        if ( GetDoc()->GetSdPage( nSelected, PK_STANDARD ) == NULL )
            nSelected = 0;

		long   nY		 = pSlideView->GetPageArea(nSelected).TopLeft().Y();
		nY += aPageSize.Height() / 2;
		aWinPos.Y() = nY -	aWinSize.Height() / 2;

		// falls die sichtbare Flaeche jetzt zu weit oben oder unten liegt,
		// entsprechend korrigieren
		if (aWinPos.Y() < 0)
			aWinPos.Y() = 0;
		else if (aWinPos.Y() + aWinSize.Height() > aViewSizeLogic.Height())
			aWinPos.Y() = aViewSizeLogic.Height() - aWinSize.Height();

		InitWindows(Point(0,0), aViewSizeLogic, aWinPos);
		SetZoomRect(Rectangle(aWinPos, aWinSize));
	}
}

// -----------------------------------------------------------------------------

void SlideViewShell::ExecCtrl(SfxRequest &rReq)
{
	USHORT nSlot = rReq.GetSlot();
	switch ( nSlot )
	{
		case SID_RELOAD:
		{
			// Undo-Manager leeren
			GetDocSh()->ClearUndoBuffer();

			// Normale Weiterleitung an ViewFrame zur Ausfuehrung
			GetViewFrame()->ExecuteSlot(rReq);

			// Muss sofort beendet werden
			return;
		}

		case SID_OUTPUT_QUALITY_COLOR:
		case SID_OUTPUT_QUALITY_GRAYSCALE:
		case SID_OUTPUT_QUALITY_BLACKWHITE:
		case SID_OUTPUT_QUALITY_CONTRAST:
		{
            // flush page cache
            pSlideView->UpdateAllPages();
            ExecReq( rReq );
			break;
		}

		case SID_MAIL_SCROLLBODY_PAGEDOWN:
		{
            ExecReq( rReq );
			break;
		}

		case SID_OPT_LOCALE_CHANGED:
		{
			pSlideView->UpdateAllPages();
			rReq.Done();
            break;
		}

		default:
		break;
	}
}

// -----------------------------------------------------------------------------

void SlideViewShell::GetCtrlState(SfxItemSet &rSet)
{
	if (rSet.GetItemState(SID_RELOAD) != SFX_ITEM_UNKNOWN)
	{
        GetViewFrame()->GetSlotState (SID_RELOAD, NULL, &rSet);
	}

    // output quality
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_COLOR ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_GRAYSCALE ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_BLACKWHITE ) ||
        SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_CONTRAST ) )
	{
		ULONG   nMode = GetActiveWindow()->GetDrawMode();
		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_COLOR, (BOOL)(OUTPUT_DRAWMODE_COLOR == nMode) ) );
		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_GRAYSCALE, (BOOL)(OUTPUT_DRAWMODE_GRAYSCALE == nMode) ) );
		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_BLACKWHITE, (BOOL)((ULONG)OUTPUT_DRAWMODE_BLACKWHITE == nMode) ) );
		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_CONTRAST, (BOOL)(OUTPUT_DRAWMODE_CONTRAST == nMode) ) );
	}

	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_MAIL_SCROLLBODY_PAGEDOWN) )
	{
		rSet.Put( SfxBoolItem( SID_MAIL_SCROLLBODY_PAGEDOWN, TRUE ) );
	}
}

// -----------------------------------------------------------------------------

void SlideViewShell::FuSupport(SfxRequest &rReq)
{
	if( rReq.GetSlot() == SID_STYLE_FAMILY && rReq.GetArgs())
		GetDocSh()->SetStyleFamily(((SfxUInt16Item&)rReq.GetArgs()->Get( SID_STYLE_FAMILY )).GetValue());

	switch ( rReq.GetSlot() )
	{
		case SID_CUT:
		{
			if(HasCurrentFunction())
			{
				GetCurrentFunction()->DoCut();
			}
			else if (pSlideView)
			{
				pSlideView->DoCut();
			}
			rReq.Done();
		}
		break;

		case SID_COPY:
		{
			if(HasCurrentFunction())
			{
				GetCurrentFunction()->DoCopy();
			}
			else if (pSlideView)
			{
				pSlideView->DoCopy();
			}
			rReq.Done();
		}
		break;

		case SID_PASTE:
		{
			if(HasCurrentFunction())
			{
				GetCurrentFunction()->DoPaste();
			}
			else if (pSlideView)
			{
				pSlideView->DoPaste();
			}

			Rectangle	aZoomRect, aFullRect;
			SdPage* 	pPage;
			USHORT		nPageCnt = GetDoc()->GetSdPageCount(PK_STANDARD);
			USHORT		nPageNum = 0;
			BOOL		bHasSelection = FALSE;

			while( nPageNum < nPageCnt )
			{
			    const Rectangle aRect( pSlideView->GetPageArea( nPageNum ) );

				pPage = GetDoc()->GetSdPage(nPageNum, PK_STANDARD);

				if( pPage->IsSelected() )
				{
					bHasSelection = TRUE;
					aZoomRect.Union(aRect);
					if ( rReq.GetSlot() == SID_SIZE_PAGE )
						break;
				}

				aFullRect.Union(aRect);
				nPageNum++;
			}

            if( !bHasSelection )
				aZoomRect = aFullRect;

			// Sichtbarer Bereich
			Size aVisSizePixel( GetActiveWindow()->GetOutputSizePixel() );
			Rectangle aVisArea( GetActiveWindow()->PixelToLogic(Rectangle(Point(0,0), aVisSizePixel)) );
			Size aVisAreaSize( aVisArea.GetSize() );

			if ( !aVisArea.IsInside( aZoomRect ) )
			{
				// Objekt liegt nicht komplett im sichtbaren Bereich
				Size aLogicSize( aZoomRect.GetSize() );

				if (aLogicSize.Height() > aVisAreaSize.Height() ||
					aLogicSize.Width() > aVisAreaSize.Width())
				{
					// Objekt passt nicht in sichtbaren Bereich -> auf Objektgroesse zoomen
					SetZoomRect( aZoomRect );
				}
				else
				{
					// Objekt in sichtbaren Bereich scrollen
					Point aPos = aVisArea.TopLeft() + aZoomRect.Center() - aVisArea.Center();
					aVisArea.SetPos( aPos );
					SetZoomRect( aVisArea );
				}
			}

			Invalidate( SID_ATTR_ZOOM );
			rReq.Done();
		}
		break;

        case SID_DRAWINGMODE:
		case SID_NOTESMODE:
		case SID_HANDOUTMODE:
		case SID_DIAMODE:
		case SID_OUTLINEMODE:
            framework::FrameworkHelper::Instance(GetViewShellBase())->HandleModeChangeSlot (
                rReq.GetSlot(),
                rReq);
			rReq.Done();
            break;

		case SID_ZOOM_PREV:
		{
			if (mpZoomList->IsPreviousPossible())
			{
				// Vorheriges ZoomRect einstellen
				SetZoomRect(mpZoomList->GetPreviousZoomRect());
			}
			rReq.Done ();
		}
		break;

		case SID_ZOOM_NEXT:
		{
			if (mpZoomList->IsNextPossible())
			{
				// Naechstes ZoomRect einstellen
				SetZoomRect(mpZoomList->GetNextZoomRect());
			}
			rReq.Done ();
		}
		break;

		// #96090# added Undo/Redo handling
		case SID_UNDO :
		{
			ImpSidUndo(FALSE, rReq);
		}
		break;
		case SID_REDO :
		{
			ImpSidRedo(FALSE, rReq);
		}
		break;

		default:
		break;
	}

	Invalidate(SID_CUT);
	Invalidate(SID_COPY);
	Invalidate(SID_PASTE);
}

// -----------------------------------------------------------------------------

void SlideViewShell::FuTemporary(SfxRequest& rReq)
{
	DeactivateCurrentFunction();

	switch( rReq.GetSlot() )
	{
		case SID_PRESENTATION:
		case SID_REHEARSE_TIMINGS:
		{
            SFX_REQUEST_ARG( rReq, pFullScreen, SfxBoolItem, ATTR_PRESENT_FULLSCREEN, FALSE );
            const BOOL bFullScreen = ( ( SID_REHEARSE_TIMINGS != rReq.GetSlot() ) && pFullScreen ) ? pFullScreen->GetValue() : GetDoc()->getPresentationSettings().mbFullScreen;

            if( bFullScreen )
            {
                PresentationViewShell::CreateFullScreenShow( this, rReq );
			    Cancel();
            }
            else
            {
			    mpFrameView->SetPresentationViewShellId (SID_VIEWSHELL1);
			    mpFrameView->SetSlotId (rReq.GetSlot());
                mpFrameView->SetPreviousViewShellType (GetShellType());

                // Switch to an Impress view shell which shows the
                // presentation in a window.  Switching to a presentation
                // view shell is an error here, because that would not
                // return to us (re-create us).
                framework::FrameworkHelper::Instance(GetViewShellBase())->RequestView(
                    framework::FrameworkHelper::msImpressViewURL,
                    framework::FrameworkHelper::msCenterPaneURL);
            }

			rReq.Done();
		}
		break;

		case SID_HIDE_SLIDE:
		{
			SetCurrentFunction( FuSlideHide::Create(this,GetActiveWindow(),pSlideView,GetDoc(),rReq) );
			Cancel();
		}
		break;

		case SID_ATTR_ZOOM:
		{
			const SfxItemSet* pArgs = rReq.GetArgs();

			if ( pArgs )
			{
				SvxZoomType eZT = ( ( const SvxZoomItem& ) pArgs->
											Get( SID_ATTR_ZOOM ) ).GetType();
				switch( eZT )
				{
					case SVX_ZOOM_PERCENT:
						SetZoom( (long) ( ( const SvxZoomItem& ) pArgs->
											Get( SID_ATTR_ZOOM ) ).GetValue() );
						break;

					/*
					case SVX_ZOOM_OPTIMAL:
						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_ALL,
									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
						break;

					case SVX_ZOOM_PAGEWIDTH:
						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE_WIDTH,
									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
						break;
					*/
					case SVX_ZOOM_WHOLEPAGE:
						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE,
									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
						break;
					default:
						break;
				}
				Invalidate( SID_ATTR_ZOOM );
				rReq.Done();
			}
			else
			{
				// hier den Zoom-Dialog oeffnen
				SetCurrentFunction( FuScale::Create( this, GetActiveWindow(), pSlideView, GetDoc(), rReq ) );
			}
			Cancel();
		}
		break;

		case SID_ZOOM_OUT:
		{
			SetCurrentFunction( FuZoom::Create(this, GetActiveWindow(), pSlideView, GetDoc(), rReq) );
			// Beendet sich selbst, kein Cancel() notwendig!
			rReq.Done();
		}
		break;

		case SID_SIZE_REAL:
		{
			SetZoom( 100 );
			Rectangle aVisAreaWin = GetActiveWindow()->PixelToLogic( Rectangle( Point(0,0),
											 GetActiveWindow()->GetOutputSizePixel()) );
			mpZoomList->InsertZoomRect(aVisAreaWin);
			Invalidate( SID_ATTR_ZOOM );
			Invalidate( SID_ZOOM_OUT);
			Invalidate( SID_ZOOM_IN );
			Invalidate( SID_SIZE_REAL );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_ZOOM_IN:
		{
			SetZoom( Max( (long) ( GetActiveWindow()->GetZoom() / 2 ), (long) GetActiveWindow()->GetMinZoom() ) );
			Rectangle aVisAreaWin = GetActiveWindow()->PixelToLogic( Rectangle( Point(0,0),
											 GetActiveWindow()->GetOutputSizePixel()) );
			mpZoomList->InsertZoomRect(aVisAreaWin);
			Invalidate( SID_ATTR_ZOOM );
			Invalidate( SID_ZOOM_OUT);
			Invalidate( SID_ZOOM_IN );
			Invalidate( SID_SIZE_REAL );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_SIZE_ALL:
		case SID_SIZE_PAGE:
		{
			Rectangle	aZoomRect, aFullRect;
			SdPage* 	pPage;
			USHORT		nPageCnt = GetDoc()->GetSdPageCount(PK_STANDARD);
			USHORT		nPageNum = 0;
			BOOL		bHasSelection = FALSE;

			while ( nPageNum < nPageCnt )
			{
				const Rectangle aRect( pSlideView->GetPageArea( nPageNum ) );

                pPage = GetDoc()->GetSdPage( nPageNum, PK_STANDARD );

				if( pPage->IsSelected() )
				{
					bHasSelection = TRUE;
					aZoomRect.Union( aRect );

                    if( rReq.GetSlot() == SID_SIZE_PAGE )
						break;
				}

                aFullRect.Union( aRect );
				nPageNum++;
			}

            if ( !bHasSelection )
				aZoomRect = aFullRect;

			if ( !aZoomRect.IsEmpty() )
			{
				Point aPagePos = aZoomRect.Center();
				Size aPageSize = aZoomRect.GetSize();
				aPageSize.Width()  = aPageSize.Width()	* 11 / 10;
				aPageSize.Height() = aPageSize.Height() * 11 / 10;
				aPagePos.X() -= aPageSize.Width() / 2;
				aPagePos.Y() -= aPageSize.Height() / 2;

				SetZoomRect( Rectangle(aPagePos, aPageSize) );

				Rectangle aVisAreaWin = GetActiveWindow()->PixelToLogic( Rectangle( Point(0,0),
											 GetActiveWindow()->GetOutputSizePixel()) );
				mpZoomList->InsertZoomRect(aVisAreaWin);
			}
			Invalidate( SID_ATTR_ZOOM );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_PAGES_PER_ROW:
		{
			if( rReq.GetArgs() )
			{
				SFX_REQUEST_ARG( rReq, pPagesPerRow, SfxUInt16Item, SID_PAGES_PER_ROW, FALSE);

				if( pPagesPerRow )
				{
					SetPagesPerRow( pPagesPerRow->GetValue() );
					Invalidate( SID_ATTR_ZOOM );
				}
			}
			Cancel();
			rReq.Done();
			break;
		}

		case SID_SELECTALL:
		{
            pSlideView->SelectAllSlides( TRUE );
			Cancel();
			rReq.Done();
		}
		break;

		case SID_SLIDE_TRANSITIONS_PANEL:
		{
			Cancel();
			rReq.Ignore ();
		}
		break;

		case SID_PRESENTATION_DLG:
		{
			SetCurrentFunction( FuSlideShowDlg::Create( this, GetActiveWindow(), pSlideView, GetDoc(), rReq ) );
			Cancel();
		}
		break;

		case SID_CUSTOMSHOW_DLG:
		{
			SetCurrentFunction( FuCustomShowDlg::Create( this, GetActiveWindow(), pSlideView, GetDoc(), rReq ) );
			Cancel();
		}
		break;

		case SID_EXPAND_PAGE:
		{
			SetCurrentFunction( FuExpandPage::Create( this, GetActiveWindow(), pSlideView, GetDoc(), rReq ) );
			Cancel();
		}
		break;

		case SID_SUMMARY_PAGE:
		{
			SetCurrentFunction( FuSummaryPage::Create( this, GetActiveWindow(), pSlideView, GetDoc(), rReq ) );
			Cancel();
		}
		break;

		case SID_DELETE_PAGE:
		{
			if (GetDoc()->GetSdPageCount(PK_STANDARD) > 1)
			{
				pSlideView->DeleteMarked();
			}

			Cancel();
			rReq.Done();
		}
		break;

		default:
		break;
	}

	if(HasCurrentFunction())
	{
		GetCurrentFunction()->Activate();
	}

	Invalidate(SID_CUT);
	Invalidate(SID_COPY);
	Invalidate(SID_PASTE);
}

// -----------------------------------------------------------------------------

void SlideViewShell::FuPermanent(SfxRequest &rReq)
{
	if(HasCurrentFunction())
	{
		DeactivateCurrentFunction(true);
	}

	switch ( rReq.GetSlot() )
	{
		case SID_OBJECT_SELECT:
		{
			SetCurrentFunction( FuSlideSelection::Create( this, GetActiveWindow(), pSlideView, GetDoc(), rReq ) );
			rReq.Done();
		}
		break;

		default:
		break;
	}

	if(HasOldFunction())
	{
		GetOldFunction()->Deactivate();
		SetOldFunction(0);
	}

	if(HasCurrentFunction())
	{
		GetCurrentFunction()->Activate();
		SetOldFunction( GetCurrentFunction() );
	}

	//! das ist nur bis das ENUM-Slots sind
	Invalidate( SID_OBJECT_SELECT );
}

// -----------------------------------------------------------------------------

void SlideViewShell::GetMenuState( SfxItemSet &rSet )
{
	ViewShell::GetMenuState(rSet);

	if( HasCurrentFunction() )
	{
		USHORT nSId = GetCurrentFunction()->GetSlotID();

		rSet.Put( SfxBoolItem( nSId, TRUE ) );
	}
	rSet.Put( SfxBoolItem( SID_DRAWINGMODE, FALSE ) );
	rSet.Put( SfxBoolItem( SID_DIAMODE, TRUE ) );
	rSet.Put( SfxBoolItem( SID_OUTLINEMODE, FALSE ) );
	rSet.Put( SfxBoolItem( SID_NOTESMODE, FALSE ) );
	rSet.Put( SfxBoolItem( SID_HANDOUTMODE, FALSE ) );

	// Vorlagenkatalog darf nicht aufgerufen werden
	rSet.DisableItem( SID_STYLE_CATALOG );
	rSet.DisableItem(SID_SIZE_ALL);
	rSet.DisableItem(SID_SPELL_DIALOG);
	rSet.DisableItem(SID_SEARCH_DLG);
	rSet.DisableItem(SID_HANGUL_HANJA_CONVERSION);

	if (!mpZoomList->IsNextPossible())
	{
	   rSet.DisableItem(SID_ZOOM_NEXT);
	}
	if (!mpZoomList->IsPreviousPossible())
	{
	   rSet.DisableItem(SID_ZOOM_PREV);
	}

	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_IN ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_OUT ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SIZE_REAL ) )
	{
		BOOL bUIActive = GetDocSh()->IsUIActive();

		if( GetActiveWindow()->GetZoom() <= GetActiveWindow()->GetMinZoom() || bUIActive )
			rSet.DisableItem( SID_ZOOM_IN );
		if( GetActiveWindow()->GetZoom() >= GetActiveWindow()->GetMaxZoom() || bUIActive )
			rSet.DisableItem( SID_ZOOM_OUT );
		if( 100 >= GetActiveWindow()->GetMaxZoom() || bUIActive )
			rSet.DisableItem( SID_SIZE_REAL );
	}

	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_EXPAND_PAGE))
	{
		BOOL bDisable = TRUE;
		USHORT i = 0;
		USHORT nCount = GetDoc()->GetSdPageCount(PK_STANDARD);

		while (i < nCount && bDisable)
		{
			SdPage* pPage = GetDoc()->GetSdPage(i, PK_STANDARD);

			if (pPage->IsSelected())
			{
				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_OUTLINE);

				if (pObj && !pObj->IsEmptyPresObj())
				{
					bDisable = FALSE;
				}
			}

			i++;
		}

		if (bDisable)
		{
			rSet.DisableItem(SID_EXPAND_PAGE);
		}
	}

	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_SUMMARY_PAGE))
	{
		BOOL bDisable = TRUE;
		USHORT i = 0;
		USHORT nCount = GetDoc()->GetSdPageCount(PK_STANDARD);

		while (i < nCount && bDisable)
		{
			SdPage* pPage = GetDoc()->GetSdPage(i, PK_STANDARD);

			if (pPage->IsSelected())
			{
				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_TITLE);

				if (pObj && !pObj->IsEmptyPresObj())
				{
					bDisable = FALSE;
				}
			}

			i++;
		}

		if (bDisable)
		{
			rSet.DisableItem(SID_SUMMARY_PAGE);
		}
	}

	// Starten der Praesentation moeglich?
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_REHEARSE_TIMINGS ) )
	{
		BOOL bDisable = TRUE;
		USHORT nCount = GetDoc()->GetSdPageCount( PK_STANDARD );

		for( USHORT i = 0; i < nCount && bDisable; i++ )
		{
			SdPage* pPage = GetDoc()->GetSdPage(i, PK_STANDARD);

			if( !pPage->IsExcluded() )
				bDisable = FALSE;
		}
		if( bDisable || GetDocSh()->IsPreview())
		{
			rSet.DisableItem( SID_PRESENTATION );
			rSet.DisableItem( SID_REHEARSE_TIMINGS );
		}
	}

	SdTransferable* pTransferClip = SD_MOD()->pTransferClip;

	// Keine eigenen Clipboard-Daten?
	if ( !pTransferClip || !pTransferClip->GetDocShell() )
    {
		rSet.DisableItem(SID_PASTE);
    }
	else
	{
        SfxObjectShell* pObj = pTransferClip->GetDocShell();
		if( !pObj || ( (DrawDocShell*) pObj)->GetDoc()->GetPageCount() <= 1 )
        {
			// Eigene Clipboard-Daten haben nur eine Seite
            rSet.DisableItem(SID_PASTE);
        }
	}

	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_CUT)  ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_COPY) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_DELETE_PAGE))
	{
		BOOL bDisable = TRUE;
		USHORT i = 0;
		USHORT nCount = GetDoc()->GetSdPageCount(PK_STANDARD);

		while (i < nCount && bDisable)
		{
			SdPage* pPage = GetDoc()->GetSdPage(i, PK_STANDARD);

			if (pPage->IsSelected())
			{
				bDisable = FALSE;
			}

			i++;
		}

		if (bDisable)
		{
			rSet.DisableItem(SID_CUT);
			rSet.DisableItem(SID_CUT);
			rSet.DisableItem(SID_DELETE_PAGE);
		}
		else if (GetDoc()->GetSdPageCount(PK_STANDARD) < 2)
		{
			rSet.DisableItem(SID_CUT);
			rSet.DisableItem(SID_DELETE_PAGE);
		}
	}

	//rSet.DisableItem( SID_PRINTDOC );
	//rSet.DisableItem( SID_PRINTDOCDIRECT );
	//rSet.DisableItem( SID_SETUPPRINTER );
}

// -----------------------------------------------------------------------------

void SlideViewShell::GetAttrState( SfxItemSet &rSet )
{
	SfxWhichIter	aIter( rSet );
	USHORT			nWhich = aIter.FirstWhich();
/*
	SdPage* pPage	   = NULL;
	USHORT	nNoOfPages = GetDoc()->GetSdPageCount(PK_STANDARD);
	USHORT	nPage;
*/

	while ( nWhich )
	{
		USHORT nSlotId = SfxItemPool::IsWhich(nWhich)
			? GetPool().GetSlotId(nWhich)
			: nWhich;
		switch ( nSlotId )
		{

			case SID_PAGES_PER_ROW:
				rSet.Put( SfxUInt16Item( nSlotId, pSlideView->GetPagesPerRow() ) );
			break;
		}
		nWhich = aIter.NextWhich();
	}
}

// -----------------------------------------------------------------------------

BOOL SlideViewShell::KeyInput(const KeyEvent& rKEvt, ::sd::Window* pWin)
{
	BOOL bReturn = FALSE;

	// vom ShowWindow der DiaShow?
	if (pWin == NULL && HasCurrentFunction())
	{
		bReturn = GetCurrentFunction()->KeyInput(rKEvt);
	}

	// nein, weiterleiten an Basisklasse
	else
	{
		bReturn = ViewShell::KeyInput(rKEvt, pWin);
	}

	return(bReturn);
}

// -----------------------------------------------------------------------------

void SlideViewShell::MouseButtonDown(const MouseEvent& rMEvt, ::sd::Window* pWin)
{
	// vom ShowWindow der DiaShow?
	if (pWin == NULL && HasCurrentFunction())
	{
		GetCurrentFunction()->MouseButtonDown(rMEvt);
	}
	ViewShell::MouseButtonDown(rMEvt, pWin);
}

// -----------------------------------------------------------------------------

void SlideViewShell::MouseMove(const MouseEvent& rMEvt, ::sd::Window* pWin)
{
	// vom ShowWindow der DiaShow?
	if (pWin == NULL && HasCurrentFunction())
	{
		GetCurrentFunction()->MouseMove(rMEvt);
	}

	// nein, weiterleiten an Basisklasse (wenn nicht Readonly)
	else if( !GetDocSh()->IsReadOnly() )
	{
		ViewShell::MouseMove(rMEvt, pWin);
	}
}

// -----------------------------------------------------------------------------

void SlideViewShell::MouseButtonUp(const MouseEvent& rMEvt, ::sd::Window* pWin)
{
	// vom ShowWindow der DiaShow?
	if (pWin == NULL && HasCurrentFunction())
	{
		GetCurrentFunction()->MouseButtonUp(rMEvt);
	}

	// nein, weiterleiten an Basisklasse
	else
	{
		ViewShell::MouseButtonUp(rMEvt, pWin);
	}
}

// -----------------------------------------------------------------------------

void SlideViewShell::Command(const CommandEvent& rCEvt, ::sd::Window* pWin)
{
	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
	{
		SdPage* pPage	   = NULL;
		USHORT	nNoOfPages = GetDoc()->GetSdPageCount(PK_STANDARD);
		USHORT	nPage;
		BOOL	bFound = FALSE;
		USHORT	nPopupId = RID_SLIDE_SORTER_IMPRESS_NOSEL_POPUP;

		for( nPage = 0; nPage < nNoOfPages && !bFound; nPage++ )
		{
			pPage = GetDoc()->GetSdPage( nPage, PK_STANDARD );
			if( pPage->IsSelected() )
			{
				nPopupId = RID_SLIDE_SORTER_IMPRESS_SEL_POPUP;
				bFound = TRUE;
			}
		}

		GetActiveWindow()->ReleaseMouse();
		GetViewFrame()->GetDispatcher()->ExecutePopup( SdResId( nPopupId ) );
	}
	else
	{
		ViewShell::Command(rCEvt, pWin);
	}
}




void SlideViewShell::ReadFrameViewData(FrameView* pFrameView)
{
	pSlideView->ChangePagesPerRow(pFrameView->GetSlidesPerRow());

	// DrawMode for 'main' window
	if( GetActiveWindow()->GetDrawMode() != pFrameView->GetDrawMode() )
	  GetActiveWindow()->SetDrawMode( pFrameView->GetDrawMode() );
}

// -----------------------------------------------------------------------------

void SlideViewShell::WriteFrameViewData()
{
	mpFrameView->SetSlidesPerRow(pSlideView->GetPagesPerRow());

	// DrawMode for 'main' window
	if( mpFrameView->GetDrawMode() != GetActiveWindow()->GetDrawMode() )
	  mpFrameView->SetDrawMode( GetActiveWindow()->GetDrawMode() );

	SdPage* pActualPage = GetActualPage();

	if( pActualPage )
        mpFrameView->SetSelectedPage( ( pActualPage->GetPageNum() - 1 ) / 2 );
}

// -----------------------------------------------------------------------------

void SlideViewShell::ExecStatusBar(SfxRequest& )
{
}

// -----------------------------------------------------------------------------

void SlideViewShell::GetStatusBarState(SfxItemSet& rSet)
{
	// Zoom-Item
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ATTR_ZOOM ) )
	{
		SvxZoomItem* pZoomItem;
		UINT16 nZoom = (UINT16) GetActiveWindow()->GetZoom();

		pZoomItem = new SvxZoomItem( SVX_ZOOM_PERCENT, nZoom );

		// Bereich einschraenken
		USHORT nZoomValues = SVX_ZOOM_ENABLE_ALL;
		nZoomValues &= ~SVX_ZOOM_ENABLE_OPTIMAL;
		nZoomValues &= ~SVX_ZOOM_ENABLE_PAGEWIDTH;
		nZoomValues &= ~(SVX_ZOOM_ENABLE_100|SVX_ZOOM_ENABLE_150|SVX_ZOOM_ENABLE_200);

		pZoomItem->SetValueSet( nZoomValues );
		rSet.Put( *pZoomItem );
		delete pZoomItem;
	}

	// Seitenanzeige und Layout
	/*
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_PAGE ) ||
		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_LAYOUT ) )
	*/
	SdPage* pPage	   = NULL;
	SdPage* pFirstPage = NULL;
	USHORT	nPageCount = GetDoc()->GetSdPageCount( PK_STANDARD );
	USHORT	nPage, nFirstPage = 0;
	USHORT	nSelectedPages = 0;
	String	aPageStr, aLayoutStr;

	for( nPage = 0; nPage < nPageCount; nPage++ )
	{
		pPage = GetDoc()->GetSdPage( nPage, PK_STANDARD );
		if( pPage->IsSelected() )
		{
			if( ++nSelectedPages > 1 )
				break;
			else
			{
				nFirstPage = nPage;
				pFirstPage = pPage;
			}
		}
	}

	if( nSelectedPages == 1 )
	{
		aPageStr = String(SdResId( STR_SD_PAGE ));
		aPageStr += sal_Unicode(' ');
		aPageStr += String::CreateFromInt32( nFirstPage + 1 );
		aPageStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " / " ));
		aPageStr += String::CreateFromInt32( (sal_Int32)nPageCount );

		aLayoutStr = pFirstPage->GetLayoutName();
		aLayoutStr.Erase( aLayoutStr.SearchAscii( SD_LT_SEPARATOR ) );
	}
	rSet.Put( SfxStringItem( SID_STATUS_PAGE, aPageStr ) );
	rSet.Put( SfxStringItem( SID_STATUS_LAYOUT, aLayoutStr ) );
}

// -----------------------------------------------------------------------------
 
void SlideViewShell::SetZoom(long nZoom)
{
	Fraction aFrac(GetActiveWindow()->GetMapMode().GetScaleX());
	long	 nCurrentZoom = aFrac.GetNumerator() * 100 /
							aFrac.GetDenominator();

	if (nZoom > nCurrentZoom)
	{
		Size aPageSize(pSlideView->GetPageArea(0).GetSize());
		Size aWinSize(GetActiveWindow()->PixelToLogic(GetActiveWindow()->GetOutputSizePixel()));



		// der Zoom Factor darf nicht um mehr als um diesen Faktor wachsen
		// (horizontal und vertikal sollten immer gleich skaliert sein)
		long nAllowedFactorFactor = aWinSize.Width() / aPageSize.Width();
		long nMaxFactor 		  = nCurrentZoom * nAllowedFactorFactor;

		nZoom = Min(nMaxFactor, nZoom);
	}

	ViewShell::SetZoom(nZoom);

	// #106268#
	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
}

// -----------------------------------------------------------------------------

void SlideViewShell::SetZoomRect(const Rectangle& rZoomRect)
{
	Size aPageSize(pSlideView->GetPageArea(0).GetSize());

	Rectangle aRect(rZoomRect);

	if (aRect.GetWidth()  < aPageSize.Width())
	{
		long nWidthDiff  = (aPageSize.Width() - aRect.GetWidth()) / 2;

		aRect.Left() -= nWidthDiff;
		aRect.Right() += nWidthDiff;

		if (aRect.Left() < 0)
		{
			aRect.SetPos(Point(0, aRect.Top()));
		}
	}

	if (aRect.GetHeight()  < aPageSize.Height())
	{
		long nHeightDiff  = (aPageSize.Height() - aRect.GetHeight()) / 2;

		aRect.Top() -= nHeightDiff;
		aRect.Bottom() += nHeightDiff;

		if (aRect.Top() < 0)
		{
			aRect.SetPos(Point(aRect.Left(), 0));
		}
	}

	ViewShell::SetZoomRect(aRect);

	// #106268#
	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
}

// -----------------------------------------------------------------------------

void SlideViewShell::DrawSelectionRect( USHORT nPage )
{
	SdPage* pPage = GetDoc()->GetSdPage(nPage, PK_STANDARD);
    if (pPage != NULL)
    {
        Color           aColor;
        Rectangle       aRect( pSlideView->CalcPagePos( nPage ), pPage->GetSize() );

        // Determine the color with which to paint the rectangle.
		svtools::ColorConfig aColorConfig;

		if( pPage->IsSelected() )
		{
            aColor = Color( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
		}
        else
		{
			aColor = Color( aColorConfig.GetColorValue( svtools::APPBACKGROUND ).nColor );
		}

        Window* pWindow = mpContentWindow.get();
        if( pWindow )
        {
            // Set default draw mode to be able to correctly draw the
            // selected (and only that) frame.
            ULONG nPreviousDrawMode = pWindow->GetDrawMode();
            pWindow->SetDrawMode (DRAWMODE_DEFAULT);

            Rectangle   aInner( pWindow->LogicToPixel( aRect ) );
            Rectangle   aOuter( aInner );
            const Color aOldFillColor( pWindow->GetFillColor() );
            const Color aOldLineColor( pWindow->GetLineColor() );

            pWindow->SetFillColor();
            pWindow->SetLineColor( aColor );

            aInner.Left() -= 4; aInner.Top() -= 4; aInner.Right() += 4;	aInner.Bottom() += 4;
            pWindow->DrawRect( pWindow->PixelToLogic( aInner ) );

            aOuter.Left() -= 5; aOuter.Top() -= 5; aOuter.Right() += 5; aOuter.Bottom() += 5;
            pWindow->DrawRect( pWindow->PixelToLogic( aOuter ) );

            pWindow->SetLineColor( aOldLineColor );
            pWindow->SetFillColor( aOldFillColor );

            // Restore the previous draw mode.
            pWindow->SetDrawMode (nPreviousDrawMode);
        }
    }
}

// -----------------------------------------------------------------------------

void SlideViewShell::ImplDrawFocusRect( USHORT nPage, BOOL bVisible )
{
	SdPage*     pPage = GetDoc()->GetSdPage( nPage, PK_STANDARD );
	Rectangle   aRect( pSlideView->CalcPagePos( nPage ), pPage->GetSize() );

    if (mpContentWindow.get() != NULL)
    {
        if( bVisible )
        {
            Rectangle   aInner( mpContentWindow->LogicToPixel( aRect ) );
            const Color aOldFillColor( mpContentWindow->GetFillColor() );

            aInner.Left() -= 3; aInner.Top() -= 3; aInner.Right() += 3;	aInner.Bottom() += 3;

            mpContentWindow->SetFillColor();
            mpContentWindow->ShowFocus( mpContentWindow->PixelToLogic( aInner ) );
            mpContentWindow->SetFillColor( aOldFillColor );
        }
        else
            mpContentWindow->HideFocus();

        mpContentWindow->Flush();
    }
}

// -----------------------------------------------------------------------------

void SlideViewShell::DrawFocusRect( USHORT nPage )
{
    if( ( SDRPAGE_NOTFOUND != nCurFocusPage ) && ( nPage != nCurFocusPage ) )
        ImplDrawFocusRect( nCurFocusPage, FALSE );

    if( SDRPAGE_NOTFOUND != ( nCurFocusPage = nPage ) )
        ImplDrawFocusRect( nCurFocusPage, TRUE );
}

// -----------------------------------------------------------------------------

SdPage* SlideViewShell::getCurrentPage() const
{
	return const_cast<SlideViewShell*>(this)->GetActualPage();
}

// -----------------------------------------------------------------------------

SdPage* SlideViewShell::GetActualPage()
{
	SdPage*  pPage = 0;
	USHORT	nPageCnt = GetDoc()->GetSdPageCount( PK_STANDARD );
	USHORT	nPageNum = 0;

	while( nPageNum < nPageCnt )
	{
		pPage = GetDoc()->GetSdPage( nPageNum, PK_STANDARD );
		if( pPage->IsSelected() )
			break;
		nPageNum++;
	}
	if( pPage && !pPage->IsSelected() )
		pPage = GetDoc()->GetSdPage( 0, PK_STANDARD );

	return( pPage );
}

// -----------------------------------------------------------------------------

String SlideViewShell::GetPageRangeString()
{
	SdPage* pPage      = NULL;
	USHORT	nPageCount = GetDoc()->GetSdPageCount( PK_STANDARD );
	BOOL	bFirst	   = TRUE;
	BOOL	bAll 	   = TRUE;
	String  aString;

	for( USHORT nPage = 0; nPage < nPageCount; nPage++)
	{
		pPage = GetDoc()->GetSdPage( nPage, PK_STANDARD );
		if( pPage->IsSelected() )
		{
			if( !bFirst )
				aString += (sal_Unicode)',';
			aString += String::CreateFromInt32( nPage + 1 );
			bFirst = FALSE;
		}
		else
			bAll = FALSE;
	}
	if( bAll )
		aString.Erase();

	return( aString );
}

// -----------------------------------------------------------------------------

BOOL SlideViewShell::HasSelection(BOOL bText) const
{
	BOOL bReturn = FALSE;

	if (!bText)
	{
		SdPage* pPage;
		USHORT  nPageCnt = GetDoc()->GetSdPageCount( PK_STANDARD );
		USHORT  nPageNum = 0;

		while(nPageNum < nPageCnt && !bReturn)
		{
			pPage = GetDoc()->GetSdPage(nPageNum, PK_STANDARD);

			if (pPage->IsSelected())
			{
				bReturn = TRUE;
			}

			nPageNum++;
		}
	}

	return bReturn;
}

// -----------------------------------------------------------------------------

void SlideViewShell::WriteUserDataSequence ( uno::Sequence < beans::PropertyValue >& rSequence, sal_Bool bBrowse )
{
	WriteFrameViewData();

	ViewShell::WriteUserDataSequence( rSequence, bBrowse );
}

// -----------------------------------------------------------------------------

void SlideViewShell::ReadUserDataSequence ( const uno::Sequence < beans::PropertyValue >& rSequence, sal_Bool bBrowse )
{
	WriteFrameViewData();

	ViewShell::ReadUserDataSequence( rSequence, bBrowse );

	ReadFrameViewData( mpFrameView );

	SetPagesPerRow( mpFrameView->GetSlidesPerRow() );
	Invalidate( SID_ATTR_ZOOM );
}

// -----------------------------------------------------------------------------

void SlideViewShell::SetPagesPerRow( USHORT nPagesPerRow )
{
	// den Wert als maximal erlaubten Wert interpretieren; wenn
	// es weniger Seiten gibt entsprechend einschraenken
	USHORT nNoOfPages = GetDoc()->GetSdPageCount(PK_STANDARD);
	nPagesPerRow = Min(nPagesPerRow, nNoOfPages);

	pSlideView->ChangePagesPerRow(nPagesPerRow);
	
	Size  aPageSize   = pSlideView->GetPageArea(0).GetSize();
	ULONG nGapX 	  = pSlideView->GetPageGap();
	ULONG nVisWidth   = nPagesPerRow * aPageSize.Width() + (nPagesPerRow + 1) * nGapX;

	Size aViewSize (nVisWidth,
						pSlideView->GetPageArea(nNoOfPages - 1).Bottom() + nGapX);

	::sd::Window* pWin = GetActiveWindow();
	Size aWinSize(pWin->GetOutputSize());
	double fRatio = aWinSize.Width() ? ((double)aWinSize.Height()) / aWinSize.Width() : 1;
	ULONG nVisHeight = (ULONG)(nVisWidth * fRatio);
	if (nVisHeight < aPageSize.Height() + 2 * nGapX)
		nVisHeight = aPageSize.Height() + 2 * nGapX;
	Size aVisSize(nVisWidth, nVisHeight);

	InitWindows(Point(), aViewSize, Point());
	SetZoomRect(Rectangle(Point(), aVisSize));
}

// -----------------------------------------------------------------------------

void SlideViewShell::VisAreaChanged(const Rectangle& rRect)
{
	ViewShell::VisAreaChanged( rRect );

    //	if (mpController.is() != NULL)
    //		mpController->FireVisAreaChanged (rRect);
}

// -----------------------------------------------------------------------------

void SlideViewShell::SelectionHasChanged()
{
	Invalidate( SID_EXPAND_PAGE );
	Invalidate( SID_SUMMARY_PAGE );

	// StatusBar
	Invalidate( SID_STATUS_PAGE );
	Invalidate( SID_STATUS_LAYOUT );

    // fire accessible event
    if (mpContentWindow.get() != NULL)
    {
        uno::Reference< XAccessible > xAcc( mpContentWindow->GetAccessible( FALSE ) );

        if( xAcc.is() )
        {
            AccessibleSlideView* pAccView = NULL;//AccessibleSlideView::getImplementation( xAcc );

            if( pAccView )
            {
                const uno::Any aOldAny, aNewAny;
                //                pAccView->FireAccessibleEvent( AccessibleEventId::SELECTION_CHANGED, aOldAny, aNewAny );
            }
        }
    }
}

// -----------------------------------------------------------------------------

void SlideViewShell::FocusHasChanged( USHORT, USHORT )
{
/*
    if (mpContentWindow.get() != NULL )
    {
        uno::Reference< XAccessible > xAcc( mpContentWindow->GetAccessible( FALSE ) );

        if( xAcc.is() )
        {
            //            AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );

            //            if( pAccView )
            //                pAccView->FocusHasChanged( nOldFocusPage, nNewFocusPage );
        }
    }
*/
}

// -----------------------------------------------------------------------------

void SlideViewShell::PageLayoutHasChanged()
{
    const BOOL bFocus = ( SDRPAGE_NOTFOUND != nCurFocusPage );

    if( bFocus )
        ImplDrawFocusRect( nCurFocusPage, FALSE );

    if (mpContentWindow.get() != NULL)
    {
        uno::Reference< XAccessible > xAcc( mpContentWindow->GetAccessible( FALSE ) );

        if( xAcc.is() )
        {
            AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );

            if( pAccView )
                pAccView->Reset();
        }
    }

    if( bFocus )
        ImplDrawFocusRect( nCurFocusPage, TRUE );
}

// -----------------------------------------------------------------------------

void SlideViewShell::PageVisibilityHasChanged( USHORT, BOOL )
{
/*
	if (mpContentWindow.get() != NULL)
    {
        uno::Reference< XAccessible > xAcc( mpContentWindow->GetAccessible( FALSE ) );

        if( xAcc.is() )
        {
			AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );

			if( pAccView )
				pAccView->SetPageVisible( nPage, bVisible );
        }
    }
*/
}

// -----------------------------------------------------------------------------

long SlideViewShell::VirtHScrollHdl(ScrollBar* pHScroll)
{
    const BOOL bFocus = ( SDRPAGE_NOTFOUND != nCurFocusPage );

    if( bFocus )
        ImplDrawFocusRect( nCurFocusPage, FALSE );

    const long nRet = ViewShell::VirtHScrollHdl( pHScroll );

    if( bFocus )
        ImplDrawFocusRect( nCurFocusPage, TRUE );

    return( nRet );
}

// -----------------------------------------------------------------------------

long SlideViewShell::VirtVScrollHdl(ScrollBar* pVScroll)
{
    const BOOL bFocus = ( SDRPAGE_NOTFOUND != nCurFocusPage );

    if( bFocus )
        ImplDrawFocusRect( nCurFocusPage, FALSE );

    const long nRet = ViewShell::VirtVScrollHdl( pVScroll );

    if( bFocus )
        ImplDrawFocusRect( nCurFocusPage, TRUE );

    return( nRet );
}

// -----------------------------------------------------------------------------

uno::Reference< XAccessible> SlideViewShell::CreateAccessibleDocumentView( ::sd::Window* pWindow )
{
    uno::Reference< XAccessible> xRet;

    if( pWindow && !pWindow->GetAccessible( FALSE ).is() )
        xRet = new AccessibleSlideView( *GetDoc(), *pSlideView, *pWindow );

    return( xRet );
}




void SlideViewShell::Activate(BOOL bIsMDIActivate)
{
	ViewShell::Activate( bIsMDIActivate );
}

} //end of namespace sd
