/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.ui.AxisPropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.InsetsChooserPanel;
import com.jrefinery.ui.InsetsTextField;
import com.jrefinery.ui.PaintSample;
import com.jrefinery.ui.StrokeChooserPanel;
import com.jrefinery.ui.StrokeSample;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PlotPropertyEditPanel
extends JPanel
implements ActionListener {
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private AxisPropertyEditPanel domainAxisPropertyPanel;
    private AxisPropertyEditPanel rangeAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private Insets plotInsets;
    private InsetsTextField insetsTextField;

    public PlotPropertyEditPanel(Plot plot) {
        this.plotInsets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + ":"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel jPanel3 = new JPanel((LayoutManager)new LCBLayout(4));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel3.add(new JLabel("Insets:"));
        JButton jButton = new JButton("Edit...");
        jButton.setActionCommand("Insets");
        jButton.addActionListener(this);
        this.insetsTextField = new InsetsTextField(this.plotInsets);
        this.insetsTextField.setEnabled(false);
        jPanel3.add((Component)this.insetsTextField);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Outline stroke:"));
        jButton = new JButton("Select...");
        jButton.setActionCommand("OutlineStroke");
        jButton.addActionListener(this);
        jPanel3.add((Component)this.outlineStrokeSample);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Outline paint:"));
        jButton = new JButton("Select...");
        jButton.setActionCommand("OutlinePaint");
        jButton.addActionListener(this);
        jPanel3.add((Component)this.outlinePaintSample);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Background paint:"));
        jButton = new JButton("Select...");
        jButton.setActionCommand("BackgroundPaint");
        jButton.addActionListener(this);
        jPanel3.add((Component)this.backgroundPaintSample);
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel4.add((Component)jPanel2, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Axis axis = null;
        if (plot instanceof CategoryPlot) {
            axis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            axis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = AxisPropertyEditPanel.getInstance(axis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add("Domain Axis", this.domainAxisPropertyPanel);
        }
        ValueAxis valueAxis = null;
        if (plot instanceof CategoryPlot) {
            valueAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            valueAxis = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = AxisPropertyEditPanel.getInstance(valueAxis);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add("Range Axis", this.rangeAxisPropertyPanel);
        }
        jTabbedPane.add("Appearance", jPanel4);
        jPanel.add(jTabbedPane);
        this.add(jPanel);
    }

    public Insets getPlotInsets() {
        if (this.plotInsets == null) {
            this.plotInsets = new Insets(0, 0, 0, 0);
        }
        return this.plotInsets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public AxisPropertyEditPanel getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public AxisPropertyEditPanel getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (string.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (string.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (string.equals("Insets")) {
            this.editInsets();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color color = JColorChooser.showDialog(this, "Background Color", Color.blue);
        if (color != null) {
            this.backgroundPaintSample.setPaint((Paint)color);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int n = JOptionPane.showConfirmDialog(this, strokeChooserPanel, "Stroke Selection", 2, -1);
        if (n == 0) {
            this.outlineStrokeSample.setStroke(strokeChooserPanel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color color = JColorChooser.showDialog(this, "Outline Color", Color.blue);
        if (color != null) {
            this.outlinePaintSample.setPaint((Paint)color);
        }
    }

    private void editInsets() {
        InsetsChooserPanel insetsChooserPanel = new InsetsChooserPanel(this.plotInsets);
        int n = JOptionPane.showConfirmDialog(this, insetsChooserPanel, "Edit Insets", 2, -1);
        if (n == 0) {
            this.plotInsets = insetsChooserPanel.getInsets();
            this.insetsTextField.setInsets(this.plotInsets);
        }
    }

    public void updatePlotProperties(Plot plot) {
        Plot plot2;
        Axis axis;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null) {
            axis = null;
            if (plot instanceof CategoryPlot) {
                plot2 = (CategoryPlot)plot;
                axis = ((CategoryPlot)plot2).getDomainAxis();
            } else if (plot instanceof XYPlot) {
                plot2 = (XYPlot)plot;
                axis = ((XYPlot)plot2).getDomainAxis();
            }
            if (axis != null) {
                this.domainAxisPropertyPanel.setAxisProperties(axis);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            axis = null;
            if (plot instanceof CategoryPlot) {
                plot2 = (CategoryPlot)plot;
                axis = ((CategoryPlot)plot2).getRangeAxis();
            } else if (plot instanceof XYPlot) {
                plot2 = (XYPlot)plot;
                axis = ((XYPlot)plot2).getRangeAxis();
            }
            if (axis != null) {
                this.rangeAxisPropertyPanel.setAxisProperties(axis);
            }
        }
    }
}

