/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.OperaPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;

public abstract class OperaSupport {
    protected static final String OPERA_PREFERENCES = "opera.ini";
    protected static final String OPERA_6_PREFERENCES = "opera6.ini";
    protected boolean useDefault;
    private static final String INSTALL_SECTION = "INSTALL";
    private static final String VERSION_KEY = "OVER";
    private static final float OPERA_2_PREFERENCE_VERSION = 5.0f;
    private static final float LAST_TESTED_OPERA_PREFERENCE_VERSION = 7.11f;
    private static final String FILE_TYPES_SECTION_INFO = "File Types Section Info";
    private static final String FILE_TYPES_VERSION_KEY = "Version";
    private static final String FILE_TYPES = "File Types";
    private static final String FILE_TYPES_KEY = "application/x-java-jnlp-file";
    private static final String FILE_TYPES_VALUE = "{0},{1},,,jnlp,|";
    private static final String EXPLICIT_PATH = "3";
    private static final String IMPLICIT_PATH = "4";
    private static final String FILE_TYPES_EXTENSION = "File Types Extension";
    private static final String FILE_TYPES_EXTENSION_KEY = "application/x-java-jnlp-file";
    private static final String FILE_TYPES_EXTENSION_VALUE = ",0";

    public abstract boolean isInstalled();

    public abstract void enableJnlp(File var1, boolean var2);

    protected void enableJnlp(OperaPreferences operaPreferences, File file, File file2, boolean bl) throws IOException {
        if (operaPreferences == null) {
            operaPreferences = this.getPreferences(file);
        }
        if (operaPreferences != null) {
            float f = 5.0f;
            String string = operaPreferences.get(INSTALL_SECTION, VERSION_KEY);
            if (string != null) {
                try {
                    f = Float.parseFloat(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    Trace.println((String)"Unable to determine Opera version from the preference file; assuming 5.0 or higher.", (TraceLevel)TraceLevel.BASIC);
                }
            }
            if (f < 5.0f) {
                operaPreferences.put(FILE_TYPES_SECTION_INFO, FILE_TYPES_VERSION_KEY, "1");
            } else if (!operaPreferences.containsKey(FILE_TYPES_SECTION_INFO, FILE_TYPES_VERSION_KEY)) {
                if (f > 7.11f) {
                    Trace.println((String)"Setting '[File Types Section Info]Version=2' in the Opera preference file.", (TraceLevel)TraceLevel.BASIC);
                }
                operaPreferences.put(FILE_TYPES_SECTION_INFO, FILE_TYPES_VERSION_KEY, "2");
            }
            if (bl || !operaPreferences.containsKey(FILE_TYPES, "application/x-java-jnlp-file")) {
                Object[] objectArray = new Object[]{null, null};
                if (f < 5.0f || !this.useDefault) {
                    objectArray[0] = EXPLICIT_PATH;
                    try {
                        objectArray[1] = file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        objectArray[1] = file2.getAbsolutePath();
                    }
                } else {
                    objectArray[0] = IMPLICIT_PATH;
                    objectArray[1] = "";
                }
                operaPreferences.put(FILE_TYPES, "application/x-java-jnlp-file", MessageFormat.format(FILE_TYPES_VALUE, objectArray));
            }
            if (f >= 5.0f && !operaPreferences.containsKey(FILE_TYPES_EXTENSION, "application/x-java-jnlp-file")) {
                operaPreferences.put(FILE_TYPES_EXTENSION, "application/x-java-jnlp-file", FILE_TYPES_EXTENSION_VALUE);
            }
            operaPreferences.store(new FileOutputStream(file));
        }
    }

    protected OperaPreferences getPreferences(File file) throws IOException {
        OperaPreferences operaPreferences = null;
        if (file.exists()) {
            if (file.canRead()) {
                if (file.canWrite()) {
                    operaPreferences = new OperaPreferences();
                    operaPreferences.load(new FileInputStream(file));
                } else {
                    Trace.println((String)("No write access to the Opera preference file (" + file.getAbsolutePath() + ")."), (TraceLevel)TraceLevel.BASIC);
                }
            } else {
                Trace.println((String)("No read access to the Opera preference file (" + file.getAbsolutePath() + ")."), (TraceLevel)TraceLevel.BASIC);
            }
        } else {
            Trace.println((String)("The Opera preference file (" + file.getAbsolutePath() + ") does not exist."), (TraceLevel)TraceLevel.BASIC);
        }
        return operaPreferences;
    }

    protected OperaSupport(boolean bl) {
        this.useDefault = bl;
    }
}

