/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.awt.AppContext;

class DeployFileOutputStream
extends FileOutputStream {
    private URL _url;
    private URLConnection _conn;
    private File _file;
    private boolean closed = false;
    private boolean finalized = false;
    private boolean aborted = false;

    DeployFileOutputStream(File file, URL uRL, URLConnection uRLConnection) throws FileNotFoundException {
        super(file);
        this._url = uRL;
        this._conn = uRLConnection;
        this._file = file;
    }

    void setAbort(boolean bl) {
        this.aborted = bl;
    }

    protected void finalize() throws IOException {
        this.finalized = true;
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        super.close();
        if (this.closed) return;
        if (this.finalized) return;
        if (this.aborted) {
            return;
        }
        this.closed = true;
        URL uRL = HttpUtils.removeQueryStringFromURL(this._url);
        String string = this._url.getQuery();
        String string2 = (String)AppContext.getAppContext().get(Config.getAppContextKeyPrefix() + uRL.toString());
        boolean bl = false;
        String string3 = this._conn.getContentType();
        if (string3 != null && string3.equalsIgnoreCase("application/x-java-jnlp-error")) {
            throw new IOException("version requested not returned");
        }
        String string4 = this._conn.getHeaderField("x-java-jnlp-version-id");
        if (string4 == null && Environment.isJavaPlugin()) {
            string4 = string2;
        }
        bl = string3 != null && string3.equalsIgnoreCase("application/x-java-archive-diff");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileInputStream(DeployFileOutputStream.this._file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
        }
        try {
            CacheEntry cacheEntry;
            CacheEntry cacheEntry2 = Cache.downloadResourceToCache(uRL, string4, this._conn, this._url, bl, 0, fileInputStream);
            if (cacheEntry2 != null && (cacheEntry = (CacheEntry)MemoryCache.addLoadedResource(uRL.toString(), cacheEntry2)) != null && cacheEntry.getVersion() == null && cacheEntry2.getVersion() == null) {
                Cache.markResourceIncomplete(cacheEntry);
            }
        }
        catch (CanceledDownloadException canceledDownloadException) {
            try {
                throw new IOException(canceledDownloadException.getMessage());
            }
            catch (Throwable throwable) {
                super.close();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            if (DeployFileOutputStream.this._file != null) {
                                DeployFileOutputStream.this._file.delete();
                            }
                            return null;
                        }
                    });
                    throw throwable;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Trace.ignoredException(privilegedActionException);
                }
                throw throwable;
            }
        }
        super.close();
        try {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
            return;
        }
    }
}

