/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: overlayline.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_OVERLAY_OVERLAYLINE_HXX
#define _SDR_OVERLAY_OVERLAYLINE_HXX

#include <svx/sdr/overlay/overlayobject.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		class OverlayLineStriped : public OverlayObjectWithBasePosition
		{
		protected:
			// second position in pixel
			basegfx::B2DPoint						maSecondPosition;

			// Draw geometry
			virtual void drawGeometry(OutputDevice& rOutputDevice);

			// Create the BaseRange. This method needs to calculate maBaseRange.
			virtual void createBaseRange(OutputDevice& rOutputDevice);

		public:
			OverlayLineStriped(
				const basegfx::B2DPoint& rBasePos,
				const basegfx::B2DPoint& rSecondPos);
			virtual ~OverlayLineStriped();

			// change second position
			const basegfx::B2DPoint& getSecondPosition() const { return maSecondPosition; }
			void setSecondPosition(const basegfx::B2DPoint& rNew);

			// Hittest with logical coordinates
			virtual sal_Bool isHit(const basegfx::B2DPoint& rPos, double fTol = 0.0) const;

			// transform object coordinates. Needs to transform maSecondPosition.
			virtual void transform(const basegfx::B2DHomMatrix& rMatrix);
		};
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		class OverlayLine : public OverlayLineStriped
		{
		protected:
			// Draw geometry
			virtual void drawGeometry(OutputDevice& rOutputDevice);

		public:
			OverlayLine(
				const basegfx::B2DPoint& rBasePos,
				const basegfx::B2DPoint& rSecondPos,
				Color aLineColor = Color(COL_BLACK));
			virtual ~OverlayLine();
		};
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_OVERLAY_OVERLAYLINE_HXX

// eof
